# 画面設計書 10-audit

## 概要

本ドキュメントは、Bun CLIの`audit`コマンドの設計仕様を記述する。`bun audit`コマンドは、インストールされたパッケージのセキュリティ脆弱性をチェックする機能を提供する。

### 本画面の処理概要

`bun audit`コマンドは、プロジェクトの依存関係をnpmの脆弱性データベースと照合し、既知のセキュリティ脆弱性を持つパッケージを報告する。重大度別の分類、修正方法の提案、依存関係パスの表示などを行う。

**業務上の目的・背景**：現代のソフトウェア開発では、多数のサードパーティパッケージに依存する。これらのパッケージに存在するセキュリティ脆弱性を検出し、適切に対処することは、アプリケーションのセキュリティを確保する上で不可欠である。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun audit` - 全依存関係の脆弱性をチェック
- `bun audit --json` - JSON形式で出力
- `bun audit --production` - 本番依存関係のみチェック

**主要な操作・処理内容**：
1. lockfileから依存関係情報を収集
2. パッケージ名とバージョンのリストを構築
3. npmの脆弱性APIにリクエスト送信
4. レスポンスを解析し脆弱性情報を抽出
5. 依存関係パスを計算
6. 重大度別にレポートを生成
7. 修正提案を表示

**画面遷移**：
- エントリーポイント：`bun audit` コマンドから直接実行
- 遷移先：レポート表示後はターミナルに制御を返す
- 関連コマンド：`bun update`（脆弱性修正のためのアップデート）

**権限による表示制御**：特になし。ファイルシステムの読み取り権限とネットワーク接続が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | bun audit | 主機能 | 脆弱性チェックとレポート生成 |
| 41 | npmレジストリ | 補助機能 | 脆弱性APIへの問い合わせ |
| 42 | lockfile管理 | 補助機能 | 依存関係情報の読み取り |

## 画面種別

コマンドラインインターフェース（CLI）- セキュリティ監査コマンド

## URL/ルーティング

コマンドラインパターン:
- `bun audit [flags]`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| --json | flag | No | JSON形式で出力 |
| --production | flag | No | 本番依存関係のみチェック |
| --level | string | No | 報告する最小重大度（low/moderate/high/critical） |
| --ignore | string[] | No | 無視するCVE ID |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 脆弱性レポート | text/json | 検出された脆弱性の一覧 |
| サマリー | text | 重大度別の脆弱性数 |
| 修正提案 | text | 推奨されるアップデートコマンド |
| exit code | number | 0: 脆弱性なし、1: 脆弱性あり |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| バージョン表示 | 常時 | `bun audit v{version}` |
| 脆弱性パッケージ | 脆弱性検出時 | パッケージ名と影響バージョン |
| 重大度 | 脆弱性検出時 | critical/high/moderate/low |
| 脆弱性タイトル | 脆弱性検出時 | 脆弱性の概要説明 |
| 脆弱性URL | 脆弱性検出時 | 詳細情報へのリンク |
| 依存関係パス | 脆弱性検出時 | ルートからの依存パス |
| サマリー統計 | 完了時 | 重大度別の件数集計 |
| 修正コマンド | 脆弱性検出時 | `bun update`等の提案 |

## イベント仕様

### 1-脆弱性チェック

ユーザーが`bun audit`を実行した場合の処理フロー：

1. コマンドライン引数の解析（CommandLineArguments.parse）
2. PackageManagerの初期化
3. lockfileからパッケージ情報を収集（collectPackagesForAudit）
4. 依存関係ツリーを構築（buildDependencyTree）
5. npmの脆弱性APIにリクエスト送信（sendAuditRequest）
6. レスポンスを解析し脆弱性情報を抽出
7. 依存関係パスを計算（findDependencyPaths）
8. レポートを生成・表示（printEnhancedAuditReport）
9. 終了コードを返却

### 2-JSON出力

--jsonオプション指定時の処理フロー：

1. 通常のチェック処理を実行
2. レスポンスをそのままJSON形式で出力
3. 脆弱性がなければ終了コード0、あれば終了コード1

### 3-本番依存関係のみ

--productionオプション指定時の処理フロー：

1. 本番依存関係のパッケージセットを構築（buildProductionPackageSet）
2. devDependenciesを除外したパッケージリストを作成
3. 脆弱性チェックを実行

## データベース更新仕様

本コマンドはデータベースを使用しない。外部のnpm脆弱性APIを使用。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| VERSION | info | bun audit v{version} | コマンド開始時 |
| NO_VULN | success | No vulnerabilities found | 脆弱性なし |
| VULN_FOUND | warning | {count} vulnerabilities ({critical} critical, {high} high, ...) | 脆弱性検出 |
| NO_PACKAGE_JSON | error | No package.json was found for directory "{cwd}" | package.jsonがない |
| FIX_SUGGESTION | info | To update all dependencies to the latest versions: bun update --latest | 修正提案 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| package.json不在 | ファイルが存在しない | エラーメッセージを表示し`bun init`を提案 |
| ネットワークエラー | 脆弱性APIへの接続失敗 | エラーメッセージを表示 |
| JSON解析エラー | レスポンスの解析失敗 | エラーメッセージを表示 |
| レジストリエラー | ステータスコード400以上 | エラーメッセージを表示 |

## 備考

- npm互換の脆弱性API（`/-/npm/v1/security/advisories/bulk`）を使用
- gzip圧縮でリクエストを送信
- 認証トークン/Basic認証をサポート
- デフォルトレジストリ以外のパッケージはスキップされる
- --ignoreで特定のCVEを無視可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

auditコマンドで使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | audit_command.zig | `src/cli/audit_command.zig` | VulnerabilityInfo、PackageInfo、AuditResult構造体（行1-48） |

**主要構造体**:
- **VulnerabilityInfo（行1-8）**: 脆弱性情報（severity, title, url, vulnerable_versions, id, package_name）
- **PackageInfo（行10-21）**: パッケージ情報と関連する脆弱性・依存パス
- **AuditResult（行23-48）**: 監査結果全体を保持

#### Step 2: エントリーポイントを理解する

auditコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | audit_command.zig | `src/cli/audit_command.zig` | AuditCommand構造体のexec関数（行50-70） |

**主要処理フロー**:
1. **行52**: CommandLineArguments.parseでオプション解析
2. **行53-66**: PackageManager.initでpackage.jsonの存在確認
3. **行68**: audit関数の呼び出し
4. **行69**: 終了コードでexit

#### Step 3: 監査処理を理解する

メインの監査処理ロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | audit_command.zig | `src/cli/audit_command.zig` | audit関数（行75-134） |

**主要処理フロー**:
- **行76-77**: バージョン表示
- **行79-80**: lockfileの読み込み
- **行82-83**: 依存関係ツリー構築（buildDependencyTree）
- **行85-86**: 監査用パッケージ収集（collectPackagesForAudit）
- **行94**: 監査リクエスト送信（sendAuditRequest）
- **行97-121**: JSON出力または拡張レポート出力

#### Step 4: 詳細処理を理解する

各ヘルパー関数の処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | audit_command.zig | `src/cli/audit_command.zig` | buildDependencyTree（行155-189）、collectPackagesForAudit（行235-342）、sendAuditRequest（行344-407） |

**主要処理フロー**:
- **buildDependencyTree**: lockfileから依存関係ツリーを構築
- **buildProductionPackageSet（行191-233）**: 本番パッケージセットを構築
- **collectPackagesForAudit**: 監査対象パッケージを収集しJSON形式のボディを作成
- **sendAuditRequest**: gzip圧縮してnpm脆弱性APIにPOSTリクエスト

### プログラム呼び出し階層図

```
AuditCommand.exec()
    |
    +-- CommandLineArguments.parse()
    |
    +-- PackageManager.init()
    |
    +-- audit()
            |
            +-- lockfile.loadFromCwd()
            |
            +-- buildDependencyTree()
            |
            +-- collectPackagesForAudit()
            |       |
            |       +-- [--production時] buildProductionPackageSet()
            |
            +-- sendAuditRequest()
            |       |
            |       +-- gzip圧縮
            |       +-- HTTP POST
            |
            +-- [--json時]
            |       +-- JSON出力
            |
            +-- [通常時]
                    +-- printEnhancedAuditReport()
                            |
                            +-- parseVulnerability()
                            +-- findDependencyPaths()
                            +-- 重大度別集計
                            +-- レポート表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bun audit [flags] ------> AuditCommand.exec() -------> 処理開始
        |
        v
lockfile ---------------> パッケージ情報収集 ---------> パッケージリスト
        |
        v
                          依存関係ツリー構築 ---------> dependency_tree
        |
        v
[--production時]
                          本番パッケージセット -------> prod_packages
        |
        v
                          JSON ボディ生成 -----------> {"pkg": ["ver"]}
        |
        v
npm /-/npm/v1/... ------> HTTP POST (gzip) ---------> レスポンスJSON
        |
        v
                          脆弱性情報解析 ------------> VulnerabilityInfo[]
        |
        v
                          依存パス計算 --------------> DependencyPath[]
        |
        v
                          レポート生成 --------------> stdout / JSON
        |
        v
                          exit code (0 or 1) --------> 終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| audit_command.zig | `src/cli/audit_command.zig` | ソース | auditコマンドのメイン実装 |
| package_manager_command.zig | `src/cli/package_manager_command.zig` | ソース | handleLoadLockfileErrors |
| install.zig | `src/install/install.zig` | ソース | PackageManager本体 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile読み込み |
| CommandLineArguments.zig | `src/install/PackageManager/CommandLineArguments.zig` | ソース | AuditLevel定義 |
| libdeflate.zig | `src/deps/libdeflate.zig` | ソース | gzip圧縮処理 |
