# 画面設計書 11-outdated

## 概要

本ドキュメントは、Bun CLIの `bun outdated` コマンドの画面設計書です。インストール済みの依存関係パッケージの中で古くなっているものを検出し、最新バージョン情報を表示するコマンドの仕様を定義します。

### 本画面の処理概要

`bun outdated` コマンドは、プロジェクトの依存関係の中で最新バージョンが利用可能なパッケージを一覧表示する機能を提供します。

**業務上の目的・背景**：ソフトウェア開発において、依存パッケージを最新状態に保つことはセキュリティ修正や新機能の取り込みのために重要です。本コマンドは、どのパッケージが古くなっているかを迅速に確認し、アップデート計画を立てるために使用されます。package.jsonとロックファイルに記載されたバージョンと、npmレジストリ上の最新バージョンを比較して差分を表示します。

**画面へのアクセス方法**：ターミナルで `bun outdated` を実行します。package.jsonが存在するディレクトリで実行する必要があります。

**主要な操作・処理内容**：
1. コマンドライン引数の解析とPackageManagerの初期化
2. ロックファイル（bun.lockb または bun.lock）の読み込み
3. 各パッケージについてnpmレジストリから最新バージョン情報を取得
4. 現在バージョン、更新可能バージョン、最新バージョンの比較
5. テーブル形式での結果表示

**画面遷移**：単独で実行されるCLIコマンドであり、他の画面への遷移はありません。実行後はターミナルに戻ります。

**権限による表示制御**：特別な権限制御はありませんが、プライベートレジストリを使用する場合は認証情報が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | bun outdated | 主機能 | 古い依存関係の検出と最新バージョン表示 |
| 41 | npmレジストリ | 補助機能 | パッケージの最新バージョン情報取得 |

## 画面種別

一覧表示（テーブル形式）

## URL/ルーティング

```
bun outdated [package-patterns...] [options]
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| package-patterns | string[] | いいえ | 特定パッケージのみを対象とするためのパターン（glob対応） |
| --filter | string | いいえ | ワークスペースフィルタ（名前またはパスでフィルタ） |
| --recursive | boolean | いいえ | すべてのワークスペースを対象とする |
| --silent | boolean | いいえ | 出力を抑制する |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Package | string | パッケージ名（依存タイプ付き） |
| Current | string | 現在インストールされているバージョン |
| Update | string | セマンティックバージョニングに基づく更新可能バージョン |
| Latest | string | 最新リリースバージョン |
| Workspace | string | ワークスペース名（フィルタ使用時のみ） |

## 表示項目

### 出力テーブル

| カラム | 説明 | 例 |
|--------|------|-----|
| Package | パッケージ名と依存タイプ | react (dev) |
| Current | 現在バージョン | 17.0.2 |
| Update | semver範囲内の最新 | 17.0.3 |
| Latest | 最新バージョン | 18.2.0 |
| Workspace | ワークスペース名 | @myorg/package |

## イベント仕様

### 1-outdated実行

コマンド実行時の処理フロー：

1. `OutdatedCommand.exec()` がエントリーポイントとして呼び出される
2. コマンドライン引数を `PackageManager.CommandLineArguments.parse()` で解析
3. `PackageManager.init()` でパッケージマネージャーを初期化
4. `outdated()` 関数でロックファイルを読み込み
5. フィルタパターンに応じてワークスペースを特定
6. `manager.populateManifestCache()` でnpmレジストリから最新情報を取得
7. `printOutdatedInfoTable()` でテーブル形式の結果を出力

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはデータベース操作を行いません（読み取り専用）。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| outdated実行 | なし | SELECT | ロックファイルとマニフェストキャッシュの読み込みのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| OUTDATED_001 | 情報 | bun outdated v{version} | コマンド開始時 |
| OUTDATED_002 | エラー | missing package.json, nothing outdated | package.jsonが存在しない場合 |
| OUTDATED_003 | エラー | missing lockfile, nothing outdated | ロックファイルが存在しない場合 |
| OUTDATED_004 | エラー | failed to open/parse/read lockfile: {error} | ロックファイル読み込みエラー |
| OUTDATED_005 | 注記 | The * indicates that version isn't true latest due to minimum release age | フィルタされたバージョンがある場合 |

## 例外処理

| 例外条件 | 処理内容 | エラーコード |
|---------|---------|------------|
| package.json未検出 | エラーメッセージを表示して終了 | 1 |
| ロックファイル未検出 | エラーメッセージを表示して終了 | 1 |
| ロックファイル解析エラー | エラー詳細を表示して終了 | 1 |
| レジストリ接続エラー | 該当パッケージをスキップ | - |

## 備考

- catalog依存関係は複数ワークスペースでグループ化されて表示される
- --filterオプションでワークスペース名またはパスでフィルタリング可能
- minimum_release_ageオプションでリリースから一定期間経過したバージョンのみを対象にできる
- 依存タイプ（dev/peer/optional）は括弧付きで表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、outdatedコマンドで使用される主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | outdated_command.zig | `src/cli/outdated_command.zig` | OutdatedInfo構造体（L2-7）：パッケージID、依存ID、ワークスペースパッケージID、catalog判定フラグを保持 |
| 1-2 | outdated_command.zig | `src/cli/outdated_command.zig` | GroupedOutdatedInfo構造体（L221-227）：グループ化されたoutdated情報とワークスペース名 |

**読解のコツ**: ZigではstructはC言語のstructに近い。`PackageID`と`DependencyID`は整数型のエイリアスでインデックスとして使用される。

#### Step 2: エントリーポイントを理解する

処理の起点となるexec関数を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | outdated_command.zig | `src/cli/outdated_command.zig` | exec関数（L9-28）：メイン処理の開始点 |

**主要処理フロー**:
1. **L10**: バージョン情報を含むヘッダーを出力
2. **L13**: コマンドライン引数を.outdatedモードで解析
3. **L15-24**: PackageManagerを初期化（エラー時はクラッシュ）
4. **L27**: outdated関数を呼び出して実際の処理を実行

#### Step 3: outdated関数を理解する

メインロジックを担当するoutdated関数を読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | outdated_command.zig | `src/cli/outdated_command.zig` | outdated関数（L30-101）：ロックファイル読み込みとテーブル出力制御 |

**主要処理フロー**:
- **L31-36**: ロックファイルをカレントディレクトリから読み込み
- **L38-70**: ロックファイルの読み込み結果をswitch文で処理（not_found/err/ok）
- **L72-100**: ANSIカラー対応でフィルタリングとテーブル出力を実行

#### Step 4: テーブル出力処理を理解する

printOutdatedInfoTable関数でテーブル形式の出力を行います。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | outdated_command.zig | `src/cli/outdated_command.zig` | printOutdatedInfoTable関数（L323-688）：テーブル形式での出力ロジック |

**主要処理フロー**:
- **L329-364**: パッケージパターンの解析とFilterType変換
- **L388-495**: 各ワークスペースの依存関係をループしてoutdated判定
- **L500-513**: catalog依存関係のグループ化処理
- **L525-556**: テーブルヘッダーと列幅の計算・初期化
- **L558-684**: 依存タイプ別にソートされた結果をテーブル出力

### プログラム呼び出し階層図

```
OutdatedCommand.exec()
    │
    ├─ PackageManager.CommandLineArguments.parse(.outdated)
    │
    ├─ PackageManager.init()
    │
    └─ outdated()
           │
           ├─ manager.lockfile.loadFromCwd()
           │
           ├─ findMatchingWorkspaces() [フィルタ使用時]
           │      └─ WorkspaceFilter.init()
           │
           ├─ getAllWorkspaces() [--recursive時]
           │
           ├─ manager.populateManifestCache()
           │
           └─ printOutdatedInfoTable()
                  │
                  ├─ groupCatalogDependencies()
                  │
                  ├─ Table().init()
                  │
                  └─ manifest.findByDistTag() / findBestVersion()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

package.json ───────────▶ PackageManager.init() ────────────┐
                                                            │
bun.lockb/bun.lock ─────▶ loadFromCwd() ───────────────────▶│
                                                            │
                         ┌─────────────────────────────────▶│
                         │                                  ▼
npmレジストリ ──────────▶ populateManifestCache()     printOutdatedInfoTable()
                         │                                  │
                         │   findByDistTag() /              │
                         └── findBestVersion()              ▼

                                                     [テーブル出力]
                                                     ┌─────────────────────────────┐
                                                     │ Package │Current│Update│Latest│
                                                     ├─────────────────────────────┤
                                                     │ react   │17.0.2 │17.0.3│18.2.0│
                                                     └─────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| outdated_command.zig | `src/cli/outdated_command.zig` | ソース | outdatedコマンドのメイン実装 |
| install.zig | `src/install/install.zig` | ソース | PackageManager定義 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | ロックファイル読み書き |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリ通信・マニフェスト解析 |
| dependency.zig | `src/install/dependency.zig` | ソース | 依存関係の型定義 |
| fmt.zig | `src/fmt.zig` | ソース | Table形式出力ユーティリティ |
