# 画面設計書 15-patch

## 概要

本ドキュメントは、Bun CLIの `bun patch` コマンドの画面設計書です。インストール済みパッケージに対してパッチを当てるための準備を行う機能の仕様を定義します。

### 本画面の処理概要

`bun patch` コマンドは、node_modulesにインストールされたパッケージの内容をテンポラリディレクトリにコピーし、開発者がパッチを適用できる状態を作成します。pnpm patchやyarn patchと同等の機能を持ちます。

**業務上の目的・背景**：依存パッケージにバグがある場合や、カスタム修正が必要な場合に、パッケージ自体を修正してパッチファイルを作成できます。パッチはプロジェクトに保存され、インストール時に自動適用されます。これにより、パッケージのforkを作成せずに修正を管理できます。

**画面へのアクセス方法**：パッチを当てたいパッケージを指定して `bun patch <package-name>` を実行します。

**主要な操作・処理内容**：
1. 位置引数からパッケージ名とバージョンを解析
2. ロックファイルから正確なバージョンを特定
3. node_modulesからパッケージの内容をテンポラリディレクトリにコピー
4. 編集後の手順（`bun patch-commit`）を案内

**画面遷移**：コマンド実行後、テンポラリディレクトリのパスが表示されます。開発者はそのディレクトリで編集を行い、`bun patch-commit`でパッチをコミットします。

**権限による表示制御**：特別な権限制御はありません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | bun patch | 主機能 | パッケージパッチの準備 |
| 24 | bun patch-commit | 連携機能 | パッチの確定とファイル生成 |

## 画面種別

コマンド実行（ディレクトリパス表示）

## URL/ルーティング

```
bun patch <package-name[@version]>
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| package-name | string | はい | パッチ対象のパッケージ名（@version指定可） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テンポラリディレクトリパス | string | パッケージがコピーされたディレクトリのパス |
| 次ステップの案内 | string | patch-commitコマンドの実行方法 |

## 表示項目

### 成功時出力

```
You can now edit the following folder:

  {temporary-directory-path}

Once you're done with your changes, run:

  bun patch-commit {temporary-directory-path}
```

## イベント仕様

### 1-パッチ準備

コマンド実行時の処理フロー：

1. `PatchCommand.exec()` がエントリーポイントとして呼び出される
2. `updatePackageJSONAndInstallCatchError()` を `.patch` モードで呼び出し
3. 内部でPackageManagerが初期化され、コマンドライン引数を解析
4. 位置引数からパッケージ名@バージョンを解析
5. ロックファイルからパッケージの正確なバージョンと場所を特定
6. パッケージの内容をテンポラリディレクトリにコピー
7. テンポラリディレクトリのパスと次のステップを出力

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはファイルシステム操作を行います。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| パッチディレクトリ作成 | テンポラリディレクトリ | CREATE | パッケージ内容のコピー先を作成 |
| パッケージ内容コピー | テンポラリディレクトリ | COPY | node_modules内のパッケージをコピー |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| PATCH_001 | 情報 | You can now edit the following folder: | 正常完了時 |
| PATCH_002 | 情報 | Once you're done with your changes, run: | 正常完了時 |
| PATCH_003 | 情報 | bun patch-commit {path} | 正常完了時 |
| PATCH_004 | エラー | Package not found in lockfile | パッケージが見つからない場合 |
| PATCH_005 | エラー | Multiple versions found, specify version | バージョンが複数ある場合 |

## 例外処理

| 例外条件 | 処理内容 | エラーコード |
|---------|---------|------------|
| パッケージ名未指定 | 使用方法を表示して終了 | 1 |
| ロックファイル未検出 | エラーメッセージを表示して終了 | 1 |
| パッケージがロックファイルにない | エラーメッセージを表示して終了 | 1 |
| バージョンが複数存在 | バージョン指定を要求して終了 | 1 |
| テンポラリディレクトリ作成失敗 | エラーメッセージを表示して終了 | 1 |

## 備考

- パッケージ名は `@scope/name@version` 形式でバージョンを含められる
- テンポラリディレクトリはシステムのテンポラリ領域に作成される
- 編集完了後は `bun patch-commit` でパッチファイルを生成
- 生成されたパッチは `patches/` ディレクトリに保存され、package.jsonのpatchedDependenciesに登録される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

patchコマンドはPackageManager内部で処理されるため、関連する依存関係構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dependency.zig | `src/install/dependency.zig` | Dependency構造体：パッケージ依存関係の表現 |
| 1-2 | lockfile.zig | `src/install/lockfile.zig` | Lockfile構造体：ロックファイルからのパッケージ情報取得 |

**読解のコツ**: patchコマンドは `updatePackageJSONAndInstallCatchError` を通じてPackageManagerの機能を再利用しています。

#### Step 2: エントリーポイントを理解する

処理の起点となるexec関数を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | patch_command.zig | `src/cli/patch_command.zig` | exec関数（L6-8）：updatePackageJSONAndInstallCatchErrorへの委譲 |

**主要処理フロー**:
1. **L7**: `updatePackageJSONAndInstallCatchError` を `.patch` モードで呼び出し
2. 内部でPackageManagerが引数を解析してパッチ処理を実行

#### Step 3: PackageManagerのパッチ処理を理解する

PackageManager内部のパッチ処理フローを読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | install.zig | `src/install/install.zig` | updatePackageJSONAndInstallCatchError：パッチ処理のエントリー |
| 3-2 | install.zig | `src/install/install.zig` | Subcommand.patch分岐：パッチ固有の処理 |

**主要処理フロー**:
- 位置引数からパッケージ名@バージョンを `splitNameAndVersionOrLatest` で分解
- ロックファイルをロードしてパッケージを検索
- node_modulesからパッケージディレクトリを特定
- テンポラリディレクトリにコピー
- 編集案内を出力

### プログラム呼び出し階層図

```
PatchCommand.exec()
    │
    └─ updatePackageJSONAndInstallCatchError(.patch)
           │
           ├─ PackageManager.CommandLineArguments.parse(.patch)
           │
           ├─ PackageManager.init()
           │
           ├─ Dependency.splitNameAndVersionOrLatest()
           │      └─ パッケージ名とバージョンを分離
           │
           ├─ lockfile.loadFromCwd()
           │      └─ ロックファイルからパッケージ情報取得
           │
           ├─ テンポラリディレクトリ作成
           │
           ├─ パッケージ内容コピー
           │
           └─ 編集案内を出力
```

### データフロー図

```
[入力]                      [処理]                           [出力]

package-name[@version] ──▶ splitNameAndVersionOrLatest() ─────┐
                                                              │
bun.lockb/bun.lock ──────▶ lockfile.loadFromCwd() ───────────▶│
                                                              │
                           パッケージ情報照合                   │
                                  │                           │
                                  ▼                           │
node_modules/{package} ─▶ テンポラリディレクトリにコピー        ▼

                                                    [テンポラリディレクトリ]
                                                    /tmp/bun-patch-xxx/
                                                              │
                                                              ▼
                                                    [出力メッセージ]
                                                    You can now edit...
                                                    bun patch-commit {path}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| patch_command.zig | `src/cli/patch_command.zig` | ソース | patchコマンドのエントリーポイント |
| install.zig | `src/install/install.zig` | ソース | PackageManager、パッチ処理の実装 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | ロックファイル読み書き |
| dependency.zig | `src/install/dependency.zig` | ソース | 依存関係の型定義、splitNameAndVersionOrLatest |
| patch_commit_command.zig | `src/cli/patch_commit_command.zig` | ソース | 関連：パッチコミット処理 |
