# 画面設計書 16-patch-commit

## 概要

本ドキュメントは、Bun CLIの `bun patch-commit` コマンドの画面設計書です。`bun patch` で作成したテンポラリディレクトリの変更内容からパッチファイルを生成し、プロジェクトに適用する機能の仕様を定義します。

### 本画面の処理概要

`bun patch-commit` コマンドは、開発者が編集したテンポラリディレクトリと元のパッケージを比較してdiffを生成し、パッチファイルとして保存します。pnpm patch-commitやyarn patch-commitと同等の機能を持ちます。

**業務上の目的・背景**：`bun patch` でテンポラリディレクトリにコピーしたパッケージに修正を加えた後、その変更をパッチファイルとして永続化します。パッチファイルはプロジェクトリポジトリにコミットでき、将来のインストール時に自動適用されます。これにより、チーム全体で修正を共有できます。

**画面へのアクセス方法**：`bun patch` で表示されたテンポラリディレクトリパスを指定して `bun patch-commit <temp-directory>` を実行します。

**主要な操作・処理内容**：
1. 位置引数からテンポラリディレクトリパスを取得
2. テンポラリディレクトリ内のpackage.jsonからパッケージ情報を取得
3. 元のパッケージ（node_modulesまたはキャッシュ）と差分を計算
4. patches/ディレクトリにパッチファイルを生成
5. package.jsonのpatchedDependenciesに登録
6. パッケージを再インストールしてパッチを適用

**画面遷移**：コマンド実行後、パッチファイル作成の成功メッセージが表示され、パッケージが再インストールされます。

**権限による表示制御**：特別な権限制御はありません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | bun patch-commit | 主機能 | パッチファイルの生成と適用 |
| 23 | bun patch | 前提機能 | パッチ準備（テンポラリディレクトリ作成） |

## 画面種別

コマンド実行（成功メッセージ出力、再インストール進捗表示）

## URL/ルーティング

```
bun patch-commit <temp-directory>
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| temp-directory | string | はい | `bun patch` で作成されたテンポラリディレクトリのパス |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| パッチファイルパス | string | 生成されたパッチファイルの保存先パス |
| 再インストール進捗 | string | パッケージ再インストールの進捗表示 |
| 成功メッセージ | string | 処理完了時のメッセージ |

## 表示項目

### 成功時出力

```
Created patch file:
  patches/{package-name}@{version}.patch

Updated package.json with patchedDependencies

Reinstalling packages...
[インストール進捗表示]
```

## イベント仕様

### 1-パッチコミット

コマンド実行時の処理フロー：

1. `PatchCommitCommand.exec()` がエントリーポイントとして呼び出される
2. `updatePackageJSONAndInstallCatchError()` を `.patch-commit` モードで呼び出し
3. 内部でPackageManagerが初期化され、コマンドライン引数を解析
4. 位置引数からテンポラリディレクトリパスを取得
5. テンポラリディレクトリ内のpackage.jsonを解析
6. 元のパッケージと差分を計算（diff生成）
7. patches/ディレクトリにパッチファイルを書き出し
8. package.jsonのpatchedDependenciesを更新
9. パッケージを再インストールしてパッチを適用

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはファイルシステムへの書き込みを行います。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| パッチファイル作成 | patches/{package}@{version}.patch | CREATE | 差分パッチファイルを生成 |
| package.json更新 | package.json | UPDATE | patchedDependenciesセクションを追加/更新 |
| パッケージ再インストール | node_modules | UPDATE | パッチ適用済みパッケージをインストール |
| テンポラリディレクトリ削除 | /tmp/bun-patch-xxx | DELETE | 使用済みテンポラリディレクトリを削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| PATCH_COMMIT_001 | 情報 | Created patch file: | パッチファイル作成時 |
| PATCH_COMMIT_002 | 情報 | Updated package.json with patchedDependencies | package.json更新時 |
| PATCH_COMMIT_003 | 情報 | Reinstalling packages... | 再インストール開始時 |
| PATCH_COMMIT_004 | エラー | Invalid temporary directory | ディレクトリが不正な場合 |
| PATCH_COMMIT_005 | エラー | No changes detected | 変更がない場合 |
| PATCH_COMMIT_006 | エラー | Failed to create patch file | パッチファイル作成失敗 |

## 例外処理

| 例外条件 | 処理内容 | エラーコード |
|---------|---------|------------|
| テンポラリディレクトリ未指定 | 使用方法を表示して終了 | 1 |
| 不正なディレクトリパス | エラーメッセージを表示して終了 | 1 |
| package.jsonがディレクトリ内にない | エラーメッセージを表示して終了 | 1 |
| 元パッケージが見つからない | エラーメッセージを表示して終了 | 1 |
| 変更がない（差分なし） | 警告メッセージを表示して終了 | 0 |
| パッチファイル書き込み失敗 | エラーメッセージを表示して終了 | 1 |

## 備考

- パッチファイル名は `{package-name}@{version}.patch` 形式
- スコープ付きパッケージは `{scope}__{name}@{version}.patch` のように正規化
- パッチ形式はunified diff形式
- patchedDependenciesは`{package-name}@{version}: patches/{patch-file}`形式
- 再インストール時に既存のnode_modulesパッケージにパッチが適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

patch-commitコマンドではパッチ生成とpackage.json更新に関連する構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lockfile.zig | `src/install/lockfile.zig` | patchedDependenciesの管理 |
| 1-2 | package.json | プロジェクトルート | patchedDependenciesフィールドの形式 |

**読解のコツ**: patch-commitもpatchと同様に `updatePackageJSONAndInstallCatchError` を通じて処理されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるexec関数を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | patch_commit_command.zig | `src/cli/patch_commit_command.zig` | exec関数（L2-4）：updatePackageJSONAndInstallCatchErrorへの委譲 |

**主要処理フロー**:
1. **L3**: `updatePackageJSONAndInstallCatchError` を `.patch-commit` モードで呼び出し
2. 内部でPackageManagerが引数を解析してパッチコミット処理を実行

#### Step 3: PackageManagerのパッチコミット処理を理解する

PackageManager内部のパッチコミット処理フローを読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | install.zig | `src/install/install.zig` | updatePackageJSONAndInstallCatchError：パッチコミット処理のエントリー |
| 3-2 | install.zig | `src/install/install.zig` | Subcommand.@"patch-commit"分岐：パッチコミット固有の処理 |

**主要処理フロー**:
- 位置引数からテンポラリディレクトリパスを取得
- ディレクトリ内のpackage.jsonを解析してパッケージ情報取得
- 元パッケージとの差分を計算
- patches/ディレクトリにパッチファイルを書き出し
- package.jsonを更新
- 再インストールを実行

### プログラム呼び出し階層図

```
PatchCommitCommand.exec()
    │
    └─ updatePackageJSONAndInstallCatchError(.@"patch-commit")
           │
           ├─ PackageManager.CommandLineArguments.parse(.@"patch-commit")
           │
           ├─ PackageManager.init()
           │
           ├─ テンポラリディレクトリのpackage.json解析
           │
           ├─ 元パッケージ取得
           │      └─ node_modulesまたはキャッシュから
           │
           ├─ diff計算
           │      └─ ファイル単位で差分を計算
           │
           ├─ パッチファイル生成
           │      └─ patches/{package}@{version}.patch
           │
           ├─ package.json更新
           │      └─ patchedDependenciesに追加
           │
           ├─ テンポラリディレクトリ削除
           │
           └─ 再インストール
                  └─ パッチ適用済みパッケージをインストール
```

### データフロー図

```
[入力]                        [処理]                          [出力]

temp-directory ───────────▶ package.json解析 ─────────────────┐
                                 │                            │
                                 ▼                            │
                           パッケージ情報取得                    │
                                 │                            │
                                 ▼                            │
元パッケージ ─────────────▶ diff計算 ─────────────────────────▶│
(node_modules/cache)                                          │
                                                              ▼
                                                    [パッチファイル]
                                                    patches/{pkg}@{ver}.patch
                                                              │
                                                              ▼
package.json ◀─────────────────────── patchedDependencies追加
                                                              │
                                                              ▼
                                                    [再インストール]
                                                    node_modulesにパッチ適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| patch_commit_command.zig | `src/cli/patch_commit_command.zig` | ソース | patch-commitコマンドのエントリーポイント |
| patch_command.zig | `src/cli/patch_command.zig` | ソース | 関連：パッチ準備処理 |
| install.zig | `src/install/install.zig` | ソース | PackageManager、パッチコミット処理の実装 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | ロックファイル読み書き、patchedDependencies |
| diff.zig | `src/diff.zig` | ソース | diff計算ロジック（存在する場合） |
