# 画面設計書 18-info

## 概要

本ドキュメントは、Bun CLIの `bun info` コマンド（`bun pm view`のエイリアス）の画面設計書です。npmレジストリからパッケージのメタデータを取得して表示する機能の仕様を定義します。

### 本画面の処理概要

`bun info` コマンドは、npmレジストリからパッケージの詳細情報（バージョン、依存関係、メンテナー、ライセンス等）を取得して表示します。`bun pm view` と同等の機能を持ちます。

**業務上の目的・背景**：パッケージをインストールする前に、その詳細情報を確認したい場合に使用します。依存関係の調査、ライセンス確認、最新バージョンの確認など、パッケージ選定や調査に役立ちます。

**画面へのアクセス方法**：`bun info <package-name[@version]>` の形式で実行します。または `bun pm view <package-name[@version]>` でも同じ機能にアクセスできます。

**主要な操作・処理内容**：
1. 位置引数からパッケージ名とバージョンを解析
2. npmレジストリにHTTPリクエストを送信
3. レスポンスをJSONとしてパース
4. 指定バージョン（またはlatest）の情報を抽出
5. フォーマットしてターミナルに出力

**画面遷移**：単独で実行されるCLIコマンドです。情報表示後、ターミナルに戻ります。

**権限による表示制御**：プライベートレジストリの場合は認証情報が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | bun info / bun pm view | 主機能 | パッケージメタデータの表示 |
| 41 | npmレジストリ | 主機能 | レジストリからの情報取得 |

## 画面種別

情報表示（テキスト形式またはJSON形式）

## URL/ルーティング

```
bun info <package-name[@version]> [property-path] [options]
bun pm view <package-name[@version]> [property-path] [options]
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| package-name | string | はい | 表示するパッケージ名（@version指定可） |
| property-path | string | いいえ | 特定プロパティのみ表示（例：version、dependencies） |
| --json | boolean | いいえ | JSON形式で出力 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| パッケージ名 | string | @スコープを含むパッケージ名 |
| バージョン | string | 表示対象のバージョン |
| ライセンス | string | パッケージのライセンス |
| 依存関係数 | number | dependenciesの数 |
| バージョン数 | number | 利用可能なバージョン総数 |
| 説明 | string | パッケージの説明文 |
| ホームページ | string | パッケージのホームページURL |
| キーワード | string[] | パッケージのキーワード一覧 |
| 依存関係 | object | dependencies一覧 |
| dist情報 | object | tarball、shasum、integrity、unpackedSize |
| dist-tags | object | latest、beta等のタグとバージョンのマッピング |
| メンテナー | object[] | メンテナー一覧（name、email） |
| 公開日時 | string | パッケージの公開日時 |

## 表示項目

### 通常出力形式

```
{package-name}@{version} | {license} | deps: {n} | versions: {n}
{description}
{homepage}

keywords: {keyword1}, {keyword2}, ...

dependencies ({n}):
- {dep1}: {version1}
- {dep2}: {version2}
...

dist
 .tarball: {url}
 .shasum: {sha1}
 .integrity: {sha512}
 .unpackedSize: {size}

dist-tags:
latest: {version}
beta: {version}
...

maintainers:
- {name} <{email}>
...

Published: {datetime}
```

### JSON出力形式（--json）

```json
{
  "name": "package-name",
  "version": "1.0.0",
  "description": "...",
  "license": "MIT",
  "dependencies": {...},
  ...
}
```

## イベント仕様

### 1-パッケージ情報取得

コマンド実行時の処理フロー：

1. `PmViewCommand.view()` が呼び出される（pm view経由またはinfo経由）
2. 位置引数からパッケージ名とバージョンを `splitNameAndVersionOrLatest()` で解析
3. スコープに応じたレジストリURLとトークンを取得
4. `AsyncHTTP.initSync()` でレジストリにGETリクエスト
5. レスポンスをJSONとしてパース
6. `PackageManifest.parse()` でマニフェストを解析
7. バージョン指定がある場合は `findByDistTag()` または `findBestVersion()` でマッチング
8. property-pathがある場合は該当プロパティのみ出力
9. --jsonの場合はJSON形式で出力
10. それ以外はフォーマットして出力

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドは読み取り専用です。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| パッケージ情報取得 | npmレジストリ | GET | パッケージメタデータの取得 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| INFO_001 | エラー | view request failed to send | HTTPリクエスト失敗 |
| INFO_002 | エラー | failed to parse response body as JSON | JSONパース失敗 |
| INFO_003 | エラー | failed to parse package manifest | マニフェスト解析失敗 |
| INFO_004 | エラー | No version of "{name}" satisfying "{version}" found | 該当バージョンなし |
| INFO_005 | 情報 | Recent versions: | バージョン不一致時に表示 |
| INFO_006 | エラー | Property "{path}" not found | プロパティが存在しない |
| INFO_007 | エラー（JSON） | {"error": "No matching version found"} | JSON出力でバージョンなし |
| INFO_008 | エラー（JSON） | {"error": "Property not found"} | JSON出力でプロパティなし |

## 例外処理

| 例外条件 | 処理内容 | エラーコード |
|---------|---------|------------|
| パッケージ名未指定 | 使用方法を表示（または現在のパッケージを使用） | 1 |
| HTTPリクエスト失敗 | エラーメッセージを表示して終了 | 1 |
| JSONパース失敗 | エラーメッセージを表示して終了 | 1 |
| パッケージが存在しない | 404エラーメッセージを表示して終了 | 1 |
| バージョンが存在しない | 最近のバージョン一覧を表示して終了 | 1 |
| プロパティが存在しない | エラーメッセージを表示して終了 | 1 |

## 備考

- パッケージ名が`.`または空の場合は現在のpackage.jsonの名前を使用
- dist-tagsのlatest/beta等でバージョン指定可能
- semver範囲指定（^1.0.0、>=1.0.0等）も対応
- versionsプロパティはバージョン文字列の配列として正規化される
- ターミナル幅に応じてフォーマットが調整される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

infoコマンドで使用される主要なデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | npm.zig | `src/install/npm.zig` | PackageManifest構造体：パッケージメタデータの表現 |
| 1-2 | semver.zig | `src/semver.zig` | Semver.Version, Semver.Query：バージョン解析・マッチング |

**読解のコツ**: JSONレスポンスをPackageManifestに変換し、バージョンマッチングを行う流れを理解することが重要です。

#### Step 2: エントリーポイントを理解する

処理の起点となるview関数を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pm_view_command.zig | `src/cli/pm_view_command.zig` | view関数（L1-393）：メイン処理ロジック |

**主要処理フロー**:
1. **L2-32**: パッケージ名とバージョンの解析、空/`.`の場合のフォールバック
2. **L34-43**: レジストリURLの構築
3. **L45-74**: HTTPリクエストヘッダーの準備（認証情報含む）
4. **L77-95**: HTTPリクエスト送信とレスポンス取得
5. **L97-114**: JSONパースとPackageManifest解析
6. **L116-186**: バージョンマッチングと該当バージョン抽出

#### Step 3: バージョンマッチングを理解する

指定バージョンに対応するマニフェストを特定する処理を読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pm_view_command.zig | `src/cli/pm_view_command.zig` | バージョン解決（L121-186）：dist-tag/semver対応 |

**主要処理フロー**:
- **L129-130**: `findByDistTag`でdist-tag（latest等）を試行
- **L133-137**: semverクエリとして解析し`findBestVersion`でマッチング
- **L145-153**: versions配列からマッチするバージョンを特定
- **L156-185**: バージョンが見つからない場合のエラー処理と候補表示

#### Step 4: 出力処理を理解する

フォーマットされた出力とJSON出力の処理を読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pm_view_command.zig | `src/cli/pm_view_command.zig` | プロパティパス対応（L204-254）：特定プロパティの抽出と出力 |
| 4-2 | pm_view_command.zig | `src/cli/pm_view_command.zig` | JSON出力（L256-277）：JSPrinterでの整形出力 |
| 4-3 | pm_view_command.zig | `src/cli/pm_view_command.zig` | 通常出力（L279-392）：各フィールドのフォーマット出力 |

### プログラム呼び出し階層図

```
PmViewCommand.view()
    │
    ├─ Dependency.splitNameAndVersionOrLatest()
    │      └─ パッケージ名とバージョンを分離
    │
    ├─ manager.scopeForPackageName()
    │      └─ スコープに応じたレジストリ設定取得
    │
    ├─ http.HeaderBuilder
    │      └─ Accept, Authorization ヘッダー構築
    │
    ├─ AsyncHTTP.initSync().sendSync()
    │      └─ レジストリへのGETリクエスト
    │
    ├─ JSON.parseUTF8()
    │      └─ レスポンスボディをJSONパース
    │
    ├─ PackageManifest.parse()
    │      └─ JSONをマニフェスト構造体に変換
    │
    ├─ [バージョン解決]
    │      ├─ findByDistTag() - dist-tagでの検索
    │      └─ findBestVersion() - semverでの検索
    │
    ├─ [property-path指定時]
    │      └─ getPathMayBeIndex() - プロパティ値を抽出
    │
    ├─ [--json指定時]
    │      └─ JSPrinter.printJSON() - JSON整形出力
    │
    └─ [通常出力]
           └─ Output.prettyln() - 各フィールドを整形出力
```

### データフロー図

```
[入力]                        [処理]                          [出力]

package-name[@version] ──────▶ splitNameAndVersionOrLatest() ────┐
                                      │                          │
                                      ▼                          │
                               レジストリURL構築                   │
                                      │                          │
                                      ▼                          │
認証情報 ──────────────────▶ HeaderBuilder ───────────────────────┤
(scope.token/scope.auth)                                         │
                                      │                          │
                                      ▼                          │
                              AsyncHTTP.sendSync()               │
                                      │                          │
                                      ▼                          │
npmレジストリ ──────────────▶ JSONレスポンス ─────────────────────┤
                                      │                          │
                                      ▼                          │
                              PackageManifest.parse() ───────────┤
                                      │                          │
                                      ▼                          │
                           [バージョンマッチング]                   │
                              findByDistTag() /                  │
                              findBestVersion()                  │
                                      │                          │
                                      ▼                          │
                       ┌──────────────┴──────────────┐           │
                       ▼                              ▼          ▼
              [property-path]                    [--json]   [通常出力]
                   │                                │           │
                   ▼                                ▼           ▼
              プロパティ値                       JSON整形    フォーマット出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pm_view_command.zig | `src/cli/pm_view_command.zig` | ソース | view/infoコマンドのメイン実装 |
| npm.zig | `src/install/npm.zig` | ソース | PackageManifest定義、レジストリ通信 |
| dependency.zig | `src/install/dependency.zig` | ソース | splitNameAndVersionOrLatest |
| semver.zig | `src/semver.zig` | ソース | バージョン解析・マッチング |
| http.zig | `src/http.zig` | ソース | AsyncHTTP、HeaderBuilder |
| json.zig | `src/json.zig` | ソース | JSONパーサー |
| js_printer.zig | `src/js_printer.zig` | ソース | JSON整形出力 |
