# 画面設計書 20-build

## 概要

本ドキュメントは、Bun CLIの `bun build` コマンドの画面設計書です。JavaScriptおよびTypeScriptファイルをバンドル・トランスパイルする機能の仕様を定義します。

### 本画面の処理概要

`bun build` コマンドは、高速なJavaScript/TypeScriptバンドラー機能を提供します。esbuildライクなAPIでプロジェクトのビルドを行い、minification、code splitting、ソースマップ生成など多様な機能をサポートします。

**業務上の目的・背景**：フロントエンド開発やNode.jsアプリケーション開発において、複数のモジュールを1つまたは複数のバンドルファイルにまとめる必要があります。Bunの高速バンドラーにより、開発時の反復サイクルを短縮し、本番環境向けの最適化されたバンドルを生成します。

**画面へのアクセス方法**：`bun build <entrypoints...> [options]` の形式で実行します。

**主要な操作・処理内容**：
1. エントリーポイントファイルの解析
2. 依存関係グラフの構築
3. モジュール解決とバンドル
4. コード変換（トランスパイル、minification）
5. 出力ファイルの生成
6. オプションに応じてソースマップ、メタファイル生成
7. --compileオプションで単一実行ファイルを生成

**画面遷移**：単独で実行されるCLIコマンドです。ビルド完了後、出力サマリーがターミナルに表示されます。

**権限による表示制御**：出力ディレクトリへの書き込み権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | bun build | 主機能 | JavaScript/TypeScriptのバンドル |
| 32 | minification | 補助機能 | コードの圧縮・最適化 |
| 33 | code splitting | 補助機能 | 複数チャンクへの分割 |
| 34 | --compile | 補助機能 | 単一実行ファイル生成 |

## 画面種別

コマンド実行（進捗表示、出力サマリー）

## URL/ルーティング

```
bun build <entrypoints...> [options]
```

## 入出力項目

### 入力項目（コマンドライン引数）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| entrypoints | string[] | はい | エントリーポイントファイル |
| --outdir | string | いいえ | 出力ディレクトリ |
| --outfile | string | いいえ | 単一ファイル出力時のファイル名 |
| --target | string | いいえ | 出力ターゲット（browser/bun/node） |
| --format | string | いいえ | 出力フォーマット（esm/cjs/iife） |
| --minify | boolean | いいえ | 全てのminificationを有効化 |
| --minify-syntax | boolean | いいえ | 構文のminification |
| --minify-whitespace | boolean | いいえ | 空白のminification |
| --minify-identifiers | boolean | いいえ | 識別子のminification |
| --sourcemap | string | いいえ | ソースマップ生成（none/inline/external/linked） |
| --splitting | boolean | いいえ | code splittingを有効化 |
| --compile | boolean | いいえ | 単一実行ファイルを生成 |
| --bytecode | boolean | いいえ | バイトコードにコンパイル |
| --root | string | いいえ | ソースルートディレクトリ |
| --public-path | string | いいえ | アセットの公開パスプレフィックス |
| --entry-naming | string | いいえ | エントリーファイルの命名規則 |
| --chunk-naming | string | いいえ | チャンクファイルの命名規則 |
| --asset-naming | string | いいえ | アセットファイルの命名規則 |
| --banner | string | いいえ | 出力先頭に追加するコード |
| --footer | string | いいえ | 出力末尾に追加するコード |
| --define | string | いいえ | コンパイル時定数定義 |
| --drop | string | いいえ | 削除する呼び出し（console等） |
| --external | string | いいえ | 外部パッケージとして扱う |
| --packages | string | いいえ | パッケージの扱い（bundle/external） |
| --no-bundle | boolean | いいえ | バンドルせずトランスパイルのみ |
| --metafile | string | いいえ | メタファイル出力パス |
| --watch | boolean | いいえ | ファイル変更を監視して再ビルド |
| --env | string | いいえ | 環境変数の扱い |
| --production | boolean | いいえ | 本番モード（NODE_ENV=production） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ビルドサマリー | string | バンドルされたモジュール数と時間 |
| 出力ファイル一覧 | string[] | 生成されたファイルのパスとサイズ |
| minify情報 | string | 圧縮による削減量 |
| compile情報 | string | 実行ファイル生成情報（--compile時） |
| エラー情報 | string | ビルドエラーの詳細 |

## 表示項目

### ビルドサマリー（通常）

```
Bundled {n} module(s) in {ms}ms

  entry.js     {size}  (entry point)
  chunk-xxx.js {size}  (chunk)
  style.css    {size}  (asset)
```

### ビルドサマリー（--compile）

```
  {ms}ms  minify  -{size} (estimate)
  {ms}ms  bundle  {n} modules
  {ms}ms  compile {outfile}
```

### トランスパイルサマリー（--no-bundle）

```
Transpiled file in {ms}ms
```

## イベント仕様

### 1-バンドルビルド

コマンド実行時の処理フロー：

1. `BuildCommand.exec()` がエントリーポイントとして呼び出される
2. コマンドライン引数を解析し、Transpilerを初期化
3. 各種オプション（minify、sourcemap、splitting等）を設定
4. ルートディレクトリを決定
5. `BundleV2.generateFromCLI()` でバンドルを生成
6. 出力ファイルをディスクに書き込み
7. --metafileがあればメタファイルを生成
8. --compileがあれば実行ファイルを生成
9. ビルドサマリーを出力

### 2-トランスパイルのみ（--no-bundle）

1. `transform_only` フラグを設定
2. `this_transpiler.transform()` でトランスパイル
3. 結果を出力

### 3-実行ファイル生成（--compile）

1. バンドル完了後、`StandaloneModuleGraph.toExecutable()` を呼び出し
2. ターゲットプラットフォーム用の実行ファイルを生成
3. クロスコンパイル対応

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはファイルシステムへの書き込みを行います。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| バンドル出力 | --outdirまたは--outfile | CREATE | バンドルファイル生成 |
| ソースマップ出力 | *.map | CREATE | ソースマップ生成 |
| メタファイル出力 | --metafile | CREATE | ビルドメタデータ生成 |
| 実行ファイル出力 | --outfile | CREATE | 単一実行ファイル生成（--compile） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| BUILD_001 | 成功 | Bundled {n} module(s) in {ms}ms | バンドル成功時 |
| BUILD_002 | 成功 | Transpiled file in {ms}ms | トランスパイル成功時 |
| BUILD_003 | エラー | cannot use an external source map without --outdir | 外部ソースマップでoutdirなし |
| BUILD_004 | エラー | cannot use --compile with --outdir | --compileと--outdirの併用 |
| BUILD_005 | エラー | --compile does not support --no-bundle | --compileと--no-bundleの併用 |
| BUILD_006 | エラー | HTML imports are only supported when bundling | HTMLのトランスパイルのみ |
| BUILD_007 | エラー | Must use --outdir when specifying more than one entry point | 複数エントリーでoutdirなし |
| BUILD_008 | エラー | Must use --outdir when code splitting is enabled | code splittingでoutdirなし |
| BUILD_009 | エラー | cannot use --compile with an output file named 'bun' | 出力名がbunの場合 |
| BUILD_010 | 情報 | minify -{size} (estimate) | minification結果 |
| BUILD_011 | 情報 | bundle {n} modules | バンドル完了情報 |
| BUILD_012 | 情報 | compile {outfile} | 実行ファイル生成情報 |

## 例外処理

| 例外条件 | 処理内容 | エラーコード |
|---------|---------|------------|
| エントリーポイント未指定 | 使用方法を表示して終了 | 1 |
| 外部ソースマップでoutdirなし | エラーメッセージを表示して終了 | 1 |
| --compileと--outdir併用 | エラーメッセージを表示して終了 | 1 |
| --compileと--no-bundle併用 | エラーメッセージを表示して終了 | 1 |
| 複数エントリーでoutdirなし | エラーメッセージを表示して終了 | 1 |
| code splittingでoutdirなし | エラーメッセージを表示して終了 | 1 |
| 出力ファイル名がbun | エラーメッセージを表示して終了 | 1 |
| ファイル書き込み失敗 | エラーメッセージを表示して終了 | 1 |
| モジュール解決失敗 | エラーメッセージを表示して終了 | 1 |

## 備考

- --targetがbunの場合、Bun固有のAPIが使用可能
- --compileでクロスコンパイル対応（--target=bun-linux-x64等）
- --productionでNODE_ENV=productionを設定
- エントリーポイントがindexの場合、親ディレクトリ名を出力名に使用
- --watchでファイル変更を監視して自動再ビルド
- バイトコード出力（--bytecode）はBunランタイム専用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

buildコマンドで使用される主要なデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | options.zig | `src/options.zig` | OutputFile構造体：出力ファイルの表現 |
| 1-2 | transpiler.zig | `src/transpiler.zig` | Transpiler構造体：トランスパイラー設定 |
| 1-3 | bundle_v2.zig | `src/bundler/bundle_v2.zig` | BundleV2：バンドラーのメイン実装 |

**読解のコツ**: Transpilerがオプションを保持し、BundleV2が実際のバンドル処理を行う二層構造です。

#### Step 2: エントリーポイントを理解する

処理の起点となるexec関数を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build_command.zig | `src/cli/build_command.zig` | exec関数（L2-598）：メイン処理ロジック |

**主要処理フロー**:
1. **L3**: 長時間実行用のアロケータ設定
2. **L6-9**: ターゲット設定（compile/bytecodeの場合はbun）
3. **L11-13**: bakeモードの分岐
4. **L44-52**: Transpilerの初期化
5. **L52-97**: オプション設定（ソースマップ、minify、splitting等）
6. **L166-191**: ルートディレクトリの決定
7. **L277-358**: バンドル実行（BundleV2またはtransform）
8. **L362-594**: 出力処理（ファイル書き込み、サマリー表示、compile）

#### Step 3: オプション設定を理解する

各種ビルドオプションの設定処理を読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build_command.zig | `src/cli/build_command.zig` | オプション設定（L52-97）：source_map、compile、minify等 |
| 3-2 | build_command.zig | `src/cli/build_command.zig` | compile制約チェック（L100-139）：--outdir、--no-bundle禁止等 |
| 3-3 | build_command.zig | `src/cli/build_command.zig` | ルートディレクトリ決定（L166-191） |

#### Step 4: バンドル実行と出力を理解する

実際のバンドル処理と出力処理を読み解きます。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | build_command.zig | `src/cli/build_command.zig` | バンドル実行（L277-358）：transform_onlyまたはBundleV2.generateFromCLI |
| 4-2 | build_command.zig | `src/cli/build_command.zig` | メタファイル出力（L332-355）：--metafile処理 |
| 4-3 | build_command.zig | `src/cli/build_command.zig` | ファイル書き込み（L532-591）：writeToDisk呼び出し |
| 4-4 | build_command.zig | `src/cli/build_command.zig` | compile実行（L433-514）：StandaloneModuleGraph.toExecutable |

### プログラム呼び出し階層図

```
BuildCommand.exec()
    │
    ├─ Global.configureAllocator()
    │
    ├─ Transpiler.init()
    │      └─ オプション設定
    │
    ├─ [オプション設定]
    │      ├─ source_map設定
    │      ├─ compile設定・制約チェック
    │      ├─ minify設定
    │      ├─ splitting設定
    │      └─ 各種naming設定
    │
    ├─ ルートディレクトリ決定
    │      └─ 共通パスまたは--root
    │
    ├─ [--no-bundle時]
    │      └─ this_transpiler.transform()
    │
    ├─ [バンドル時]
    │      └─ BundleV2.generateFromCLI()
    │             ├─ 依存関係解決
    │             ├─ モジュール変換
    │             ├─ チャンク生成
    │             └─ minification
    │
    ├─ [--metafile時]
    │      └─ File.writeAll(metafile_json)
    │
    ├─ [--compile時]
    │      └─ StandaloneModuleGraph.toExecutable()
    │             ├─ ターゲットプラットフォーム判定
    │             ├─ Bunランタイム埋め込み
    │             └─ 実行ファイル生成
    │
    ├─ [通常出力]
    │      └─ output_files[].writeToDisk()
    │
    └─ printSummary()
           └─ サマリー出力
```

### データフロー図

```
[入力]                        [処理]                          [出力]

entrypoints ─────────────▶ Transpiler.init() ─────────────────┐
                                  │                            │
--minify ────────────────▶ オプション設定 ──────────────────────┤
--sourcemap                       │                            │
--splitting                       │                            │
--compile                         │                            │
--target                          │                            │
...                               ▼                            │
                          ┌─────────────────┐                  │
                          │ BundleV2.       │                  │
                          │ generateFromCLI │                  │
                          └─────────────────┘                  │
                                  │                            │
                                  ▼                            │
                         ┌─────────────────┐                   │
                         │ OutputFiles[]   │                   │
                         │ - entry points  │                   │
                         │ - chunks        │                   │
                         │ - assets        │                   │
                         │ - sourcemaps    │                   │
                         └─────────────────┘                   │
                                  │                            │
              ┌───────────────────┼───────────────────┐        │
              ▼                   ▼                   ▼        ▼
        [--compile]          [--metafile]        [通常出力]
              │                   │                   │
              ▼                   ▼                   ▼
   StandaloneModuleGraph    metafile.json      outdir/outfile
   .toExecutable()                               ├─ entry.js
              │                                  ├─ chunk.js
              ▼                                  ├─ entry.js.map
         実行ファイル                             └─ assets/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build_command.zig | `src/cli/build_command.zig` | ソース | buildコマンドのメイン実装 |
| transpiler.zig | `src/transpiler.zig` | ソース | Transpiler定義、トランスパイル処理 |
| bundle_v2.zig | `src/bundler/bundle_v2.zig` | ソース | BundleV2バンドラー実装 |
| options.zig | `src/options.zig` | ソース | OutputFile、各種オプション定義 |
| standalone.zig | `src/standalone.zig` | ソース | StandaloneModuleGraph（--compile用） |
| js_parser.zig | `src/js_parser.zig` | ソース | JavaScriptパーサー |
| resolver.zig | `src/resolver.zig` | ソース | モジュール解決 |
