# 画面設計書 21-init

## 概要

本ドキュメントは、Bun CLIの`bun init`コマンドの画面設計書です。`bun init`コマンドは、新規Bunプロジェクトを初期化するためのコマンドで、package.json、tsconfig.json、.gitignoreなどのプロジェクト基本ファイルを自動生成します。

### 本画面の処理概要

`bun init`コマンドは、空のBunプロジェクトを迅速に立ち上げるためのプロジェクト初期化コマンドです。ユーザーが対話的またはオプション指定でプロジェクトテンプレートを選択し、必要なファイルを自動生成します。

**業務上の目的・背景**：JavaScriptプロジェクトの初期設定は、package.json、TypeScript設定、.gitignoreなど複数のファイル作成が必要で煩雑です。`bun init`はこれらを一括自動生成し、開発者がすぐにコーディングを開始できる環境を整えます。また、Reactプロジェクトやライブラリプロジェクトなどのテンプレートを提供し、プロジェクトの種類に応じた最適な初期設定を提供します。

**画面へのアクセス方法**：ターミナルで`bun init`コマンドを実行します。オプションとして`--yes`（自動承認）、`--minimal`（最小構成）、`--react`（Reactテンプレート）などを指定可能です。

**主要な操作・処理内容**：
1. コマンドライン引数の解析（--yes, --minimal, --react等）
2. 既存package.jsonの検出と読み込み
3. テンプレート選択（Blank/React/Library）の対話式プロンプト表示
4. プロジェクト名とエントリーポイントの入力受付
5. package.json、tsconfig.json、.gitignore、README.mdの生成
6. 必要な依存関係の自動インストール（bun install）

**画面遷移**：エントリーポイントの`bun`コマンドから直接アクセス。初期化完了後はシェルに戻ります。Reactテンプレート選択時は自動的に`bun dev`が実行されます。

**権限による表示制御**：特にロールベースの権限制御はありません。ただし、ディレクトリへの書き込み権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | bun init | 主機能 | 空のBunプロジェクトの初期化処理 |
| 8 | bunfig.toml設定 | 補助機能 | bunfig.tomlの初期設定生成 |

## 画面種別

コマンドライン対話型 / 初期化

## URL/ルーティング

- コマンド: `bun init [フォルダ名]`
- エイリアス: なし

## 入出力項目

| 項目名 | 項目種別 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| folder | 位置引数 | string | 任意 | 初期化するディレクトリ名 |
| --help, -h | フラグ | boolean | 任意 | ヘルプ表示 |
| --yes, -y | フラグ | boolean | 任意 | デフォルトオプションで自動承認 |
| --minimal, -m | フラグ | boolean | 任意 | 最小構成（package.json + tsconfig.jsonのみ） |
| --react, -r | フラグ | boolean | 任意 | Reactプロジェクトテンプレート |
| --react=tailwind | フラグ | string | 任意 | TailwindCSS付きReactテンプレート |
| --react=shadcn | フラグ | string | 任意 | shadcn/ui付きReactテンプレート |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| テンプレート選択プロンプト | 対話モード時 | Blank/React/Libraryの選択肢 |
| パッケージ名プロンプト | Libraryテンプレート選択時 | パッケージ名の入力 |
| エントリーポイントプロンプト | Libraryテンプレート選択時 | エントリーポイントファイルの入力 |
| 生成ファイル一覧 | 常時 | `+ package.json`等の生成ファイル表示 |
| 次のステップ案内 | 完了時 | `bun run <entrypoint>`の実行案内 |

## イベント仕様

### 1-テンプレート選択

ユーザーがテンプレートを選択する対話型インターフェース。

- **トリガー**: コマンド実行時（--yesオプションなし、既存package.jsonなし）
- **処理内容**:
  - 上下矢印キーまたはj/kキーで選択肢を移動
  - Enterキーで確定
  - Ctrl+CまたはCtrl+Dでキャンセル
- **選択肢**:
  - Blank: 基本的なTypeScriptプロジェクト
  - React: React + React DOMプロジェクト
  - Library: npm公開用ライブラリプロジェクト

### 2-Reactテンプレート詳細選択

Reactテンプレート選択後の詳細オプション選択。

- **トリガー**: テンプレート選択でReactを選択
- **処理内容**:
  - Default (blank): 基本的なReactプロジェクト
  - TailwindCSS: TailwindCSS付きReactプロジェクト
  - Shadcn + TailwindCSS: shadcn/ui + TailwindCSS付きプロジェクト

### 3-ファイル生成

選択されたテンプレートに基づきファイルを生成。

- **トリガー**: テンプレート選択完了後
- **処理内容**:
  - package.jsonの生成/更新
  - tsconfig.json（またはjsconfig.json）の生成
  - .gitignoreの生成（存在しない場合）
  - README.mdの生成（存在しない場合）
  - エントリーポイントファイルの生成
  - CLAUDE.mdまたは.cursor/rules/*.mdcの生成（AIエージェントツールがインストールされている場合）

### 4-依存関係インストール

package.json生成後の依存関係自動インストール。

- **トリガー**: ファイル生成完了後
- **処理内容**: `bun install`を自動実行
- **スキップ条件**: 既存package.jsonが存在し、依存関係が既に定義されている場合

## データベース更新仕様

本コマンドはデータベースを使用しません。ファイルシステムへの書き込みのみを行います。

### 操作別ファイル影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 初期化実行 | package.json | CREATE/UPDATE | プロジェクト設定ファイル |
| 初期化実行 | tsconfig.json | CREATE | TypeScript設定ファイル |
| 初期化実行 | .gitignore | CREATE | Git除外設定ファイル |
| 初期化実行 | README.md | CREATE | プロジェクト説明ファイル |
| 初期化実行 | index.ts | CREATE | エントリーポイントファイル |
| 初期化実行 | CLAUDE.md | CREATE | AIエージェント用ルールファイル |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|----------|
| 成功 | `+ package.json` | ファイル生成成功時 |
| 成功 | `+ tsconfig.json (for editor autocomplete)` | tsconfig生成成功時 |
| 情報 | `package.json already exists, configuring existing project` | 既存package.jsonがある場合 |
| 案内 | `To get started, run: bun run <entrypoint>` | 初期化完了時 |
| キャンセル | `x Cancelled` | Ctrl+C/Ctrl+D押下時 |
| エラー | `Failed to create directory {s}: {s}` | ディレクトリ作成失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ディレクトリ作成失敗 | エラーメッセージを表示し終了コード1で終了 |
| ディレクトリ変更失敗 | エラーメッセージを表示し終了コード1で終了 |
| ファイル書き込み失敗 | 該当ファイルの生成をスキップし処理続行 |
| 対話入力のEOF | `x Cancelled`を表示し正常終了（終了コード0） |

## 備考

- `--react`オプション使用時は`--yes`が自動的に有効になります
- Claude CodeまたはCursorがインストールされている場合、AIエージェント用のルールファイルが自動生成されます
- 既存のtsconfig.jsonまたはjsconfig.jsonがある場合、新規生成はスキップされます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、initコマンドで使用される主要なデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | init_command.zig | `src/cli/init_command.zig` | PackageJSONFields構造体（341-347行目）でpackage.jsonの構造を定義 |
| 1-2 | init_command.zig | `src/cli/init_command.zig` | Template列挙型（917-922行目）でテンプレート種別を定義 |
| 1-3 | init_command.zig | `src/cli/init_command.zig` | DependencyGroup構造体（875-915行目）で依存関係グループを定義 |

**読解のコツ**: Zigでは構造体のフィールドにデフォルト値を指定でき、PackageJSONFieldsでは`name: string = "project"`のように初期値が設定されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cli.zig | `src/cli.zig` | Command.which()関数（542-651行目）でコマンド判定 |
| 2-2 | cli.zig | `src/cli.zig` | Command.start()関数（763行目）でInitCommand.exec()を呼び出し |
| 2-3 | init_command.zig | `src/cli/init_command.zig` | exec()関数（349-867行目）がメイン処理 |

**主要処理フロー**:
1. **349-395行目**: コマンドライン引数の解析（--minimal, --yes, --react等）
2. **397-406行目**: 指定ディレクトリの作成と移動
3. **414-447行目**: 既存package.jsonの読み込み
4. **542-613行目**: テンプレート選択の対話処理
5. **755-783行目**: package.jsonのファイル書き込み
6. **786-864行目**: 各種ファイル生成とbun installの実行

#### Step 3: テンプレート選択UI処理

対話式UIの実装を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | init_command.zig | `src/cli/init_command.zig` | radio()関数（181-223行目）で選択UIを提供 |
| 3-2 | init_command.zig | `src/cli/init_command.zig` | processRadioButton()関数（44-178行目）でキー入力処理 |
| 3-3 | init_command.zig | `src/cli/init_command.zig` | prompt()関数（2-40行目）でテキスト入力処理 |

**主要処理フロー**:
- **67-68行目**: プロンプト表示とカーソル非表示
- **91-177行目**: キー入力ループ（矢印キー、j/k、Enter、Ctrl+C）
- **125-128行目**: Enter/改行で選択確定

#### Step 4: ファイル生成処理

各種ファイルの生成処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | init_command.zig | `src/cli/init_command.zig` | Assets構造体（225-311行目）でファイル生成を管理 |
| 4-2 | init_command.zig | `src/cli/init_command.zig` | createAgentRule()関数（1017-1061行目）でAIエージェントルール生成 |
| 4-3 | init_command.zig | `src/cli/init_command.zig` | Template.files()関数（1173-1179行目）でテンプレートファイル取得 |

### プログラム呼び出し階層図

```
bun init
    │
    ├─ cli.zig: Command.which()
    │      └─ "init"を検出 → InitCommand
    │
    ├─ cli.zig: Command.start()
    │      └─ InitCommand.exec() を呼び出し
    │
    └─ init_command.zig: exec()
           │
           ├─ 引数解析（--minimal, --yes, --react）
           │
           ├─ radio() [テンプレート選択]
           │      └─ processRadioButton()
           │
           ├─ prompt() [パッケージ名/エントリーポイント入力]
           │
           ├─ Assets.create() [ファイル生成]
           │      ├─ .gitignore
           │      ├─ tsconfig.json
           │      └─ README.md
           │
           ├─ createAgentRule() [AIルール生成]
           │
           └─ bun install [依存関係インストール]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数    ───▶ 引数パーサー            ───▶ オプションフラグ
(--yes, --react等)

ユーザー入力           ───▶ radio()/prompt()        ───▶ テンプレート選択
(矢印キー/Enter)                                        パッケージ名

既存package.json      ───▶ JSON.parsePackageJSON   ───▶ PackageJSONFields
                           UTF8

PackageJSONFields     ───▶ JSPrinter.printJSON     ───▶ package.json
+ 依存関係

埋め込みテンプレート  ───▶ Assets.create()          ───▶ tsconfig.json
(@embedFile)                                           .gitignore
                                                       README.md
                                                       index.ts
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| init_command.zig | `src/cli/init_command.zig` | ソース | initコマンドのメイン実装 |
| cli.zig | `src/cli.zig` | ソース | CLIコマンドルーター |
| create_command.zig | `src/cli/create_command.zig` | ソース | initializeStore()関数を提供 |
| gitignore.default | `src/init/gitignore.default` | テンプレート | .gitignoreテンプレート |
| tsconfig.default.json | `src/init/tsconfig.default.json` | テンプレート | tsconfig.jsonテンプレート |
| README.default.md | `src/init/README.default.md` | テンプレート | README.mdテンプレート |
| rule.md | `src/init/rule.md` | テンプレート | AIエージェントルールテンプレート |
| react-app/ | `src/init/react-app/` | テンプレート | Reactテンプレートファイル群 |
| react-tailwind/ | `src/init/react-tailwind/` | テンプレート | React+Tailwindテンプレートファイル群 |
| react-shadcn/ | `src/init/react-shadcn/` | テンプレート | React+shadcnテンプレートファイル群 |
