# 画面設計書 24-help

## 概要

本ドキュメントは、Bun CLIの`bun help`コマンド（およびヘルプ表示機能）の画面設計書です。`bun help`コマンドは、Bunの使用方法、利用可能なコマンド一覧、オプション情報を表示するヘルプ機能を提供します。

### 本画面の処理概要

`bun help`コマンドは、Bun CLIの包括的なヘルプ情報を表示するコマンドです。利用可能なサブコマンドの一覧、各コマンドの簡単な説明、一般的なフラグ、そしてドキュメントやコミュニティへのリンクを提供します。

**業務上の目的・背景**：CLIツールにおいてヘルプ機能は必須であり、ユーザーが利用可能な機能を素早く把握し、正しいコマンド構文を理解するために重要です。`bun help`は初心者からエキスパートまでのユーザーが、Bunの機能を発見し効率的に利用できるようサポートします。

**画面へのアクセス方法**：以下のいずれかの方法でアクセスできます：
- `bun help`コマンドを実行
- `bun`を引数なしで実行
- `bun --help`または`bun -h`オプションを使用
- 無効なコマンドを入力した場合（エラーメッセージ付きで表示）

**主要な操作・処理内容**：
1. ヘルプ表示理由の判定（明示的/無効コマンド）
2. バージョン情報の表示
3. コマンド一覧のカテゴリ別表示
4. 利用例（ランダムに選択されたパッケージ名）の表示
5. ドキュメント/Discordコミュニティリンクの表示

**画面遷移**：エントリーポイントの`bun`コマンドから直接アクセス。ヘルプ表示後はシェルに戻ります。

**権限による表示制御**：特にロールベースの権限制御はありません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ヘルプ表示 | 主機能 | CLIヘルプテキストの表示 |

## 画面種別

コマンドライン / ヘルプ表示

## URL/ルーティング

- コマンド: `bun help`
- エイリアス: `bun`（引数なし）、`bun --help`、`bun -h`

## 入出力項目

| 項目名 | 項目種別 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| --help, -h | フラグ | boolean | 任意 | ヘルプを表示（各コマンドでも使用可） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| バージョン情報 | 常時 | `Bun is a fast JavaScript runtime... (バージョン)` |
| コマンド一覧 | 常時 | カテゴリ別のコマンド一覧とサンプル |
| フラグ一覧 | `--help`フラグ使用時 | 共通フラグの一覧 |
| フッター | 常時 | ドキュメントURLとDiscordリンク |
| エラーメッセージ | 無効コマンド時 | 「Uh-oh not sure what to do with that command」 |

## イベント仕様

### 1-明示的ヘルプ表示

ユーザーが明示的にヘルプを要求した場合の処理。

- **トリガー**: `bun help`、`bun`（引数なし）、`bun --help`、`bun -h`
- **処理内容**:
  - バージョン情報付きのヘルプテキストを標準出力に表示
  - 終了コード0で終了

### 2-無効コマンド時ヘルプ表示

無効なコマンドが入力された場合のエラー表示。

- **トリガー**: 認識できないコマンドの入力
- **処理内容**:
  - エラーメッセージ「Uh-oh not sure what to do with that command」を標準エラー出力に表示
  - ヘルプテキストを表示
  - 終了コード1で終了

### 3-コマンド固有ヘルプ表示

各コマンドの`--help`オプション使用時の処理。

- **トリガー**: `bun <command> --help`（例: `bun install --help`）
- **処理内容**:
  - コマンド固有のヘルプテキストを表示
  - 該当コマンドのオプション一覧を表示
  - 終了コード0で終了

## データベース更新仕様

本コマンドはデータベースを使用しません。標準出力への書き込みのみを行います。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|----------|
| 見出し | `Bun is a fast JavaScript runtime, package manager, bundler, and test runner. (バージョン)` | 明示的ヘルプ時 |
| 使用法 | `Usage: bun <command> [...flags] [...args]` | 常時 |
| コマンドカテゴリ | `Commands:` | 常時 |
| 実行コマンド | `run       ./my-script.ts       Execute a file with Bun` | 常時 |
| テストコマンド | `test                           Run unit tests with Bun` | 常時 |
| パッケージコマンド | `install                        Install dependencies for a package.json (bun i)` | 常時 |
| ビルドコマンド | `build     ./a.ts ./b.jsx       Bundle TypeScript & JavaScript into a single file` | 常時 |
| 初期化コマンド | `init                           Start an empty Bun project from a built-in template` | 常時 |
| フッター情報 | `Learn more about Bun: https://bun.com/docs` | 常時 |
| フッター情報 | `Join our Discord community: https://bun.com/discord` | 常時 |
| エラー | `Uh-oh not sure what to do with that command.` | 無効コマンド時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 標準出力への書き込み失敗 | エラーを無視（BrokenPipeは正常終了扱い） |

## 備考

- ヘルプテキスト内のパッケージ名例（`add`, `remove`, `x`, `create`のサンプル）はランダムに選択されます
- カラー出力はターミナルのANSIカラーサポート状況に応じて自動調整されます
- デバッグビルドでAIエージェント検出時は特別な出力（「BUN COMPILED SUCCESSFULLY!」）が行われることがあります
- `bun <command> --help`で各コマンド固有のヘルプを表示できます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ヘルプコマンドで使用される主要なデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cli.zig | `src/cli.zig` | HelpCommand構造体（104-274行目）でヘルプ表示ロジックを定義 |
| 1-2 | cli.zig | `src/cli.zig` | Reason列挙型（110-113行目）で表示理由（explicit/invalid_command）を定義 |
| 1-3 | cli.zig | `src/cli.zig` | packages_to_*_filler配列（116-159行目）でサンプルパッケージ名を定義 |

**読解のコツ**: ヘルプテキストは`cli_helptext_fmt`定数に定義されており、`{s:<16}`形式でフォーマット幅が指定されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cli.zig | `src/cli.zig` | Command.which()関数でコマンド判定（545行目〜） |
| 2-2 | cli.zig | `src/cli.zig` | `help`コマンドの判定（619行目: `RootCommandMatcher.case("help")`) |
| 2-3 | cli.zig | `src/cli.zig` | HelpCommand.exec()呼び出し（761行目） |
| 2-4 | cli.zig | `src/cli.zig` | HelpCommand.execWithReason()（265-273行目）がメイン処理 |

**主要処理フロー**:
1. **105-108行目**: exec()関数がexecWithReason(.explicit)を呼び出し
2. **204-263行目**: printWithReason()でヘルプテキストを生成・表示
3. **205-211行目**: ランダムなサンプルパッケージ名を選択
4. **240-254行目**: バージョン情報とヘルプテキストを出力
5. **265-273行目**: 終了コードを設定

#### Step 3: ヘルプテキスト生成

ヘルプテキストの生成ロジックを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cli.zig | `src/cli.zig` | cli_helptext_fmt定数（162-196行目）でメインヘルプテキストを定義 |
| 3-2 | cli.zig | `src/cli.zig` | cli_helptext_footer定数（197-202行目）でフッターを定義 |
| 3-3 | cli.zig | `src/cli.zig` | Output.pretty()でカラー出力（240-246行目） |

#### Step 4: コマンド固有ヘルプ

各コマンドの`--help`処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cli.zig | `src/cli.zig` | Tag.printHelp()関数（1068-1367行目）でコマンド別ヘルプを表示 |
| 4-2 | cli.zig | `src/cli.zig` | コマンドタグ別の分岐（1239行目〜） |

### プログラム呼び出し階層図

```
bun help / bun / bun --help
    │
    ├─ cli.zig: Command.which()
    │      └─ "help"を検出 → HelpCommand
    │      └─ 引数なし → HelpCommand
    │      └─ "--help"フラグ → HelpCommand
    │
    └─ HelpCommand.exec()
           │
           └─ HelpCommand.execWithReason(.explicit)
                  │
                  └─ HelpCommand.printWithReason()
                         │
                         ├─ std.Random.DefaultPrng [サンプルパッケージ選択]
                         │
                         ├─ [explicit]
                         │      ├─ Output.pretty() [バージョン+ヘルプ]
                         │      ├─ clap.simpleHelpBunTopLevel() [フラグ一覧]
                         │      └─ Output.pretty(cli_helptext_footer)
                         │
                         └─ [invalid_command]
                                └─ Output.prettyError() [エラー+ヘルプ]

無効コマンド入力時:
bun <invalid>
    │
    └─ cli.zig: UnknownCommand.exec()
           │
           └─ HelpCommand.execWithReason(.invalid_command)
                  │
                  └─ Global.exit(1)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

コマンドライン引数     ───▶ Command.which()              ───▶ Tag.HelpCommand
(help / --help / なし)

時刻                   ───▶ std.Random.DefaultPrng      ───▶ ランダムインデックス
(milliTimestamp)

packages_to_*_filler   ───▶ 配列アクセス                 ───▶ サンプルパッケージ名
配列                         [rand_index]

cli_helptext_fmt       ───▶ Output.pretty()              ───▶ カラー付きヘルプテキスト
+ サンプル名                  (std.fmt)                        (標準出力)

Reason                 ───▶ switch分岐                   ───▶ 終了コード
(explicit/invalid)           explicit → 0
                             invalid → 1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cli.zig | `src/cli.zig` | ソース | HelpCommand実装、CLIルーター |
| output.zig | `src/output.zig` | ソース | Output.pretty()等の出力ユーティリティ |
| clap.zig | `src/deps/zig-clap/clap.zig` | ソース | simpleHelpBunTopLevel()でフラグヘルプ |
| global.zig | `src/global.zig` | ソース | Global.exit()、バージョン情報 |

### ヘルプテキストのカテゴリ構造

ヘルプテキストは以下のカテゴリに分類されて表示されます：

```
Commands:
  [実行系 - magenta]
    run, test, x, repl, exec

  [パッケージ管理系 - blue]
    install, add, remove, update, audit, outdated, link, unlink, publish, patch, pm, info, why

  [ビルド系 - yellow]
    build

  [初期化系 - cyan]
    init, create, upgrade, feedback

  [ヘルプ]
    <command> --help
```

各コマンド名には色分けされたANSIエスケープコードが適用されます。
