# 画面設計書 25-completions

## 概要

本ドキュメントは、Bun CLIの`bun completions`コマンドの画面設計書です。`bun completions`コマンドは、シェル補完（タブ補完）機能をインストールするためのコマンドで、bash、zsh、fishシェルに対応しています。

### 本画面の処理概要

`bun completions`コマンドは、Bunコマンドのシェル補完機能をインストールするコマンドです。ユーザーのシェル環境を自動検出し、適切な補完スクリプトを生成・配置します。

**業務上の目的・背景**：CLIツールの生産性向上にはタブ補完が重要です。`bun completions`により、ユーザーはBunの全コマンドとオプションを素早く入力でき、タイプミスを減らし、利用可能なオプションを発見しやすくなります。

**画面へのアクセス方法**：ターミナルで`bun completions`コマンドを実行します。出力先ディレクトリを引数で指定することも可能です。

**主要な操作・処理内容**：
1. `$SHELL`環境変数からシェルタイプを検出
2. シェルに応じた補完スクリプトディレクトリを探索
3. bunxシンボリックリンクのインストール（POSIX）またはハードリンク作成（Windows）
4. 補完スクリプトファイルの書き込み
5. zshの場合、`.zshrc`への設定追加

**画面遷移**：エントリーポイントの`bun`コマンドから直接アクセス。インストール完了後はシェルに戻ります。`bun upgrade`実行時にも自動的に呼び出されます。

**権限による表示制御**：特にロールベースの権限制御はありません。ただし、補完スクリプトディレクトリへの書き込み権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | シェル補完インストール | 主機能 | 補完スクリプトの生成とインストール |

## 画面種別

コマンドライン / 設定インストール

## URL/ルーティング

- コマンド: `bun completions [ディレクトリ]`
- エイリアス: なし

## 入出力項目

| 項目名 | 項目種別 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| directory | 位置引数 | string | 任意 | 補完スクリプトの出力先ディレクトリ |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| インストール完了メッセージ | 成功時 | `Installed completions to {path}/{filename}` |
| zshrc設定案内 | zshで自動設定失敗時 | `.zshrc`への追加コマンドを表示 |
| zshrc設定完了 | zshで自動設定成功時 | `Enabled loading bun's completions in .zshrc` |
| パイプ出力案内 | ディレクトリが見つからない場合 | パイプやディレクトリ指定の方法を案内 |

## イベント仕様

### 1-シェル検出

環境変数からシェルタイプを検出します。

- **トリガー**: コマンド実行時
- **処理内容**:
  - `$SHELL`環境変数を読み取り
  - basenameからシェルタイプを判定（bash/zsh/fish/pwsh）
  - 不明な場合は`.unknown`を設定

### 2-bunxシンボリックリンク作成

`bunx`コマンドのシンボリックリンクを作成します。

- **トリガー**: コマンド実行時（常に試行）
- **処理内容**:
  - POSIX: bunバイナリと同じディレクトリに`bunx`シンボリックリンクを作成
  - 失敗時は`$BUN_INSTALL/bin/bunx`、`$HOME/.bun/bin/bunx`、`$HOME/.local/bin/bunx`を順次試行
  - Windows: `bunx.exe`のハードリンクまたは`.cmd`スクリプトを作成

### 3-補完ディレクトリ探索

シェルタイプに応じた補完スクリプトの配置先を探索します。

- **トリガー**: シェル検出成功後
- **探索順序**（シェル別）:
  - **fish**: `$XDG_CONFIG_HOME/fish/completions` → `$XDG_DATA_HOME/fish/completions` → `$HOME/.config/fish/completions` → Homebrew → `/etc/fish/completions`
  - **zsh**: `$fpath`の各ディレクトリ → `$XDG_DATA_HOME/zsh-completions` → `$BUN_INSTALL` → `$HOME/.oh-my-zsh/completions` → `$HOME/.bun` → システムディレクトリ
  - **bash**: `$XDG_DATA_HOME/bash-completion/completions` → `$XDG_CONFIG_HOME/bash-completion/completions` → `$HOME/.oh-my-bash/custom/completions` → `$HOME/.bash_completion.d` → Homebrew

### 4-補完スクリプト書き込み

検出されたディレクトリに補完スクリプトを書き込みます。

- **トリガー**: 補完ディレクトリが見つかった場合、またはユーザー指定時
- **処理内容**:
  - 埋め込みスクリプトを取得（シェル別）
  - ファイル名を決定: fish=`bun.fish`、zsh=`_bun`、bash=`bun.completion.bash`
  - ファイルを作成/上書き

### 5-zshrc設定追加

zshの場合、`.zshrc`に補完読み込み設定を追加します。

- **トリガー**: zshで補完スクリプト書き込み成功後
- **処理内容**:
  - `$ZDOTDIR/.zshrc` または `$HOME/.zshrc`を読み込み
  - 既存の補完設定がないか確認
  - なければ `[ -s "{path}" ] && source "{path}"` を追記

### 6-Windowsアンインストーラー作成

Windowsの場合、アンインストールスクリプトを作成します。

- **トリガー**: Windowsでコマンド実行時
- **処理内容**:
  - `bun\bin\`パスにインストールされている場合のみ
  - `uninstall.ps1`を作成

## データベース更新仕様

本コマンドはデータベースを使用しません。ファイルシステムへの書き込みを行います。

### 操作別ファイル影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 補完インストール | `{dir}/bun.fish` | CREATE | fish用補完スクリプト |
| 補完インストール | `{dir}/_bun` | CREATE | zsh用補完スクリプト |
| 補完インストール | `{dir}/bun.completion.bash` | CREATE | bash用補完スクリプト |
| zshrc更新 | `$HOME/.zshrc` | UPDATE | 補完読み込み設定追加 |
| bunxリンク | `{bun_dir}/bunx` | CREATE | シンボリックリンク |
| アンインストーラー | `{bun_dir}/uninstall.ps1` | CREATE | Windowsのみ |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|----------|
| 成功 | `Installed completions to {dir}/{filename}` | インストール成功時 |
| 情報 | `Enabled loading bun's completions in .zshrc` | zshrc自動設定成功時 |
| 案内 | `To enable completions, add this to your .zshrc: [ -s "{path}" ] && source "{path}"` | zshrc自動設定失敗時 |
| エラー | `error: Unknown or unsupported shell. Please set $SHELL to one of zsh, fish, or bash.` | シェル検出失敗時 |
| エラー | `error: Could not find a directory to install completions in.` | ディレクトリが見つからない場合 |
| エラー | `error: Could not get current working directory` | カレントディレクトリ取得失敗時 |
| ヒント | `zsh tip: One of the directories in $fpath might work...` | zshでディレクトリが見つからない場合 |
| 案内 | `Please either pipe it: bun completions > /to/a/file` | ディレクトリが見つからない場合 |
| 情報 | `PowerShell completions are not yet written for Bun yet.` | Windowsの場合 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| シェル不明 | エラーメッセージを表示し終了コード1で終了（自動更新時は0） |
| ディレクトリが見つからない | パイプ/ディレクトリ指定の案内を表示し終了コード1で終了 |
| ファイル書き込み失敗 | エラーメッセージを表示し終了コード1で終了 |
| TTYでない場合 | 補完スクリプトを標準出力に出力して終了コード0で終了 |
| BrokenPipe | 正常終了（終了コード0） |

## 備考

- PowerShell補完は未実装です（GitHub Issue #8939参照）
- `bun upgrade`実行時には自動的にcompletionsが更新されます（`IS_BUN_AUTO_UPDATE`環境変数で制御）
- TTYでない場合（パイプ使用時）は補完スクリプトを標準出力に出力します
- oh-my-zshとoh-my-bashの補完ディレクトリに対応しています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、completionsコマンドで使用される主要なデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | shell_completions.zig | `src/cli/shell_completions.zig` | Shell列挙型（1-37行目）でシェルタイプを定義 |
| 1-2 | shell_completions.zig | `src/cli/shell_completions.zig` | completions()関数（12-19行目）で埋め込みスクリプトを返す |
| 1-3 | shell_completions.zig | `src/cli/shell_completions.zig` | fromEnv()関数（21-36行目）でシェル検出ロジック |

**読解のコツ**: `@embedFile`でコンパイル時に補完スクリプトが埋め込まれています。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cli.zig | `src/cli.zig` | `bun completions`コマンドの判定（611行目: `RootCommandMatcher.case("completions")`) |
| 2-2 | cli.zig | `src/cli.zig` | InstallCompletionsCommand.exec()呼び出し（763行目） |
| 2-3 | install_completions_command.zig | `src/cli/install_completions_command.zig` | exec()関数（124行目〜）がメイン処理 |

**主要処理フロー**:
1. **132-135行目**: シェル環境変数からシェルタイプ検出
2. **153行目**: bunxシンボリックリンクのインストール試行
3. **155-157行目**: Windowsアンインストーラー作成
4. **166-173行目**: シェル不明時のエラー処理
5. **175-183行目**: TTYでない場合の標準出力への出力
6. **186-399行目**: シェル別の補完ディレクトリ探索
7. **410-428行目**: 補完スクリプトファイルの書き込み
8. **432-528行目**: zshrc設定追加処理

#### Step 3: bunxシンボリックリンク処理

bunxリンク作成処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | install_completions_command.zig | `src/cli/install_completions_command.zig` | installBunxSymlink()関数（90-96行目） |
| 3-2 | install_completions_command.zig | `src/cli/install_completions_command.zig` | installBunxSymlinkPosix()関数（6-46行目） |
| 3-3 | install_completions_command.zig | `src/cli/install_completions_command.zig` | installBunxSymlinkWindows()関数（49-88行目） |

#### Step 4: シェル別補完ディレクトリ探索

シェル別の補完ディレクトリ探索ロジックを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | install_completions_command.zig | `src/cli/install_completions_command.zig` | fish用探索（218-266行目） |
| 4-2 | install_completions_command.zig | `src/cli/install_completions_command.zig` | zsh用探索（268-326行目） |
| 4-3 | install_completions_command.zig | `src/cli/install_completions_command.zig` | bash用探索（328-377行目） |

### プログラム呼び出し階層図

```
bun completions [directory]
    │
    ├─ cli.zig: Command.which()
    │      └─ "completions"を検出 → InstallCompletionsCommand
    │
    └─ InstallCompletionsCommand.exec()
           │
           ├─ ShellCompletions.Shell.fromEnv() [シェル検出]
           │
           ├─ installBunxSymlink()
           │      ├─ [POSIX] installBunxSymlinkPosix()
           │      │      └─ std.posix.symlink()
           │      └─ [Windows] installBunxSymlinkWindows()
           │             └─ CreateHardLinkW() or .cmd作成
           │
           ├─ [Windows] installUninstallerWindows()
           │
           ├─ [TTYでない場合]
           │      └─ stdout.writeAll(shell.completions())
           │
           ├─ [補完ディレクトリ探索]
           │      ├─ [fish] XDG_CONFIG_HOME → XDG_DATA_HOME → HOME → Homebrew → /etc
           │      ├─ [zsh] fpath → XDG_DATA_HOME → BUN_INSTALL → oh-my-zsh → .bun → system
           │      └─ [bash] XDG_DATA_HOME → XDG_CONFIG_HOME → oh-my-bash → .bash_completion.d → Homebrew
           │
           ├─ output_file.writeAll(shell.completions())
           │
           └─ [zsh] .zshrc設定追加
                  └─ dot_zshrc.pwriteAll()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

$SHELL環境変数         ───▶ Shell.fromEnv()             ───▶ Shell列挙型
(例: /bin/zsh)               basename + 比較

@embedFile             ───▶ shell.completions()         ───▶ 補完スクリプト文字列
(completions-*)

環境変数               ───▶ ディレクトリ探索            ───▶ 出力先ディレクトリ
(XDG_*, HOME等)

補完スクリプト         ───▶ output_file.writeAll()      ───▶ {dir}/{filename}
                            ファイル書き込み

[zshの場合]
.zshrc内容             ───▶ 既存設定チェック            ───▶ 更新済み.zshrc
+ source設定                + pwriteAll()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| install_completions_command.zig | `src/cli/install_completions_command.zig` | ソース | completionsコマンドのメイン実装 |
| shell_completions.zig | `src/cli/shell_completions.zig` | ソース | Shell列挙型、補完スクリプト提供 |
| completions-bash | `src/cli/completions-bash` | テンプレート | bash用補完スクリプト |
| completions-zsh | `src/cli/completions-zsh` | テンプレート | zsh用補完スクリプト |
| completions-fish | `src/cli/completions-fish` | テンプレート | fish用補完スクリプト |
| uninstall.ps1 | `src/cli/uninstall.ps1` | テンプレート | Windowsアンインストーラー |
| cli.zig | `src/cli.zig` | ソース | CLIコマンドルーター |
