# 画面設計書 26-discord

## 概要

本ドキュメントは、Bun CLIの`bun discord`コマンドの画面設計書です。`bun discord`コマンドは、BunのDiscordコミュニティへの招待リンクをシステムのデフォルトブラウザで開くユーティリティコマンドです。

### 本画面の処理概要

`bun discord`コマンドは、ユーザーをBunのDiscordコミュニティに素早くアクセスさせるためのショートカットコマンドです。システムのデフォルトブラウザを使用してDiscord招待URLを開きます。

**業務上の目的・背景**：Bunは活発なオープンソースプロジェクトであり、ユーザーがコミュニティに参加してサポートを受けたり、フィードバックを提供したり、他の開発者と交流することが重要です。`bun discord`はコマンドライン上でDiscordへの参加を簡単にし、コミュニティへのアクセス障壁を下げます。

**画面へのアクセス方法**：ターミナルで`bun discord`コマンドを実行します。

**主要な操作・処理内容**：
1. Discord招待URL（`https://bun.com/discord`）を取得
2. システムのデフォルトブラウザオープナーを呼び出し
3. ブラウザでDiscord招待ページを表示

**画面遷移**：エントリーポイントの`bun`コマンドから直接アクセス。URLを開いた後はシェルに戻ります。ブラウザが起動しDiscordページが表示されます。

**権限による表示制御**：特にロールベースの権限制御はありません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Discord招待 | 主機能 | DiscordコミュニティURLの表示/オープン |

## 画面種別

コマンドライン / 外部リンク起動

## URL/ルーティング

- コマンド: `bun discord`
- エイリアス: なし

## 入出力項目

| 項目名 | 項目種別 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| なし | - | - | - | このコマンドには入力パラメータはありません |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| Discord URL | ブラウザ起動失敗時 | フォールバックとして`-> https://bun.com/discord`を表示 |

## イベント仕様

### 1-URLオープン

Discord招待URLをシステムのデフォルトブラウザで開きます。

- **トリガー**: コマンド実行時
- **処理内容**:
  - プラットフォーム別のオープナーを使用
    - macOS: `/usr/bin/open`
    - Windows: `start`
    - Linux/その他: `xdg-open`
  - `bun.spawnSync()`でプロセスを起動
  - 失敗時はURLをターミナルに表示

### 2-フォールバック表示

ブラウザ起動に失敗した場合のフォールバック処理。

- **トリガー**: URLオープン失敗時、またはWASI環境の場合
- **処理内容**:
  - `-> https://bun.com/discord`形式でURLを標準出力に表示
  - 出力バッファをフラッシュ

## データベース更新仕様

本コマンドはデータベースを使用しません。外部プロセスの起動のみを行います。

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|----------|
| フォールバック | `-> https://bun.com/discord` | ブラウザ起動失敗時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ブラウザ起動失敗 | フォールバックとしてURLをターミナルに表示 |
| WASI環境 | 常にフォールバック（URLのターミナル表示） |
| オープナーコマンドが見つからない | フォールバックとしてURLをターミナルに表示 |

## 備考

- Discord招待URL（`https://bun.com/discord`）は`discord_command.zig`にハードコードされています
- このコマンドは非常にシンプルで、実質的にはURLショートカットとして機能します
- WASI（WebAssembly System Interface）環境では外部プロセスを起動できないため、常にフォールバック動作となります

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

discordコマンドはシンプルな構造で、特別なデータ構造を持ちません。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | discord_command.zig | `src/cli/discord_command.zig` | discord_url定数（2行目）でURLを定義 |
| 1-2 | open.zig | `src/open.zig` | opener定数（1-5行目）でプラットフォーム別オープナーを定義 |

**読解のコツ**: 実装は非常にシンプルで、URLを開くだけのワンライナーに近い構造です。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cli.zig | `src/cli.zig` | `bun discord`コマンドの判定（621行目: `RootCommandMatcher.case("discord")`) |
| 2-2 | discord_command.zig | `src/cli/discord_command.zig` | DiscordCommand.exec()関数（3-5行目）がメイン処理 |
| 2-3 | open.zig | `src/open.zig` | openURL()関数（12-38行目）でURL起動処理 |

**主要処理フロー**:
1. **discord_command.zig:3-5行目**: exec()がopenURL()を呼び出し
2. **open.zig:12-38行目**: プラットフォーム別のオープナーでURLを開く
3. **open.zig:7-9行目**: 失敗時はfallback()でURLを表示

#### Step 3: URLオープン処理

外部ブラウザでURLを開く処理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | open.zig | `src/open.zig` | opener定数でプラットフォーム判定（1-5行目） |
| 3-2 | open.zig | `src/open.zig` | bun.spawnSync()でプロセス起動（18-30行目） |
| 3-3 | open.zig | `src/open.zig` | fallback()でフォールバック表示（7-9行目） |

### プログラム呼び出し階層図

```
bun discord
    │
    ├─ cli.zig: Command.which()
    │      └─ "discord"を検出 → DiscordCommand
    │
    └─ DiscordCommand.exec()
           │
           └─ open.openURL("https://bun.com/discord")
                  │
                  ├─ [WASI環境]
                  │      └─ fallback() → URLをターミナル表示
                  │
                  └─ [通常環境]
                         │
                         ├─ bun.spawnSync()
                         │      ├─ [macOS] /usr/bin/open
                         │      ├─ [Windows] start
                         │      └─ [Linux] xdg-open
                         │
                         └─ [失敗時]
                                └─ fallback() → URLをターミナル表示
```

### データフロー図

```
[入力]                      [処理]                           [出力]

（なし）               ───▶ discord_url定数取得          ───▶ "https://bun.com/discord"

@import("builtin")     ───▶ opener選択                   ───▶ "/usr/bin/open" (macOS)
.target.os.tag               (プラットフォーム判定)           "start" (Windows)
                                                             "xdg-open" (Linux)

opener + URL           ───▶ bun.spawnSync()              ───▶ ブラウザ起動
                             プロセス起動

[失敗時]
URL                    ───▶ Output.prettyln()            ───▶ "-> {URL}"
                             フォールバック表示                 (標準出力)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| discord_command.zig | `src/cli/discord_command.zig` | ソース | discordコマンドのメイン実装（11行） |
| open.zig | `src/open.zig` | ソース | URL/ファイルオープンユーティリティ |
| cli.zig | `src/cli.zig` | ソース | CLIコマンドルーター |
