# 画面設計書 4-repl

## 概要

本ドキュメントは、Bun CLIの`repl`コマンドの設計仕様を記述する。`bun repl`コマンドは、対話的なJavaScript/TypeScript実行環境（REPL: Read-Eval-Print Loop）を提供する。

### 本画面の処理概要

`bun repl`コマンドは、開発者が対話的にJavaScript/TypeScriptコードを入力・実行・結果確認できる環境を提供する。内部的には`bunx bun-repl`パッケージを実行することで実現されている。

**業務上の目的・背景**：開発中のコード片を素早くテストしたり、APIの動作確認を行ったり、デバッグ目的で変数の値を確認したりする際に、ファイルを作成せずに対話的にコードを実行できる環境が必要となる。Node.jsのREPLと同様の機能をBun環境で提供する。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun repl` - REPLセッションを開始

**主要な操作・処理内容**：
1. bun-replパッケージをbunxで実行
2. プロンプト表示とユーザー入力の待機
3. 入力コードの評価（eval）
4. 結果の表示（print）
5. ループ継続またはセッション終了

**画面遷移**：
- エントリーポイント：`bun repl` コマンドから直接実行
- 遷移先：Ctrl+C または `.exit` でターミナルに制御を返す
- 関連コマンド：`bun run`（ファイル実行）、`bun x`（パッケージ実行）

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | bun repl | 主機能 | REPLセッションの起動と対話的コード実行 |
| 19 | bunx | 補助機能 | bun-replパッケージの実行 |

## 画面種別

コマンドラインインターフェース（CLI）- 対話型実行環境

## URL/ルーティング

コマンドラインパターン:
- `bun repl`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| stdin | text | No | 対話的に入力されるJavaScript/TypeScriptコード |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| prompt | text | 入力待機プロンプト（`> `） |
| result | text | 評価結果の表示 |
| error | text | 構文エラーまたは実行時エラー |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| プロンプト | 常時 | `> ` 形式の入力待機マーカー |
| 評価結果 | コード実行後 | 式の評価結果（undefinedも表示） |
| エラーメッセージ | エラー発生時 | スタックトレースを含むエラー詳細 |

## イベント仕様

### 1-REPLセッション開始

ユーザーが`bun repl`を実行した場合の処理フロー：

1. コマンドライン引数を解析
2. BunxCommand.execを使用してbun-replパッケージを実行
3. bun-replが起動しプロンプトを表示
4. ユーザー入力を待機

### 2-コード評価

ユーザーがコードを入力した場合の処理フロー：

1. 入力行を読み取り
2. 入力コードをJavaScriptCore VMで評価
3. 結果を標準出力に表示
4. プロンプトを再表示

### 3-セッション終了

ユーザーがセッションを終了する場合の処理フロー：

1. `.exit` コマンドまたは Ctrl+C を検出
2. REPLプロセスを終了
3. 終了コード0を返却

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| PROMPT | info | `> ` | 入力待機時 |
| CONTINUATION | info | `... ` | 複数行入力時 |
| RESULT | info | 評価結果 | 式評価完了時 |
| ERROR | error | エラーメッセージ | 構文/実行時エラー |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| 構文エラー | 入力コードに構文エラー | エラーメッセージを表示し、次の入力を待機 |
| 実行時エラー | 評価中に例外発生 | スタックトレースを表示し、次の入力を待機 |
| シグナル受信 | SIGINT（Ctrl+C） | セッションを終了 |

## 備考

- `bun repl`は内部的に`bunx bun-repl`を実行
- bun-replパッケージはnpmレジストリから取得される
- `--bun`フラグが自動的に設定され、同じバージョンのBunが使用される
- Node.jsの`node:repl`モジュールとは別の実装

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

REPLコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cli.zig | `src/cli.zig` | ReplCommandの定義と実行処理（行839-846） |

**主要処理フロー**:
1. **行839**: `.ReplCommand =>` マッチング
2. **行841**: BunxCommandコンテキストを初期化
3. **行842**: `ctx.debug.run_in_bun = true`で同じバージョンのBunを強制使用
4. **行844**: 引数を`"bun-repl"`に設定
5. **行845**: `BunxCommand.exec`を呼び出し

**読解のコツ**: REPLコマンドはbunxコマンドの薄いラッパーであり、実際の処理はbun-replパッケージ（npm）で行われる。

#### Step 2: bunxコマンドの処理を理解する

bun-replパッケージの実行処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bunx_command.zig | `src/cli/bunx_command.zig` | BunxCommand.exec関数 |

**読解のコツ**: 3-x (bunx).mdの内容を参照。bun-replパッケージがキャッシュされていれば即座に実行、なければインストール後に実行。

#### Step 3: Node.js REPL互換モジュールを理解する

node:replモジュールのスタブ実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repl.ts | `src/js/node/repl.ts` | Node.js REPL互換APIのスタブ |

**読解のコツ**: このファイルは`bun repl`コマンドとは別物で、`require('node:repl')`のための互換性スタブ。throwNotImplementedで未実装を明示。

### プログラム呼び出し階層図

```
CLI.start()
    |
    +-- Command.which()
    |       +-- .ReplCommand を検出
    |
    +-- .ReplCommand ブロック
            |
            +-- Command.init(..., .BunxCommand)
            |
            +-- ctx.debug.run_in_bun = true
            |
            +-- args[1] = "bun-repl"
            |
            +-- BunxCommand.exec(ctx, args)
                    |
                    +-- [bun-repl パッケージ実行]
                            |
                            +-- REPL ループ開始
                            |
                            +-- ユーザー入力 → 評価 → 出力
                            |
                            +-- セッション終了
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bun repl コマンド -------> cli.zig ----------------> BunxCommand呼び出し
        |
        v
                          BunxCommand.exec() -------> bun-repl実行
        |
        v
ユーザーコード入力 -------> bun-repl (npm) ---------> 評価結果表示
        |
        v
.exit / Ctrl+C ---------> セッション終了 -----------> exit code 0
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cli.zig | `src/cli.zig` | ソース | ReplCommandの定義とディスパッチ |
| bunx_command.zig | `src/cli/bunx_command.zig` | ソース | bun-replパッケージの実行 |
| repl.ts | `src/js/node/repl.ts` | ソース | node:replモジュールの互換性スタブ（別機能） |
| (bun-repl) | npm package | 外部 | 実際のREPL実装（npm: bun-repl） |
