# 画面設計書 5-exec

## 概要

本ドキュメントは、Bun CLIの`exec`コマンドの設計仕様を記述する。`bun exec`コマンドは、シェルスクリプトをBunのシェルインタプリタで直接実行する機能を提供する。

### 本画面の処理概要

`bun exec`コマンドは、引数として渡されたシェルスクリプト文字列を、Bunに内蔵されたクロスプラットフォームシェルインタプリタで直接実行する。これにより、bash/sh/cmd.exeなどの外部シェルに依存せずにシェルコマンドを実行できる。

**業務上の目的・背景**：クロスプラットフォーム開発において、シェルスクリプトの互換性は常に課題となる。Bunのシェルインタプリタは、macOS/Linux/Windowsで同一のシェル構文を使用でき、package.jsonスクリプトやCI/CDパイプラインでの移植性を向上させる。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun exec '<shell-script>'` - シェルスクリプトを直接実行

**主要な操作・処理内容**：
1. コマンドライン引数からシェルスクリプト文字列を取得
2. Bunfig設定の読み込み
3. 環境変数の設定
4. Bunシェルインタプリタでスクリプトを実行
5. 終了コードを返却

**画面遷移**：
- エントリーポイント：`bun exec` コマンドから直接実行
- 遷移先：スクリプト実行完了後はターミナルに制御を返す
- 関連コマンド：`bun run`（ファイル/スクリプト実行）

**権限による表示制御**：特になし。ファイルシステムの読み書き権限に依存。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | bun exec | 主機能 | シェルスクリプトのBunインタプリタによる直接実行 |
| 12 | クロスプラットフォームシェル | 補助機能 | Bunに内蔵されたシェルインタプリタによるスクリプト解釈 |

## 画面種別

コマンドラインインターフェース（CLI）- シェルスクリプト実行コマンド

## URL/ルーティング

コマンドラインパターン:
- `bun exec '<shell-script>'`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| script | string | Yes | 実行するシェルスクリプト文字列 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stdout | stream | スクリプトの標準出力 |
| stderr | stream | スクリプトの標準エラー出力 |
| exit code | number | スクリプトの終了コード |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| スクリプト出力 | 常時 | シェルスクリプトの実行結果 |
| エラーメッセージ | エラー発生時 | シェル構文エラーや実行時エラー |

## イベント仕様

### 1-スクリプト実行

ユーザーが`bun exec`を実行した場合の処理フロー：

1. コマンドライン引数からスクリプト文字列を取得（ctx.positionals[1]）
2. Transpilerを初期化
3. 環境変数ローダーを実行（runEnvLoader）
4. 現在の作業ディレクトリを取得
5. MiniEventLoopを初期化
6. shell.Interpreter.initAndRunFromSourceでスクリプトを実行
7. 終了コードを返却（Global.exit）

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| ERR_CWD | error | failed to run script {script} | 作業ディレクトリ取得失敗 |
| ERR_SCRIPT | error | failed to run script {script} | スクリプト実行失敗 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| 作業ディレクトリエラー | cwdの取得に失敗 | エラーメッセージを表示し終了コード1で終了 |
| スクリプトエラー | シェルスクリプトの構文/実行エラー | エラーメッセージを表示し終了コード1で終了 |

## 備考

- Bunのシェルインタプリタはbashのサブセットを実装
- パイプ、リダイレクト、変数展開などの基本機能をサポート
- Windows/macOS/Linuxで同一の構文が使用可能
- 外部シェル（bash、cmd.exe）への依存なし

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

execコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | exec_command.zig | `src/cli/exec_command.zig` | ExecCommand構造体とexec関数 |

**主要処理フロー**:
1. **行3**: `ctx.positionals[1]`でスクリプト文字列を取得
2. **行5-10**: Transpilerを初期化
3. **行11**: `runEnvLoader`で環境変数をロード
4. **行13-19**: 現在の作業ディレクトリを取得
5. **行20**: `MiniEventLoop.initGlobal`でイベントループを初期化
6. **行27-30**: `shell.Interpreter.initAndRunFromSource`でスクリプト実行
7. **行38**: `Global.exit(code)`で終了

#### Step 2: シェルインタプリタを理解する

Bunのシェルインタプリタの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | interpreter.zig | `src/shell/interpreter.zig` | シェルインタプリタのメイン実装 |
| 2-2 | shell.zig | `src/shell/shell.zig` | シェル関連の定義 |

**読解のコツ**: `initAndRunFromSource`関数がスクリプト文字列を受け取り、パースと実行を行う。

### プログラム呼び出し階層図

```
ExecCommand.exec()
    |
    +-- ctx.positionals[1] (スクリプト取得)
    |
    +-- Transpiler.init()
    |
    +-- bundle.runEnvLoader() (環境変数ロード)
    |
    +-- bun.sys.getcwd() (作業ディレクトリ取得)
    |
    +-- MiniEventLoop.initGlobal()
    |
    +-- bun.path.join() (スクリプトパス生成)
    |
    +-- shell.Interpreter.initAndRunFromSource()
    |       |
    |       +-- スクリプトのパース
    |       +-- コマンドの実行
    |       +-- パイプ処理
    |       +-- リダイレクト処理
    |
    +-- Global.exit(code)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bun exec '<script>' -----> exec_command.zig ---------> スクリプト取得
        |
        v
環境変数設定 ------------> runEnvLoader() -----------> 環境変数Map
        |
        v
スクリプト文字列 --------> shell.Interpreter --------> コマンド実行
        |
        v
                          標準出力/エラー出力 -------> stdout/stderr
        |
        v
                          Global.exit() ------------> exit code
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| exec_command.zig | `src/cli/exec_command.zig` | ソース | execコマンドのメイン実装 |
| interpreter.zig | `src/shell/interpreter.zig` | ソース | シェルインタプリタの実装 |
| shell.zig | `src/shell/shell.zig` | ソース | シェル関連の定義 |
| braces.zig | `src/shell/braces.zig` | ソース | ブレース展開の実装 |
| config.zig | `src/bun.js/config.zig` | ソース | Transpiler設定 |
| env_loader.zig | `src/env_loader.zig` | ソース | 環境変数ローダー |
