# 画面設計書 6-install

## 概要

本ドキュメントは、Bun CLIの`install`コマンドの設計仕様を記述する。`bun install`コマンドは、package.jsonに定義された依存関係を解決し、node_modulesにパッケージをインストールするBunのパッケージマネージャー機能である。

### 本画面の処理概要

`bun install`コマンドは、プロジェクトのpackage.jsonを読み込み、dependencies、devDependencies、peerDependencies等に定義されたパッケージをnpmレジストリから取得してインストールする。npm/yarn/pnpmと互換性のあるlockfileを生成・更新し、高速なインストールを実現する。

**業務上の目的・背景**：JavaScript/TypeScript開発において、依存関係の管理は必須である。従来のnpm/yarn/pnpmと比較して大幅に高速なインストールを実現し、開発者の待ち時間を削減する。また、bun.lockb形式のバイナリlockfileにより、インストールの再現性と高速化を両立する。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun install` または `bun i` - 全依存関係のインストール
- `bun install --production` - 本番用依存関係のみインストール
- `bun install --frozen-lockfile` - lockfileを更新せずにインストール

**主要な操作・処理内容**：
1. package.jsonの読み込みと検証
2. 既存lockfile（bun.lockb/package-lock.json/yarn.lock）の読み込み
3. 依存関係の解決（バージョン制約の解決）
4. npmレジストリからのパッケージ情報取得
5. パッケージのダウンロードと展開
6. node_modulesへのリンク作成
7. postinstall等のライフサイクルスクリプト実行
8. lockfileの更新

**画面遷移**：
- エントリーポイント：`bun install` コマンドから直接実行
- 遷移先：インストール完了後はターミナルに制御を返す
- 関連コマンド：`bun add`（パッケージ追加）、`bun remove`（パッケージ削除）

**権限による表示制御**：特になし。ファイルシステムの読み書き権限に依存。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | bun install | 主機能 | package.jsonに基づく依存関係のインストール |
| 39 | 依存関係解決 | 主機能 | バージョン制約に基づく依存関係ツリーの構築 |
| 40 | パッケージキャッシュ | 補助機能 | ダウンロード済みパッケージのキャッシュ管理 |
| 41 | npmレジストリ | 補助機能 | npmレジストリからのパッケージ情報・ファイル取得 |
| 42 | lockfile管理 | 補助機能 | bun.lockb/package-lock.json/yarn.lockの読み書き |
| 43 | ライフサイクルスクリプト | 補助機能 | preinstall/postinstall等のスクリプト実行 |
| 44 | ワークスペース | 補助機能 | monorepo環境での複数パッケージ管理 |

## 画面種別

コマンドラインインターフェース（CLI）- パッケージインストールコマンド

## URL/ルーティング

コマンドラインパターン:
- `bun install [flags]`
- `bun i [flags]`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| --production / -p | flag | No | devDependenciesを除外してインストール |
| --frozen-lockfile | flag | No | lockfileを更新せず、不一致時はエラー |
| --no-save | flag | No | lockfileを更新しない |
| --dry-run | flag | No | 実際にはインストールせず計画を表示 |
| --force | flag | No | キャッシュを無視して再インストール |
| --verbose | flag | No | 詳細ログを表示 |
| --silent | flag | No | 出力を抑制 |
| --ignore-scripts | flag | No | ライフサイクルスクリプトを実行しない |
| --concurrent-scripts | number | No | 同時実行スクリプト数 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| インストール進捗 | text | パッケージのダウンロード・インストール状況 |
| サマリー | text | インストール完了パッケージ数と所要時間 |
| 警告 | text | 非推奨パッケージ等の警告 |
| エラー | text | 依存関係解決エラー等 |
| exit code | number | 0: 成功、1: エラー |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| バージョン表示 | 常時 | `bun install v{version}` |
| 進捗バー | インストール中 | パッケージダウンロード進捗 |
| パッケージ数 | 完了時 | インストールされたパッケージ総数 |
| 所要時間 | 完了時 | インストールにかかった時間 |
| 警告メッセージ | 警告発生時 | 非推奨パッケージ、peer dependency不足等 |

## イベント仕様

### 1-通常インストール

ユーザーが`bun install`を実行した場合の処理フロー：

1. コマンドライン引数の解析（CommandLineArguments.parse）
2. PackageManagerの初期化
3. package.jsonの読み込み
4. lockfileの読み込み（存在する場合）
5. 依存関係の解決
6. パッケージのダウンロード（並列）
7. node_modulesへの展開
8. シンボリックリンクの作成
9. ライフサイクルスクリプトの実行
10. lockfileの更新
11. サマリー表示

### 2-frozen-lockfileモード

--frozen-lockfileオプション指定時の処理フロー：

1. lockfileを読み込み
2. package.jsonとlockfileの整合性チェック
3. 不一致がある場合はエラー終了
4. lockfileに基づいてインストール（lockfile更新なし）

### 3-ワークスペースインストール

monorepo環境での処理フロー：

1. ルートpackage.jsonのworkspaces設定を読み込み
2. 各ワークスペースのpackage.jsonを収集
3. 統合された依存関係ツリーを構築
4. ホイスティングによる重複排除
5. 各ワークスペースへのインストール

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| VERSION | info | bun install v{version} | コマンド開始時 |
| NO_PACKAGE_JSON | error | No package.json was found for directory "{cwd}" | package.jsonが存在しない |
| RESOLVE_ERROR | error | Failed to resolve "{package}" | 依存関係解決失敗 |
| NETWORK_ERROR | error | Network error while fetching "{url}" | ネットワークエラー |
| LOCKFILE_MISMATCH | error | Lockfile does not match package.json | frozen-lockfile時の不一致 |
| SUMMARY | info | Installed {count} packages in {time} | インストール完了 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| package.json不在 | カレントディレクトリにpackage.jsonがない | エラーメッセージを表示し`bun init`を提案 |
| 依存関係解決失敗 | バージョン制約を満たせない | 競合の詳細を表示しエラー終了 |
| ネットワークエラー | レジストリへの接続失敗 | リトライ後、エラー終了 |
| ディスク容量不足 | インストール先の容量不足 | エラーメッセージを表示 |
| 権限エラー | node_modulesへの書き込み権限なし | エラーメッセージを表示 |

## 備考

- Bunはbun.lockb（バイナリ形式）とpackage-lock.json/yarn.lockの両方をサポート
- --frozen-lockfileはCI環境での使用を推奨
- ワークスペースはyarn/npm workspaces互換
- 信頼済み依存関係リスト（trustedDependencies）によるセキュリティ制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

installコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | install_command.zig | `src/cli/install_command.zig` | InstallCommand構造体とexec関数 |

**主要処理フロー**:
1. **行2-13**: `exec`関数でinstallを呼び出し、エラーハンドリング
2. **行16-56**: `install`関数 - CLI引数解析とインストール処理の呼び出し
3. **行24-53**: `--analyze`オプション時のバンドラー依存関係スキャン
4. **行58-85**: `installWithCLI`関数 - PackageManager初期化とインストール実行

#### Step 2: PackageManagerを理解する

パッケージマネージャーのメイン実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | install.zig | `src/install/install.zig` | PackageManager構造体 |

**読解のコツ**: PackageManagerはBunのパッケージマネージャーの中核。init、installWithManager等の関数を持つ。

#### Step 3: lockfile管理を理解する

lockfileの読み書き処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lockfile.zig | `src/install/lockfile.zig` | Lockfile構造体 |

### プログラム呼び出し階層図

```
InstallCommand.exec()
    |
    +-- install()
            |
            +-- CommandLineArguments.parse()
            |
            +-- [--analyze時]
            |       +-- BundleV2.DependenciesScanner
            |
            +-- installWithCLI()
                    |
                    +-- PackageManager.init()
                    |
                    +-- [add subcommand時]
                    |       +-- updatePackageJSONAndInstallWithManager()
                    |
                    +-- [install subcommand時]
                            +-- installWithManager()
                                    |
                                    +-- lockfile.loadFromCwd()
                                    +-- 依存関係解決
                                    +-- パッケージダウンロード
                                    +-- node_modules展開
                                    +-- ライフサイクルスクリプト実行
                                    +-- lockfile.save()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

package.json -----------> PackageManager.init() -----> 依存関係リスト
        |
        v
bun.lockb/lockfile -----> lockfile.loadFromCwd() ----> 解決済み依存関係
        |
        v
npm registry -----------> HTTP fetch ---------------> パッケージデータ
        |
        v
                          パッケージ展開 ------------> node_modules/
        |
        v
                          lockfile.save() -----------> bun.lockb更新
        |
        v
                          サマリー出力 --------------> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| install_command.zig | `src/cli/install_command.zig` | ソース | installコマンドのエントリーポイント |
| install.zig | `src/install/install.zig` | ソース | PackageManagerのメイン実装 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile管理 |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリクライアント |
| PackageInstaller.zig | `src/install/PackageInstaller.zig` | ソース | パッケージ展開処理 |
| lifecycle_script_runner.zig | `src/install/lifecycle_script_runner.zig` | ソース | ライフサイクルスクリプト実行 |
| Tree.zig | `src/install/lockfile/Tree.zig` | ソース | 依存関係ツリー管理 |
| CommandLineArguments.zig | `src/install/PackageManager/CommandLineArguments.zig` | ソース | CLI引数定義 |
