# 画面設計書 7-add

## 概要

本ドキュメントは、Bun CLIの`add`コマンドの設計仕様を記述する。`bun add`コマンドは、指定したパッケージをプロジェクトに追加し、package.jsonを更新する機能を提供する。

### 本画面の処理概要

`bun add`コマンドは、npmレジストリから指定したパッケージを取得し、node_modulesにインストールするとともに、package.jsonのdependenciesまたはdevDependenciesを更新する。npm/yarn/pnpmの`add`コマンドと互換性のある動作を提供。

**業務上の目的・背景**：プロジェクト開発において、新しいライブラリやツールを追加する操作は頻繁に行われる。高速なパッケージ追加により、開発フローを中断せずに必要なパッケージを導入できる。また、バージョン指定やdevDependenciesへの追加など、柔軟なオプションを提供。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun add <package>` または `bun a <package>` - パッケージを追加
- `bun add -d <package>` - devDependenciesに追加
- `bun add <package>@<version>` - バージョン指定で追加

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. パッケージ名とバージョンの解析
3. npmレジストリからパッケージ情報取得
4. バージョン解決
5. package.jsonの更新
6. パッケージのインストール
7. lockfileの更新

**画面遷移**：
- エントリーポイント：`bun add` コマンドから直接実行
- 遷移先：追加完了後はターミナルに制御を返す
- 関連コマンド：`bun install`（インストール）、`bun remove`（削除）

**権限による表示制御**：特になし。ファイルシステムの読み書き権限に依存。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | bun add | 主機能 | パッケージの追加とpackage.json更新 |
| 39 | 依存関係解決 | 補助機能 | 追加パッケージの依存関係解決 |
| 41 | npmレジストリ | 補助機能 | パッケージ情報の取得 |
| 42 | lockfile管理 | 補助機能 | lockfileの更新 |

## 画面種別

コマンドラインインターフェース（CLI）- パッケージ追加コマンド

## URL/ルーティング

コマンドラインパターン:
- `bun add [flags] <packages...>`
- `bun a [flags] <packages...>`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| packages | string[] | Yes | 追加するパッケージ名（@version指定可） |
| -d / --dev / -D | flag | No | devDependenciesに追加 |
| -p / --peer | flag | No | peerDependenciesに追加 |
| -O / --optional | flag | No | optionalDependenciesに追加 |
| -E / --exact | flag | No | 正確なバージョンで追加（^ なし） |
| --no-save | flag | No | package.jsonを更新しない |
| --verbose | flag | No | 詳細ログを表示 |
| --silent | flag | No | 出力を抑制 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 追加進捗 | text | パッケージの追加状況 |
| サマリー | text | 追加されたパッケージ名とバージョン |
| 警告 | text | 非推奨パッケージ等の警告 |
| エラー | text | パッケージが見つからない等のエラー |
| exit code | number | 0: 成功、1: エラー |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| バージョン表示 | 常時 | `bun add v{version}` |
| 追加パッケージ | 追加成功時 | パッケージ名@バージョン |
| 警告メッセージ | 警告発生時 | 非推奨パッケージ等 |
| エラーメッセージ | エラー時 | パッケージ不在、バージョン不一致等 |

## イベント仕様

### 1-パッケージ追加

ユーザーが`bun add <package>`を実行した場合の処理フロー：

1. コマンドライン引数の解析
2. UpdateRequest.parseでパッケージ名とバージョンを解析
3. PackageManagerの初期化
4. npmレジストリからパッケージ情報を取得
5. バージョン制約を解決
6. package.jsonを更新
7. node_modulesにインストール
8. lockfileを更新
9. サマリー表示

### 2-devDependencies追加

-dオプション指定時の処理フロー：

1. 通常の追加処理と同様
2. package.jsonのdevDependenciesセクションに追加
3. 本番ビルド時に除外される

### 3-複数パッケージ追加

複数パッケージを同時に指定した場合の処理フロー：

1. 各パッケージに対して依存関係を解決
2. 統合された依存関係ツリーを構築
3. 一括でインストール
4. package.jsonを一度に更新

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| VERSION | info | bun add v{version} | コマンド開始時 |
| NOT_FOUND | error | Package "{package}" not found | パッケージが存在しない |
| VERSION_NOT_FOUND | error | Version "{version}" not found for "{package}" | 指定バージョンが存在しない |
| ADDED | success | Added {package}@{version} | 追加成功 |
| UPDATED | info | Updated {package} to {version} | バージョン更新 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| パッケージ不在 | レジストリにパッケージがない | エラーメッセージを表示し終了コード1で終了 |
| バージョン不在 | 指定バージョンが存在しない | 利用可能なバージョン一覧を表示 |
| ネットワークエラー | レジストリへの接続失敗 | リトライ後、エラー終了 |
| package.json不在 | ファイルが存在しない | エラーメッセージを表示 |

## 備考

- `bun a`は`bun add`のエイリアス
- バージョン指定なしの場合は最新安定版（latest）が追加される
- GitHub URLやTarball URLからの追加もサポート
- ワークスペース環境では-wオプションでルートに追加可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

addコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | add_command.zig | `src/cli/add_command.zig` | AddCommand構造体とexec関数 |

**主要処理フロー**:
1. **行2-4**: `exec`関数でupdatePackageJSONAndInstallCatchErrorを呼び出し
2. **行3**: `.add`サブコマンドとして実行

**読解のコツ**: AddCommandは非常にシンプルで、実際の処理はPackageManager.updatePackageJSONAndInstallCatchErrorに委譲される。

#### Step 2: パッケージ追加処理を理解する

PackageManager側の追加処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | updatePackageJSONAndInstall.zig | `src/install/PackageManager/updatePackageJSONAndInstall.zig` | 追加処理の実装 |
| 2-2 | UpdateRequest.zig | `src/install/PackageManager/UpdateRequest.zig` | パッケージ指定の解析 |

**読解のコツ**: UpdateRequestがパッケージ名@バージョンの解析を担当。updatePackageJSONAndInstallがpackage.json更新とインストールを統合。

#### Step 3: package.json編集処理を理解する

package.jsonの更新処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PackageJSONEditor.zig | `src/install/PackageManager/PackageJSONEditor.zig` | package.jsonの編集 |

### プログラム呼び出し階層図

```
AddCommand.exec()
    |
    +-- updatePackageJSONAndInstallCatchError(.add)
            |
            +-- CommandLineArguments.parse()
            |
            +-- PackageManager.init()
            |
            +-- updatePackageJSONAndInstallWithManager()
                    |
                    +-- UpdateRequest.parse() (各パッケージ)
                    |
                    +-- PackageJSONEditor.addDependency()
                    |
                    +-- npmレジストリからパッケージ情報取得
                    |
                    +-- 依存関係解決
                    |
                    +-- インストール
                    |
                    +-- lockfile.save()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bun add <pkg>@<ver> ----> UpdateRequest.parse() -----> パッケージ情報
        |
        v
npm registry -----------> HTTP fetch ---------------> パッケージメタデータ
        |
        v
package.json -----------> PackageJSONEditor ---------> package.json更新
        |
        v
                          インストール処理 -----------> node_modules/
        |
        v
                          lockfile.save() -----------> bun.lockb更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| add_command.zig | `src/cli/add_command.zig` | ソース | addコマンドのエントリーポイント |
| updatePackageJSONAndInstall.zig | `src/install/PackageManager/updatePackageJSONAndInstall.zig` | ソース | 追加・更新・削除の統合処理 |
| UpdateRequest.zig | `src/install/PackageManager/UpdateRequest.zig` | ソース | パッケージ指定の解析 |
| PackageJSONEditor.zig | `src/install/PackageManager/PackageJSONEditor.zig` | ソース | package.json編集 |
| install.zig | `src/install/install.zig` | ソース | PackageManager本体 |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリクライアント |
