# 画面設計書 8-remove

## 概要

本ドキュメントは、Bun CLIの`remove`コマンドの設計仕様を記述する。`bun remove`コマンドは、指定したパッケージをプロジェクトから削除し、package.jsonを更新する機能を提供する。

### 本画面の処理概要

`bun remove`コマンドは、指定したパッケージをnode_modulesから削除し、package.jsonのdependencies/devDependencies等から該当エントリを削除する。npm/yarn/pnpmの`remove`/`uninstall`コマンドと互換性のある動作を提供。

**業務上の目的・背景**：プロジェクト開発において、不要になったライブラリの削除は重要なメンテナンス作業である。不要な依存関係を削除することで、プロジェクトサイズの縮小、セキュリティリスクの軽減、ビルド時間の短縮が実現できる。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun remove <package>` または `bun rm <package>` - パッケージを削除
- `bun remove <package1> <package2>` - 複数パッケージを同時削除

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. パッケージ名の解析
3. package.jsonからの該当エントリ削除
4. node_modulesからの削除
5. lockfileの更新

**画面遷移**：
- エントリーポイント：`bun remove` コマンドから直接実行
- 遷移先：削除完了後はターミナルに制御を返す
- 関連コマンド：`bun add`（追加）、`bun install`（インストール）

**権限による表示制御**：特になし。ファイルシステムの読み書き権限に依存。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | bun remove | 主機能 | パッケージの削除とpackage.json更新 |
| 39 | 依存関係解決 | 補助機能 | 削除後の依存関係ツリー再構築 |
| 42 | lockfile管理 | 補助機能 | lockfileの更新 |

## 画面種別

コマンドラインインターフェース（CLI）- パッケージ削除コマンド

## URL/ルーティング

コマンドラインパターン:
- `bun remove [flags] <packages...>`
- `bun rm [flags] <packages...>`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| packages | string[] | Yes | 削除するパッケージ名 |
| --verbose | flag | No | 詳細ログを表示 |
| --silent | flag | No | 出力を抑制 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 削除結果 | text | 削除されたパッケージ名 |
| 警告 | text | パッケージが見つからない場合の警告 |
| エラー | text | 削除失敗時のエラー |
| exit code | number | 0: 成功、1: エラー |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 削除パッケージ | 削除成功時 | 削除されたパッケージ名 |
| 警告メッセージ | パッケージ不在時 | 指定パッケージがpackage.jsonに存在しない |
| エラーメッセージ | エラー時 | 削除処理の失敗原因 |

## イベント仕様

### 1-パッケージ削除

ユーザーが`bun remove <package>`を実行した場合の処理フロー：

1. コマンドライン引数の解析
2. PackageManagerの初期化
3. package.jsonの読み込み
4. 指定パッケージの検索（dependencies/devDependencies等）
5. package.jsonから該当エントリを削除
6. 依存関係ツリーの再構築
7. 不要になったパッケージをnode_modulesから削除
8. lockfileを更新
9. 結果表示

### 2-複数パッケージ削除

複数パッケージを同時に指定した場合の処理フロー：

1. 各パッケージに対して削除処理を実行
2. package.jsonを一度に更新
3. 統合された依存関係ツリーを再構築
4. 一括でクリーンアップ

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| REMOVED | success | Removed {package} | 削除成功 |
| NOT_FOUND | warning | Package "{package}" is not in package.json | パッケージが存在しない |
| REMOVE_ERROR | error | Failed to remove "{package}" | 削除失敗 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| パッケージ不在 | package.jsonにパッケージがない | 警告を表示し続行 |
| package.json不在 | ファイルが存在しない | エラーメッセージを表示 |
| 権限エラー | ファイルへの書き込み権限なし | エラーメッセージを表示 |

## 備考

- `bun rm`は`bun remove`のエイリアス
- npm/yarn互換の`bun uninstall`もサポート
- 削除後に使われなくなった推移的依存関係も自動的に削除される
- ワークスペース環境では-wオプションでルートから削除可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

removeコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | remove_command.zig | `src/cli/remove_command.zig` | RemoveCommand構造体とexec関数 |

**主要処理フロー**:
1. **行2-4**: `exec`関数でupdatePackageJSONAndInstallCatchErrorを呼び出し
2. **行3**: `.remove`サブコマンドとして実行

**読解のコツ**: RemoveCommandはAddCommandと同様にシンプルで、実際の処理はPackageManager.updatePackageJSONAndInstallCatchErrorに委譲される。

#### Step 2: パッケージ削除処理を理解する

PackageManager側の削除処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | updatePackageJSONAndInstall.zig | `src/install/PackageManager/updatePackageJSONAndInstall.zig` | 削除処理の実装 |
| 2-2 | PackageJSONEditor.zig | `src/install/PackageManager/PackageJSONEditor.zig` | package.jsonの編集 |

**読解のコツ**: .removeサブコマンド時の処理フローを追跡。PackageJSONEditorのremoveDependency等のメソッドが使用される。

### プログラム呼び出し階層図

```
RemoveCommand.exec()
    |
    +-- updatePackageJSONAndInstallCatchError(.remove)
            |
            +-- CommandLineArguments.parse()
            |
            +-- PackageManager.init()
            |
            +-- updatePackageJSONAndInstallWithManager()
                    |
                    +-- package.json読み込み
                    |
                    +-- 指定パッケージの検索
                    |
                    +-- PackageJSONEditor.removeDependency()
                    |
                    +-- 依存関係ツリー再構築
                    |
                    +-- node_modulesクリーンアップ
                    |
                    +-- lockfile.save()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bun remove <pkg> -------> RemoveCommand.exec() ------> 処理開始
        |
        v
package.json -----------> パッケージ検索 ------------> 削除対象特定
        |
        v
                          PackageJSONEditor ---------> package.json更新
        |
        v
                          依存関係再構築 ------------> 不要パッケージ特定
        |
        v
node_modules -----------> クリーンアップ ------------> ファイル削除
        |
        v
                          lockfile.save() -----------> bun.lockb更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| remove_command.zig | `src/cli/remove_command.zig` | ソース | removeコマンドのエントリーポイント |
| updatePackageJSONAndInstall.zig | `src/install/PackageManager/updatePackageJSONAndInstall.zig` | ソース | 追加・更新・削除の統合処理 |
| PackageJSONEditor.zig | `src/install/PackageManager/PackageJSONEditor.zig` | ソース | package.json編集 |
| install.zig | `src/install/install.zig` | ソース | PackageManager本体 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile管理 |
