# 画面設計書 9-update

## 概要

本ドキュメントは、Bun CLIの`update`コマンドの設計仕様を記述する。`bun update`コマンドは、プロジェクトの依存関係を最新バージョンに更新する機能を提供する。

### 本画面の処理概要

`bun update`コマンドは、package.jsonに定義された依存関係のバージョンを、バージョン制約の範囲内で最新版に更新する。または`--latest`オプションで制約を無視して最新版に更新することも可能。

**業務上の目的・背景**：プロジェクトの依存関係を最新状態に保つことは、セキュリティ修正の適用やバグ修正の取得、新機能の活用において重要である。semver制約の範囲内での安全な更新と、破壊的変更を含む可能性のある最新版への更新の両方をサポート。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun update` - 全依存関係をバージョン制約内で更新
- `bun update <package>` - 特定パッケージを更新
- `bun update --latest` - バージョン制約を無視して最新版に更新
- `bun update --interactive` - 対話的に更新対象を選択

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. 現在の依存関係とバージョンの取得
3. npmレジストリから最新バージョン情報を取得
4. 更新可能なパッケージの特定
5. package.jsonの更新（--latest時）
6. lockfileの更新
7. node_modulesへのインストール

**画面遷移**：
- エントリーポイント：`bun update` コマンドから直接実行
- 遷移先：更新完了後はターミナルに制御を返す
- 関連コマンド：`bun outdated`（更新可能パッケージ確認）、`bun install`（インストール）

**権限による表示制御**：特になし。ファイルシステムの読み書き権限に依存。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | bun update | 主機能 | 依存関係の更新処理 |
| 39 | 依存関係解決 | 補助機能 | 更新後の依存関係ツリー再構築 |
| 41 | npmレジストリ | 補助機能 | 最新バージョン情報の取得 |
| 42 | lockfile管理 | 補助機能 | lockfileの更新 |

## 画面種別

コマンドラインインターフェース（CLI）- パッケージ更新コマンド

## URL/ルーティング

コマンドラインパターン:
- `bun update [flags] [packages...]`

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| packages | string[] | No | 更新するパッケージ名（省略時は全パッケージ） |
| --latest | flag | No | バージョン制約を無視して最新版に更新 |
| --interactive / -i | flag | No | 対話的に更新対象を選択 |
| --dry-run | flag | No | 実際には更新せず計画を表示 |
| --verbose | flag | No | 詳細ログを表示 |
| --silent | flag | No | 出力を抑制 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 更新パッケージ | text | 更新されたパッケージ名とバージョン |
| サマリー | text | 更新パッケージ数と所要時間 |
| 警告 | text | 破壊的変更の可能性等の警告 |
| エラー | text | 更新失敗時のエラー |
| exit code | number | 0: 成功、1: エラー |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| 更新前後バージョン | 更新時 | package@old -> package@new |
| 更新パッケージ数 | 完了時 | 更新されたパッケージの総数 |
| 警告メッセージ | --latest時 | 破壊的変更の可能性に関する注意 |
| 対話的選択UI | --interactive時 | チェックボックス形式の選択UI |

## イベント仕様

### 1-通常更新

ユーザーが`bun update`を実行した場合の処理フロー：

1. コマンドライン引数の解析（CommandLineArguments.parse）
2. PackageManagerの初期化
3. 現在のlockfileを読み込み
4. npmレジストリから各パッケージの最新情報を取得
5. バージョン制約内で更新可能なパッケージを特定
6. lockfileを更新
7. node_modulesに更新をインストール
8. 結果表示

### 2-最新版更新（--latest）

--latestオプション指定時の処理フロー：

1. 通常更新と同様の初期処理
2. バージョン制約を無視して最新版を取得
3. package.jsonのバージョン指定を更新
4. lockfileを更新
5. node_modulesに更新をインストール
6. 破壊的変更の警告を表示

### 3-対話的更新（--interactive）

--interactiveオプション指定時の処理フロー：

1. UpdateInteractiveCommandを呼び出し
2. 更新可能なパッケージ一覧を取得
3. チェックボックス形式のUIを表示
4. ユーザーが更新対象を選択
5. 選択されたパッケージのみ更新
6. 結果表示

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| UPDATED | success | Updated {package} {old} -> {new} | 更新成功 |
| NO_UPDATES | info | All packages are up to date | 更新対象なし |
| LATEST_WARNING | warning | Breaking changes may occur with --latest | --latest使用時 |
| UPDATE_ERROR | error | Failed to update "{package}" | 更新失敗 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| パッケージ不在 | 指定パッケージがpackage.jsonにない | 警告を表示し続行 |
| ネットワークエラー | レジストリへの接続失敗 | リトライ後、エラー終了 |
| バージョン解決失敗 | 制約を満たすバージョンがない | エラーメッセージを表示 |

## 備考

- バージョン制約（^, ~, >=等）を尊重した安全な更新がデフォルト
- --latestは破壊的変更を含む可能性があるため注意が必要
- --interactiveはターミナルのTTY機能を使用
- outdatedコマンドで事前に更新可能なパッケージを確認可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

updateコマンドの起点となる処理を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | update_command.zig | `src/cli/update_command.zig` | UpdateCommand構造体とexec関数 |

**主要処理フロー**:
1. **行2-11**: `exec`関数 - CLI引数解析と分岐処理
2. **行3**: CommandLineArguments.parseでオプション解析
3. **行5-7**: --interactive時はUpdateInteractiveCommandを呼び出し
4. **行9**: 通常時はupdatePackageJSONAndInstallCatchErrorを呼び出し

**読解のコツ**: UpdateCommandは--interactiveオプションの有無で処理が分岐する。通常更新はadd/removeと同様のフローを使用。

#### Step 2: 対話的更新を理解する

--interactiveオプション時の処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | update_interactive_command.zig | `src/cli/update_interactive_command.zig` | UpdateInteractiveCommand |

**読解のコツ**: 対話的UIの実装とユーザー選択処理。

#### Step 3: 通常更新処理を理解する

PackageManager側の更新処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | updatePackageJSONAndInstall.zig | `src/install/PackageManager/updatePackageJSONAndInstall.zig` | 更新処理の実装 |

### プログラム呼び出し階層図

```
UpdateCommand.exec()
    |
    +-- CommandLineArguments.parse()
    |
    +-- [--interactive時]
    |       +-- UpdateInteractiveCommand.exec()
    |               |
    |               +-- 更新可能パッケージ一覧取得
    |               +-- 対話的UIの表示
    |               +-- ユーザー選択の処理
    |               +-- 選択パッケージの更新
    |
    +-- [通常時]
            +-- updatePackageJSONAndInstallCatchError(.update)
                    |
                    +-- PackageManager.init()
                    +-- lockfile読み込み
                    +-- 最新バージョン取得
                    +-- バージョン解決
                    +-- [--latest時] package.json更新
                    +-- lockfile更新
                    +-- インストール
```

### データフロー図

```
[入力]                    [処理]                         [出力]

bun update [pkg] -------> UpdateCommand.exec() ------> 処理開始
        |
        v
lockfile ---------------> 現在のバージョン取得 -------> 現在バージョンリスト
        |
        v
npm registry -----------> 最新バージョン取得 ---------> 最新バージョンリスト
        |
        v
                          バージョン比較 ------------> 更新対象パッケージ
        |
        v
[--latest時]
package.json -----------> バージョン更新 ------------> package.json更新
        |
        v
                          lockfile更新 --------------> bun.lockb更新
        |
        v
                          インストール処理 -----------> node_modules更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| update_command.zig | `src/cli/update_command.zig` | ソース | updateコマンドのエントリーポイント |
| update_interactive_command.zig | `src/cli/update_interactive_command.zig` | ソース | 対話的更新の実装 |
| updatePackageJSONAndInstall.zig | `src/install/PackageManager/updatePackageJSONAndInstall.zig` | ソース | 更新処理の統合 |
| install.zig | `src/install/install.zig` | ソース | PackageManager本体 |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリクライアント |
| lockfile.zig | `src/install/lockfile.zig` | ソース | lockfile管理 |
