---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：10-audit.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **--ignoreオプションの実装詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/audit_command.zig` - AuditCommand全体の実装
- E-02: `src/cli/audit_command.zig:1-8` - VulnerabilityInfo構造体
- E-03: `src/cli/audit_command.zig:10-21` - PackageInfo構造体
- E-04: `src/cli/audit_command.zig:23-48` - AuditResult構造体
- E-05: `src/cli/audit_command.zig:50-70` - exec関数
- E-06: `src/cli/audit_command.zig:75-134` - audit関数
- E-07: `src/cli/audit_command.zig:155-189` - buildDependencyTree関数
- E-08: `src/cli/audit_command.zig:191-233` - buildProductionPackageSet関数
- E-09: `src/cli/audit_command.zig:235-342` - collectPackagesForAudit関数
- E-10: `src/cli/audit_command.zig:344-407` - sendAuditRequest関数
- E-11: `src/cli/audit_command.zig:599-820` - printEnhancedAuditReport関数
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | auditコマンドはセキュリティ脆弱性をチェックする | E-01, E-13 | ○ |
| C-02 | VulnerabilityInfo構造体に脆弱性情報が含まれる | E-02 | ○ |
| C-03 | PackageInfo構造体にパッケージと脆弱性の関連が含まれる | E-03 | ○ |
| C-04 | AuditResult構造体に監査結果全体が含まれる | E-04 | ○ |
| C-05 | exec関数でCommandLineArguments.parseを呼び出す | E-05 (行52) | ○ |
| C-06 | PackageManager.initでpackage.jsonの存在を確認する | E-05 (行53-66) | ○ |
| C-07 | package.json不在時はエラーメッセージとbun init提案を表示 | E-05 (行57-61) | ○ |
| C-08 | audit関数でバージョン表示を行う | E-06 (行76-77) | ○ |
| C-09 | lockfile.loadFromCwdでlockfileを読み込む | E-06 (行79) | ○ |
| C-10 | buildDependencyTreeで依存関係ツリーを構築する | E-07 | ○ |
| C-11 | collectPackagesForAuditで監査対象パッケージを収集する | E-09 | ○ |
| C-12 | sendAuditRequestでnpm脆弱性APIにリクエストを送信する | E-10 | ○ |
| C-13 | gzip圧縮でリクエストを送信する | E-10 (行346-354) | ○ |
| C-14 | 認証トークン/Basic認証をサポートする | E-10 (行360-375) | ○ |
| C-15 | --json時はJSON形式で出力する | E-06 (行97-120) | ○ |
| C-16 | printEnhancedAuditReportでレポートを生成・表示する | E-11 | ○ |
| C-17 | 重大度別（critical/high/moderate/low）に集計する | E-11 (行625-678) | ○ |
| C-18 | 脆弱性がない場合は"No vulnerabilities found"を表示する | E-06 (行128), E-11 (行618-619) | ○ |
| C-19 | 脆弱性検出時は終了コード1を返す | E-11 (行810-813) | ○ |
| C-20 | --productionでdevDependenciesを除外する | E-08 | ○ |
| C-21 | buildProductionPackageSetで本番パッケージセットを構築する | E-08 | ○ |
| C-22 | findDependencyPathsで依存関係パスを計算する | E-01 (行453-597) | ○ |
| C-23 | npm脆弱性API（/-/npm/v1/security/advisories/bulk）を使用する | E-10 (行377) | ○ |
| C-24 | デフォルトレジストリ以外のパッケージはスキップされる | E-09 (行279-283), E-06 (行137-153) | ○ |
| C-25 | parseVulnerabilityで脆弱性情報を解析する | E-01 (行409-451) | ○ |
| C-26 | 修正提案（bun update等）を表示する | E-11 (行803-808) | ○ |
| C-27 | HTTPステータス400以上でエラー出力する | E-10 (行401-404) | ○ |
| C-28 | --ignoreオプションで特定のCVEを無視可能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: --ignoreオプションの実装詳細
  - audit関数の引数にignore_listは確認できるが、CLI引数としての定義詳細は未確認
  - 候補：`src/install/PackageManager/CommandLineArguments.zig`

## 5) リスクフラグ（レビュー観点）
- 0: データ構造定義 - 低リスク（ソースで確認済み）
- 0: エントリーポイント - 低リスク（ソースで確認済み）
- 0: 監査処理フロー - 低リスク（ソースで確認済み）
- 0: 依存関係ツリー構築 - 低リスク（ソースで確認済み）
- 0: npm API連携 - 低リスク（ソースで確認済み）
- 0: レポート生成 - 低リスク（ソースで確認済み）
- 1: --ignoreオプション - 中リスク（CLI定義の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] C-01〜C-27の主張がソースコードと整合しているか確認
- [ ] --ignoreオプションのCLI定義を確認
- [ ] npm脆弱性APIのレスポンス形式を確認
- [ ] gzip圧縮処理が正しく動作するか確認
- [ ] 認証処理が正しく動作するか確認
- [ ] 重大度フィルタリング（--level）の動作を確認
