---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-outdated 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **minimum_release_ageオプション**：コード内に存在するがドキュメントや使用方法の詳細が不明
  2. **プライベートレジストリ認証**：コード上は対応しているが詳細仕様の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/outdated_command.zig` L9-28 exec関数
- E-02: `src/cli/outdated_command.zig` L2-7 OutdatedInfo構造体
- E-03: `src/cli/outdated_command.zig` L30-101 outdated関数
- E-04: `src/cli/outdated_command.zig` L221-227 GroupedOutdatedInfo構造体
- E-05: `src/cli/outdated_command.zig` L323-688 printOutdatedInfoTable関数
- E-06: `src/cli/outdated_command.zig` L229-321 groupCatalogDependencies関数
- E-07: `src/cli/outdated_command.zig` L122-137 getAllWorkspaces関数
- E-08: `src/cli/outdated_command.zig` L139-219 findMatchingWorkspaces関数
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` L12 outdatedコマンド定義
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L46-47 outdated関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がエントリーポイント | E-01 | ○ |
| C-02 | OutdatedInfo構造体でパッケージ情報を管理 | E-02 | ○ |
| C-03 | ロックファイルから依存関係を読み込む | E-03 | ○ |
| C-04 | catalog依存関係のグループ化対応 | E-04, E-06 | ○ |
| C-05 | テーブル形式で結果を出力 | E-05 | ○ |
| C-06 | --filterオプションでワークスペースフィルタ | E-08 | ○ |
| C-07 | --recursiveオプションで全ワークスペース対象 | E-07 | ○ |
| C-08 | ANSIカラー対応の出力 | E-05 L328 | ○ |
| C-09 | 依存タイプ（dev/peer/optional）の表示 | E-05 L449-456, L599-606 | ○ |
| C-10 | パッケージパターンによるフィルタリング | E-05 L329-364 | ○ |
| C-11 | npmレジストリから最新バージョン取得 | E-05 L424-431 | ○ |
| C-12 | Current/Update/Latest列の表示 | E-05 L527-540 | ○ |
| C-13 | Workspace列の条件付き表示 | E-05 L514, L526-540 | ○ |
| C-14 | package.json未検出時のエラー | E-01 L17-18 | ○ |
| C-15 | ロックファイル未検出時のエラー | E-03 L39-43 | ○ |
| C-16 | ロックファイル解析エラーの処理 | E-03 L45-67 | ○ |
| C-17 | バージョン差分のカラー表示 | E-05 L632, L652 | ○ |
| C-18 | minimum_release_ageによるフィルタ | E-05 L435-440 | ○ |
| C-19 | フィルタ時の*マーク表示 | E-05 L685-687 | ○ |
| C-20 | globパターンによる名前マッチング | E-05 L407-408 | ○ |
| C-21 | 画面一覧での定義との整合性 | E-09 | ○ |
| C-22 | 機能マッピングとの整合性 | E-10 | ○ |
| C-23 | プライベートレジストリの認証対応 | **根拠なし** | △ |
| C-24 | minimum_release_ageオプションの詳細仕様 | **根拠不足** | △ |
| C-25 | 単独実行で他画面への遷移なし | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-23: プライベートレジストリ認証**
  - コード内ではscopeを通じてレジストリ設定が参照されているが、outdated固有の認証処理は明示されていない
  - 候補：PackageManager.scopeForPackageName / npm.zig / bunfig.toml設定

- **C-24: minimum_release_age詳細仕様**
  - コード内に `manager.options.minimum_release_age_ms` が存在するが、CLIオプションとしての定義箇所が未確認
  - 候補：CommandLineArguments.parse / options定義ファイル

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 基本的な機能説明は正確
- **1: 中リスク** - minimum_release_ageオプションの使用方法が不明確。ユーザー向けドキュメントでの説明が必要な可能性

## 6) レビュアーチェックリスト（最小）

- [ ] exec関数のエラーハンドリングが網羅されているか確認
- [ ] テーブル出力の列順序がコードと一致しているか確認
- [ ] minimum_release_ageオプションのCLI引数定義を確認
- [ ] プライベートレジストリ使用時の動作を実機テストで確認
