---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-link 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **プロジェクトリンク時のpackage.json更新内容**：updatePackageJSONAndInstallWithManagerの詳細な挙動確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/link_command.zig` L1-5 LinkCommand構造体とexec関数
- E-02: `src/cli/link_command.zig` L7-190 link関数
- E-03: `src/cli/link_command.zig` L32-56 package.json解析とパッケージ名取得
- E-04: `src/cli/link_command.zig` L59-74 グローバルディレクトリセットアップ
- E-05: `src/cli/link_command.zig` L77-124 シンボリックリンク/ジャンクション作成
- E-06: `src/cli/link_command.zig` L127-163 Bin.Linkerによるバイナリリンク
- E-07: `src/cli/link_command.zig` L168-182 成功メッセージ出力
- E-08: `src/cli/link_command.zig` L186-189 updatePackageJSONAndInstallWithManager呼び出し
- E-09: `src/cli/link_command.zig` L93-115 Windows固有のジャンクション処理
- E-10: `src/cli/link_command.zig` L82-91 スコープ付きパッケージのディレクトリ作成
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` L13 linkコマンド定義
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L48-49 link関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がlink関数に委譲 | E-01 | ○ |
| C-02 | 引数なしでグローバル登録処理 | E-02 L24 | ○ |
| C-03 | 引数ありでプロジェクトリンク処理 | E-08 | ○ |
| C-04 | package.jsonからパッケージ名を取得 | E-03 | ○ |
| C-05 | nameフィールドの存在・妥当性チェック | E-03 L42-55 | ○ |
| C-06 | グローバルディレクトリへのシンボリックリンク作成 | E-05 L116-123 | ○ |
| C-07 | Windowsでジャンクションを使用 | E-09 | ○ |
| C-08 | スコープ付きパッケージのディレクトリ自動作成 | E-10 | ○ |
| C-09 | バイナリがあればBin.Linkerでリンク | E-06 | ○ |
| C-10 | 成功メッセージに使用方法を含む | E-07 | ○ |
| C-11 | package.jsonがなければ作成を試行 | E-02 L9-13 attemptToCreatePackageJSON | ○ |
| C-12 | 無効なパッケージ名でエラー | E-03 L47-55 | ○ |
| C-13 | グローバルディレクトリ作成失敗でエラー | E-04 L69-73 | ○ |
| C-14 | 既存リンクは削除後に再作成 | E-05 L79 deleteTree | ○ |
| C-15 | バイナリリンク失敗時のエラー処理 | E-06 L158-162 | ○ |
| C-16 | グローバルディレクトリのデフォルトパス | E-04 Options.openGlobalDir | ○ |
| C-17 | topLevelDirをリンク先として使用 | E-05 L95, L118 | ○ |
| C-18 | 画面一覧での定義との整合性 | E-11 | ○ |
| C-19 | 機能マッピングとの整合性 | E-12 | ○ |
| C-20 | バージョン情報を含むヘッダー出力 | E-02 L19-22 | ○ |
| C-21 | Global.exit(0)で正常終了 | E-07 L185 | ○ |
| C-22 | プロジェクトリンク時のpackage.json更新形式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-22: プロジェクトリンク時のpackage.json更新形式**
  - updatePackageJSONAndInstallWithManagerの内部実装詳細が未確認
  - "link:{package-name}"形式での追加は推測に基づく
  - 候補：install.zig / package_manager.zig内の該当関数

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 基本的な機能説明は正確
- **0: 低リスク** - Windows固有の処理（ジャンクション）も正しく記載

## 6) レビュアーチェックリスト（最小）

- [ ] Windows環境でのジャンクション作成が正しく動作するか確認
- [ ] スコープ付きパッケージ（@org/name）のリンクが正しく動作するか確認
- [ ] プロジェクトリンク時のpackage.json更新形式を実機で確認
- [ ] バイナリリンクのパス解決が正しいか確認
