---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-unlink 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/unlink_command.zig` L1-5 UnlinkCommand構造体とexec関数
- E-02: `src/cli/unlink_command.zig` L7-133 unlink関数
- E-03: `src/cli/unlink_command.zig` L32-56 package.json解析とパッケージ名取得
- E-04: `src/cli/unlink_command.zig` L58-69 lstatによるリンク存在確認
- E-05: `src/cli/unlink_command.zig` L72-87 グローバルディレクトリセットアップ
- E-06: `src/cli/unlink_command.zig` L90-118 Bin.Linkerによるバイナリリンク解除
- E-07: `src/cli/unlink_command.zig` L121-125 deleteTreeによるリンク削除
- E-08: `src/cli/unlink_command.zig` L127 成功メッセージ出力
- E-09: `src/cli/unlink_command.zig` L130-131 引数ありの未実装エラー
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` L14 unlinkコマンド定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L50 unlink関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がunlink関数に委譲 | E-01 | ○ |
| C-02 | 引数なしでグローバル登録解除処理 | E-02 L24 | ○ |
| C-03 | package.jsonからパッケージ名を取得 | E-03 | ○ |
| C-04 | nameフィールドの存在・妥当性チェック | E-03 L42-55 | ○ |
| C-05 | lstatでリンク存在確認 | E-04 | ○ |
| C-06 | シンボリックリンクでなければnothing to do | E-04 L60-63 | ○ |
| C-07 | リンクが存在しない場合もnothing to do | E-04 L65-68 | ○ |
| C-08 | バイナリがあればBin.Linker.unlinkで解除 | E-06 | ○ |
| C-09 | deleteTreeでパッケージリンク削除 | E-07 | ○ |
| C-10 | 成功メッセージを出力 | E-08 | ○ |
| C-11 | package.jsonがなければ作成を試行 | E-02 L9-13 attemptToCreatePackageJSON | ○ |
| C-12 | 無効なパッケージ名でエラー | E-03 L47-55 | ○ |
| C-13 | リンク削除失敗でエラー | E-07 L122-124 | ○ |
| C-14 | 引数ありは未実装 | E-09 | ○ |
| C-15 | バージョン情報を含むヘッダー出力 | E-02 L19-22 | ○ |
| C-16 | Global.exit(0)で正常終了 | E-08 L128 | ○ |
| C-17 | 画面一覧での定義との整合性 | E-10 | ○ |
| C-18 | 機能マッピングとの整合性 | E-11 | ○ |
| C-19 | ISLNK関数でシンボリックリンク判定 | E-04 L60 bun.S.ISLNK | ○ |
| C-20 | グローバルパスの構築にjoinAbsStringZ使用 | E-04 L58 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張にソースコード上の根拠あり
- **1: 中リスク** - 引数ありの機能が未実装であることをユーザードキュメントに明記する必要あり

## 6) レビュアーチェックリスト（最小）

- [ ] lstatによるリンク判定が正しく動作するか実機で確認
- [ ] バイナリリンク解除が正しく動作するか確認
- [ ] deleteTree後のディレクトリ状態を確認
- [ ] 引数ありの未実装エラーメッセージがユーザーフレンドリーか確認
