---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：14-publish 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **prepublishスクリプト対応**：コードではpublish/postpublishのみ確認、prepublish対応は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/publish_command.zig` L2-21 Context構造体定義
- E-02: `src/cli/publish_command.zig` L290-448 exec関数
- E-03: `src/cli/publish_command.zig` L34-234 fromTarballPath
- E-04: `src/cli/publish_command.zig` L240-286 fromWorkspace
- E-05: `src/cli/publish_command.zig` L531-730 publish関数
- E-06: `src/cli/publish_command.zig` L454-529 checkPackageVersionExists
- E-07: `src/cli/publish_command.zig` L1260-1360 constructPublishHeaders
- E-08: `src/cli/publish_command.zig` L1362-1425 constructPublishRequestBody
- E-09: `src/cli/publish_command.zig` L752-920 getOTP
- E-10: `src/cli/publish_command.zig` L922-1043 normalizedPackage
- E-11: `src/cli/publish_command.zig` L142-148 private判定
- E-12: `src/cli/publish_command.zig` L172-175 restricted/scoped判定
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` L15 publishコマンド定義
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L51-52 publish関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がエントリーポイント | E-02 | ○ |
| C-02 | Context.fromWorkspaceでワークスペースをパック | E-04 | ○ |
| C-03 | Context.fromTarballPathでtarballを読み込み | E-03 | ○ |
| C-04 | SHA1/SHA512ハッシュを計算 | E-03 L184-196 | ○ |
| C-05 | publish関数でレジストリに公開 | E-05 | ○ |
| C-06 | 認証情報なしでNeedAuthエラー | E-05 L537-539 | ○ |
| C-07 | tolerate-republishで既存バージョンチェック | E-06 | ○ |
| C-08 | dry-runでPUTをスキップ | E-05 L570 | ○ |
| C-09 | PUT {registry}/{package}で公開 | E-05 L590-608 | ○ |
| C-10 | 401でOTPフロー開始 | E-05 L622-668 | ○ |
| C-11 | www-authenticateでOTP/ipaddress判定 | E-05 L625-638 | ○ |
| C-12 | WebベースOTP対応（authUrl/doneUrl） | E-09 L769-908 | ○ |
| C-13 | クラシックOTP（ターミナル入力） | E-09 L911-919 | ○ |
| C-14 | private:trueでPrivatePackageエラー | E-11 | ○ |
| C-15 | スコープなしでrestrictedはエラー | E-12 | ○ |
| C-16 | publishConfigからtag/access取得 | E-03 L150-167 | ○ |
| C-17 | normalizedPackageでbin正規化 | E-10 L1045-1258 | ○ |
| C-18 | constructPublishRequestBodyでリクエスト構築 | E-08 | ○ |
| C-19 | constructPublishHeadersでヘッダー構築 | E-07 | ○ |
| C-20 | Bearer/Basic認証対応 | E-07 L1281-1289, L1323-1331 | ○ |
| C-21 | npm-otpヘッダー設定 | E-07 L1297-1299, L1339-1341 | ○ |
| C-22 | publish/postpublishスクリプト実行 | E-02 L400-447 | ○ |
| C-23 | Archive.Iteratorでtarball展開 | E-03 L54-129 | ○ |
| C-24 | パック情報の出力 | E-03 L93-119 | ○ |
| C-25 | printSummaryでサマリー表示 | E-03 L209-218 | ○ |
| C-26 | 画面一覧での定義との整合性 | E-13 | ○ |
| C-27 | 機能マッピングとの整合性 | E-14 | ○ |
| C-28 | prepublishスクリプト対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-28: prepublishスクリプト対応**
  - コード内ではpublish_scriptとpostpublish_scriptのみ処理されている
  - prepublishスクリプトの対応状況は要確認
  - 候補：pack_command.zig内のpack処理、またはPack.Context

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 基本的な公開機能は正確に記載
- **1: 中リスク** - OTPフロー（特にWebベース）は複雑なため実機テスト推奨
- **1: 中リスク** - prepublishスクリプト対応を確認し、必要に応じてドキュメント追記

## 6) レビュアーチェックリスト（最小）

- [ ] 認証フロー（Bearer/Basic）が正しく動作するか確認
- [ ] OTPフロー（Web/クラシック）が正しく動作するか確認
- [ ] private:trueのパッケージで適切にエラーになるか確認
- [ ] スコープ付きパッケージのaccess設定が正しく動作するか確認
- [ ] prepublishスクリプトの対応状況を確認
- [ ] --dry-runで実際の公開がスキップされるか確認
