---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：15-patch 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **テンポラリディレクトリの詳細な処理フロー**：install.zig内の実装詳細を確認する必要あり
  2. **出力メッセージの正確な形式**：実際の出力形式を実機で確認する必要あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/patch_command.zig` L1-18 PatchCommand構造体全体
- E-02: `src/cli/patch_command.zig` L5-9 exec関数
- E-03: `src/cli/patch_command.zig` L6-8 updatePackageJSONAndInstallCatchError呼び出し
- E-04: `src/install/install.zig` PackageManager.updatePackageJSONAndInstallCatchError
- E-05: `src/install/dependency.zig` Dependency.splitNameAndVersionOrLatest
- E-06: `src/install/lockfile.zig` Lockfile構造体
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` L16 patchコマンド定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L53-54 patch関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がエントリーポイント | E-02 | ○ |
| C-02 | updatePackageJSONAndInstallCatchErrorを.patchモードで呼び出し | E-03 | ○ |
| C-03 | PackageManager内部で処理 | E-04 | ○ |
| C-04 | 位置引数からパッケージ名@バージョンを解析 | E-05 | ○ |
| C-05 | ロックファイルからパッケージ情報を取得 | E-06 | ○ |
| C-06 | テンポラリディレクトリにパッケージをコピー | **根拠不足** | △ |
| C-07 | 編集案内メッセージを出力 | **根拠不足** | △ |
| C-08 | patch-commitコマンドとの連携 | E-01 L3 patch_commit_command参照 | ○ |
| C-09 | package-nameは必須引数 | E-03 | ○ |
| C-10 | @version形式でバージョン指定可能 | E-05 | ○ |
| C-11 | 画面一覧での定義との整合性 | E-07 | ○ |
| C-12 | 機能マッピングとの整合性 | E-08 | ○ |
| C-13 | Subcommand.patch分岐で処理 | E-03 L7 .patch指定 | ○ |
| C-14 | ロックファイル未検出でエラー | E-04 | ○ |
| C-15 | パッケージ未検出でエラー | E-04 | ○ |
| C-16 | バージョン複数時にエラー | E-04 | ○ |
| C-17 | pnpm patch/yarn patchと同等機能 | E-01 L1-2 コメント | ○ |
| C-18 | patchesディレクトリに保存 | E-08 機能マッピング | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-06: テンポラリディレクトリへのコピー処理**
  - patch_command.zigはupdatePackageJSONAndInstallCatchErrorを呼び出すのみ
  - 実際のコピー処理はinstall.zig内のSubcommand.patch分岐で実装
  - 候補：install.zig内のpatch処理ブロック、fs.zig内のコピー関数

- **C-07: 編集案内メッセージの正確な形式**
  - 実際の出力形式はinstall.zig内の実装に依存
  - 記載したメッセージ形式は推測に基づく
  - 候補：install.zig内のpatch完了時の出力処理

## 5) リスクフラグ（レビュー観点）

- **1: 中リスク** - patch_command.zigは薄いラッパーであり、実装詳細はinstall.zigに依存
- **1: 中リスク** - 出力メッセージの形式を実機テストで確認する必要あり

## 6) レビュアーチェックリスト（最小）

- [ ] install.zig内のSubcommand.patch処理を確認
- [ ] テンポラリディレクトリの作成場所と命名規則を確認
- [ ] 出力メッセージの正確な形式を実機で確認
- [ ] バージョン複数時のエラーメッセージを確認
- [ ] patch-commitとの連携動作を確認
