---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：17-pm 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **pnpmロックファイル移行対応**：detectAndLoadOtherLockfileの対応フォーマット詳細を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/package_manager_command.zig` L1-17 インポートとByName構造体
- E-02: `src/cli/package_manager_command.zig` L18-56 handleLoadLockfileErrors, printHash
- E-03: `src/cli/package_manager_command.zig` L58-76 getSubcommand
- E-04: `src/cli/package_manager_command.zig` L78-136 printHelp
- E-05: `src/cli/package_manager_command.zig` L138-457 exec関数
- E-06: `src/cli/package_manager_command.zig` L172-174 scan分岐
- E-07: `src/cli/package_manager_command.zig` L175-177 pack分岐
- E-08: `src/cli/package_manager_command.zig` L178-194 whoami分岐
- E-09: `src/cli/package_manager_command.zig` L195-198 view分岐
- E-10: `src/cli/package_manager_command.zig` L199-224 bin分岐
- E-11: `src/cli/package_manager_command.zig` L225-250 hash分岐
- E-12: `src/cli/package_manager_command.zig` L251-308 cache分岐
- E-13: `src/cli/package_manager_command.zig` L318-397 ls分岐
- E-14: `src/cli/package_manager_command.zig` L400-435 migrate分岐
- E-15: `src/cli/package_manager_command.zig` L436-441 version分岐
- E-16: `src/cli/package_manager_command.zig` L439-441 why分岐
- E-17: `src/cli/package_manager_command.zig` L442-444 pkg分岐
- E-18: `src/cli/package_manager_command.zig` L309-317 trust関連分岐
- E-19: `docs/code-to-docs/画面一覧/画面一覧.csv` L18 pmコマンド定義
- E-20: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L57-60 pm関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がエントリーポイント | E-05 | ○ |
| C-02 | getSubcommand()でサブコマンドを特定 | E-03 | ○ |
| C-03 | scan → ScanCommand.execWithManager | E-06 | ○ |
| C-04 | pack → PackCommand.execWithManager | E-07 | ○ |
| C-05 | whoami → Npm.whoami | E-08 | ○ |
| C-06 | view → PmViewCommand.view | E-09 | ○ |
| C-07 | bin → binパス出力 | E-10 | ○ |
| C-08 | hash → ハッシュ計算・出力 | E-11 | ○ |
| C-09 | cache → キャッシュパス出力・削除 | E-12 | ○ |
| C-10 | ls → 依存関係ツリー出力 | E-13 | ○ |
| C-11 | migrate → ロックファイル移行 | E-14 | ○ |
| C-12 | version → PmVersionCommand.exec | E-15 | ○ |
| C-13 | why → PmWhyCommand.exec | E-16 | ○ |
| C-14 | pkg → PmPkgCommand.exec | E-17 | ○ |
| C-15 | trust/untrusted → Trust関連コマンド | E-18 | ○ |
| C-16 | サブコマンドなしでヘルプ表示 | E-04 | ○ |
| C-17 | printHelp関数でヘルプ出力 | E-04 | ○ |
| C-18 | list→lsへの正規化 | E-05 L164-166 | ○ |
| C-19 | 直接whoami呼び出しの検出 | E-05 L143 | ○ |
| C-20 | PackageManager初期化エラー処理 | E-05 L146-158 | ○ |
| C-21 | グローバル操作対応 | E-05 L168-170 | ○ |
| C-22 | ByName構造体でソート | E-01 L5-16 | ○ |
| C-23 | handleLoadLockfileErrorsでエラー処理 | E-02 L19-33 | ○ |
| C-24 | bunxキャッシュ削除対応 | E-12 L270-301 | ○ |
| C-25 | グローバルbinのPATH警告 | E-10 L206-221 | ○ |
| C-26 | cache rmでキャッシュ削除 | E-12 L259-304 | ○ |
| C-27 | ls --allで全依存関係表示 | E-13 L360-361 | ○ |
| C-28 | migrateで--force対応 | E-14 L401-417 | ○ |
| C-29 | detectAndLoadOtherLockfileで他ロックファイル検出 | E-14 L418-424 | ○ |
| C-30 | hash-stringでハッシュ文字列を表示 | E-11 L245-250 | ○ |
| C-31 | hash-printで保存済みハッシュを表示 | E-11 L236-244 | ○ |
| C-32 | 不明なサブコマンドでエラー | E-05 L449-453 | ○ |
| C-33 | 画面一覧での定義との整合性 | E-19 | ○ |
| C-34 | 機能マッピングとの整合性 | E-20 | ○ |
| C-35 | npm/yarn/pnpmロックファイル移行対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-35: npm/yarn/pnpmロックファイル移行対応**
  - detectAndLoadOtherLockfileの対応フォーマット詳細
  - migration.zig内の実装を確認する必要あり
  - 候補：src/install/migration.zig

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 基本的なサブコマンドディスパッチは正確に記載
- **1: 中リスク** - migration.zigの対応フォーマット詳細を確認する必要あり

## 6) レビュアーチェックリスト（最小）

- [ ] 各サブコマンドへの分岐が正しく動作するか確認
- [ ] ヘルプ表示が最新のサブコマンド一覧を反映しているか確認
- [ ] キャッシュ削除（cache rm）が正しく動作するか確認
- [ ] ロックファイル移行（migrate）の対応フォーマットを確認
- [ ] グローバルbinのPATH警告が正しく表示されるか確認
