---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-info 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/pm_view_command.zig` L1-393 view関数全体
- E-02: `src/cli/pm_view_command.zig` L2-32 パッケージ名・バージョン解析
- E-03: `src/cli/pm_view_command.zig` L34-43 レジストリURL構築
- E-04: `src/cli/pm_view_command.zig` L45-74 HTTPヘッダー構築
- E-05: `src/cli/pm_view_command.zig` L77-95 HTTPリクエスト送信
- E-06: `src/cli/pm_view_command.zig` L97-114 JSONパース・マニフェスト解析
- E-07: `src/cli/pm_view_command.zig` L121-186 バージョンマッチング
- E-08: `src/cli/pm_view_command.zig` L129-140 findByDistTag/findBestVersion
- E-09: `src/cli/pm_view_command.zig` L156-185 バージョンなし時のエラー処理
- E-10: `src/cli/pm_view_command.zig` L204-254 プロパティパス処理
- E-11: `src/cli/pm_view_command.zig` L256-277 JSON出力処理
- E-12: `src/cli/pm_view_command.zig` L279-392 通常出力処理
- E-13: `src/cli/pm_view_command.zig` L288-294 依存関係数・バージョン数表示
- E-14: `src/cli/pm_view_command.zig` L296-302 説明・ホームページ表示
- E-15: `src/cli/pm_view_command.zig` L304-317 キーワード表示
- E-16: `src/cli/pm_view_command.zig` L319-332 依存関係一覧表示
- E-17: `src/cli/pm_view_command.zig` L334-348 dist情報表示
- E-18: `src/cli/pm_view_command.zig` L350-368 dist-tags表示
- E-19: `src/cli/pm_view_command.zig` L370-382 メンテナー表示
- E-20: `src/cli/pm_view_command.zig` L384-392 公開日時表示
- E-21: `docs/code-to-docs/画面一覧/画面一覧.csv` L19 infoコマンド定義
- E-22: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L61-62 info関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | view関数がメインエントリーポイント | E-01 | ○ |
| C-02 | splitNameAndVersionOrLatestでパッケージ名とバージョンを分離 | E-02 | ○ |
| C-03 | `.`または空の場合は現在のpackage.jsonの名前を使用 | E-02 L3-28 | ○ |
| C-04 | スコープに応じたレジストリURLを構築 | E-03 | ○ |
| C-05 | 認証情報（token/auth）をヘッダーに設定 | E-04 L47-60 | ○ |
| C-06 | AsyncHTTPでレジストリにGETリクエスト | E-05 | ○ |
| C-07 | レスポンスをJSONとしてパース | E-06 L86-91 | ○ |
| C-08 | PackageManifest.parseでマニフェスト解析 | E-06 L98-114 | ○ |
| C-09 | findByDistTagでdist-tagを試行 | E-08 L129 | ○ |
| C-10 | findBestVersionでsemverマッチング | E-08 L137 | ○ |
| C-11 | バージョンなし時に最近のバージョン一覧を表示 | E-09 L171-183 | ○ |
| C-12 | property-pathで特定プロパティのみ出力 | E-10 | ○ |
| C-13 | --jsonでJSON形式出力 | E-11 | ○ |
| C-14 | 通常出力でパッケージ情報をフォーマット | E-12 | ○ |
| C-15 | 依存関係数を表示 | E-13 L282-285 | ○ |
| C-16 | バージョン数を表示 | E-13 L119 versions_len | ○ |
| C-17 | 説明を表示 | E-14 L297-299 | ○ |
| C-18 | ホームページを表示 | E-14 L300-302 | ○ |
| C-19 | キーワードを表示 | E-15 | ○ |
| C-20 | 依存関係一覧を表示 | E-16 | ○ |
| C-21 | dist情報（tarball/shasum/integrity/unpackedSize）を表示 | E-17 | ○ |
| C-22 | dist-tagsを表示 | E-18 | ○ |
| C-23 | メンテナーを表示 | E-19 | ○ |
| C-24 | 公開日時を表示 | E-20 | ○ |
| C-25 | HTTPリクエスト失敗時のエラー処理 | E-05 L77-80 | ○ |
| C-26 | 400以上のステータスでエラー処理 | E-05 L82-84 | ○ |
| C-27 | versionsプロパティを配列に正規化 | E-07 L189-202 | ○ |
| C-28 | semver範囲指定対応 | E-08 L133-137 Query.parse | ○ |
| C-29 | 画面一覧での定義との整合性 | E-21 | ○ |
| C-30 | 機能マッピングとの整合性 | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張にソースコード上の根拠あり
- **0: 低リスク** - 出力フォーマットもコードと一致

## 6) レビュアーチェックリスト（最小）

- [ ] 認証情報（token/auth）が正しく設定されるか確認
- [ ] semver範囲指定が正しく動作するか確認
- [ ] dist-tag（latest/beta等）での検索が正しく動作するか確認
- [ ] property-pathでの値抽出が正しく動作するか確認
- [ ] --json出力が正しいJSON形式か確認
- [ ] バージョンなし時のエラー表示と候補一覧が適切か確認
