---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-why 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/why_command.zig` L1-6 定数定義（プレフィックス）
- E-02: `src/cli/why_command.zig` L8-11 VersionInfo構造体
- E-03: `src/cli/why_command.zig` L13-20 DependentInfo構造体
- E-04: `src/cli/why_command.zig` L22-28 DependencyType enum
- E-05: `src/cli/why_command.zig` L30-70 ソート・優先度関数
- E-06: `src/cli/why_command.zig` L72-188 GlobPattern構造体
- E-07: `src/cli/why_command.zig` L190-209 printUsage関数
- E-08: `src/cli/why_command.zig` L213-231 exec関数
- E-09: `src/cli/why_command.zig` L233-239 execFromPm関数
- E-10: `src/cli/why_command.zig` L242-375 execWithManager関数
- E-11: `src/cli/why_command.zig` L377-405 printPackageWithType関数
- E-12: `src/cli/why_command.zig` L407-427 TreeContext構造体
- E-13: `src/cli/why_command.zig` L429-477 printDependencyTree関数
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv` L20 whyコマンド定義
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L63-64 why関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がエントリーポイント | E-08 | ○ |
| C-02 | VersionInfo構造体でバージョン情報を管理 | E-02 | ○ |
| C-03 | DependentInfo構造体で依存元情報を管理 | E-03 | ○ |
| C-04 | DependencyType enumで依存タイプを分類 | E-04 | ○ |
| C-05 | GlobPattern構造体でパターンマッチング | E-06 | ○ |
| C-06 | prefix/suffix/contains/middleパターン対応 | E-06 L73-80 | ○ |
| C-07 | バージョンパターン対応（semver query） | E-06 L87-103, L161-181 | ○ |
| C-08 | execFromPmでpm why経由のエントリー | E-09 | ○ |
| C-09 | execWithManagerでメイン処理 | E-10 | ○ |
| C-10 | ロックファイルを読み込み | E-10 L243-244 | ○ |
| C-11 | --topオプションでmax_depth=1 | E-10 L246-247 | ○ |
| C-12 | --depthオプションで深度制限 | E-10 L248-250 | ○ |
| C-13 | all_dependentsハッシュマップで逆引き | E-10 L272 | ○ |
| C-14 | GlobPattern.matchesNameでパッケージ名マッチ | E-06 L150-159 | ○ |
| C-15 | GlobPattern.matchesVersionでバージョンマッチ | E-06 L161-181 | ○ |
| C-16 | マッチするパッケージなしでエラー | E-10 L337-340 | ○ |
| C-17 | compareDependentsでソート | E-05 L52-70 | ○ |
| C-18 | getSpecifierSpecificityで優先度計算 | E-05 L30-40 | ○ |
| C-19 | getDependencyTypePriorityで依存タイプ優先度 | E-05 L42-50 | ○ |
| C-20 | printPackageWithTypeで依存タイプ付き出力 | E-11 | ○ |
| C-21 | devはmagentaでカラー出力 | E-11 L381 | ○ |
| C-22 | peerはyellowでカラー出力 | E-11 L382 | ○ |
| C-23 | optionalはcyanでカラー出力 | E-11 L383-384 | ○ |
| C-24 | ワークスペースは@workspaceと表示 | E-11 L388-392 | ○ |
| C-25 | printDependencyTreeで再帰出力 | E-13 | ○ |
| C-26 | path_trackerで循環依存検出 | E-13 L437-439 | ○ |
| C-27 | max_depthで深度制限 | E-13 L456-459 | ○ |
| C-28 | TreeContext構造体でツリー出力状態管理 | E-12 | ○ |
| C-29 | printUsageでヘルプ出力 | E-07 | ○ |
| C-30 | PREFIX_LAST/MIDDLE/CONTINUE/SPACEでツリー描画 | E-01 L2-5 | ○ |
| C-31 | 画面一覧での定義との整合性 | E-14 | ○ |
| C-32 | 機能マッピングとの整合性 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての主張にソースコード上の根拠あり
- **0: 低リスク** - ツリー出力のロジックも正確に記載

## 6) レビュアーチェックリスト（最小）

- [ ] globパターン（@scope/*等）が正しく動作するか確認
- [ ] semverパターン（react@^17等）が正しく動作するか確認
- [ ] --topオプションでトップレベルのみ表示されるか確認
- [ ] --depthオプションで深度制限されるか確認
- [ ] 循環依存が正しく検出・表示されるか確認
- [ ] 依存タイプ（dev/peer/optional）のカラー表示を確認
- [ ] ワークスペースパッケージの表示形式を確認
