---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 40
  claims_with_evidence: 39
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート：20-build 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：39 / 40、根拠なし：1
- 優先レビュー（高）
  1. **bakeモードの詳細**：bake.production.buildCommandの実装詳細を確認する必要あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/build_command.zig` L1-695 BuildCommand全体
- E-02: `src/cli/build_command.zig` L2-598 exec関数
- E-03: `src/cli/build_command.zig` L3 Global.configureAllocator
- E-04: `src/cli/build_command.zig` L6-9 target設定（compile/bytecode）
- E-05: `src/cli/build_command.zig` L11-13 bakeモード分岐
- E-06: `src/cli/build_command.zig` L44-52 Transpiler.init
- E-07: `src/cli/build_command.zig` L52-97 オプション設定
- E-08: `src/cli/build_command.zig` L56-60 sourcemap制約チェック
- E-09: `src/cli/build_command.zig` L100-104 compile+outdir制約
- E-10: `src/cli/build_command.zig` L135-139 compile+no-bundle制約
- E-11: `src/cli/build_command.zig` L142-151 HTML+no-bundle制約
- E-12: `src/cli/build_command.zig` L153-163 複数エントリー+outdir制約
- E-13: `src/cli/build_command.zig` L129-133 出力名がbun禁止
- E-14: `src/cli/build_command.zig` L166-191 ルートディレクトリ決定
- E-15: `src/cli/build_command.zig` L199-201 --production処理
- E-16: `src/cli/build_command.zig` L277-300 transform_only分岐
- E-17: `src/cli/build_command.zig` L312-330 BundleV2.generateFromCLI
- E-18: `src/cli/build_command.zig` L332-355 metafile出力
- E-19: `src/cli/build_command.zig` L433-514 compile実行（toExecutable）
- E-20: `src/cli/build_command.zig` L516-530 通常出力サマリー
- E-21: `src/cli/build_command.zig` L532-591 writeToDisk
- E-22: `src/cli/build_command.zig` L609-677 printSummary
- E-23: `src/cli/build_command.zig` L601-607 exitOrWatch
- E-24: `docs/code-to-docs/画面一覧/画面一覧.csv` L21 buildコマンド定義
- E-25: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L65-68 build関連機能

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | exec関数がエントリーポイント | E-02 | ○ |
| C-02 | 長時間実行用アロケータ設定 | E-03 | ○ |
| C-03 | compile/bytecodeでtarget=bun | E-04 | ○ |
| C-04 | bakeモードで別処理へ分岐 | E-05 | ○ |
| C-05 | Transpiler.initで初期化 | E-06 | ○ |
| C-06 | sourcemap+outdir制約チェック | E-08 | ○ |
| C-07 | compile+outdir禁止 | E-09 | ○ |
| C-08 | compile+no-bundle禁止 | E-10 | ○ |
| C-09 | HTML+no-bundle禁止 | E-11 | ○ |
| C-10 | 複数エントリー+outdir必須 | E-12 | ○ |
| C-11 | 出力名がbun禁止 | E-13 | ○ |
| C-12 | ルートディレクトリ自動決定 | E-14 | ○ |
| C-13 | --productionでNODE_ENV=production | E-15 | ○ |
| C-14 | transform_only分岐 | E-16 | ○ |
| C-15 | BundleV2.generateFromCLIでバンドル | E-17 | ○ |
| C-16 | metafile出力対応 | E-18 | ○ |
| C-17 | compile実行（toExecutable） | E-19 | ○ |
| C-18 | 通常出力サマリー表示 | E-20 | ○ |
| C-19 | writeToDiskでファイル書き込み | E-21 | ○ |
| C-20 | printSummaryでサマリー出力 | E-22 | ○ |
| C-21 | exitOrWatchで終了/監視 | E-23 | ○ |
| C-22 | minify設定対応 | E-07 L75-79 | ○ |
| C-23 | splitting設定対応 | E-07 L74 | ○ |
| C-24 | public_path設定対応 | E-07 L67 | ○ |
| C-25 | entry_naming設定対応 | E-07 L68 | ○ |
| C-26 | chunk_naming設定対応 | E-07 L69 | ○ |
| C-27 | asset_naming設定対応 | E-07 L70 | ○ |
| C-28 | server_components設定対応 | E-07 L71 | ○ |
| C-29 | react_fast_refresh設定対応 | E-07 L72 | ○ |
| C-30 | code_splitting設定対応 | E-07 L74 | ○ |
| C-31 | banner/footer設定対応 | E-07 L82-83 | ○ |
| C-32 | drop設定対応 | E-07 L84 | ○ |
| C-33 | metafile設定対応 | E-07 L88 | ○ |
| C-34 | output_format設定対応 | E-07 L91 | ○ |
| C-35 | bytecode設定対応 | E-07 L97 | ○ |
| C-36 | env.behavior設定対応 | E-07 L196-197 | ○ |
| C-37 | クロスコンパイル対応 | E-19 L445, L507-510 | ○ |
| C-38 | 画面一覧での定義との整合性 | E-24 | ○ |
| C-39 | 機能マッピングとの整合性 | E-25 | ○ |
| C-40 | bakeモードの詳細処理 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-40: bakeモードの詳細処理**
  - bun.bake.production.buildCommandの実装詳細
  - サーバーサイドレンダリング関連の機能
  - 候補：src/bake/production.zig

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 基本的なビルド機能は正確に記載
- **1: 中リスク** - bakeモードの詳細を追加調査が必要
- **0: 低リスク** - --compile処理は詳細に記載

## 6) レビュアーチェックリスト（最小）

- [ ] 各種minifyオプションが正しく動作するか確認
- [ ] code splittingが正しく動作するか確認
- [ ] sourcemap生成が各モード（inline/external/linked）で動作するか確認
- [ ] --compileでクロスコンパイルが動作するか確認
- [ ] --metafileの出力形式を確認
- [ ] --watchでファイル変更監視が動作するか確認
- [ ] bakeモードの処理内容を追加調査
