---
generated_at: 2026-01-27 17:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-init.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **bunfig.toml設定機能との関連**：画面機能マッピングには記載あるが、実装での直接的な生成は確認できず

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/init_command.zig` - initコマンドのメイン実装ファイル
- E-02: `src/cli.zig` - CLIコマンドルーター、ヘルプテキスト定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドはbun initで実行 | E-02 (577行目: `RootCommandMatcher.case("init") => .InitCommand`) | ○ |
| C-02 | --helpオプションでヘルプ表示 | E-01 (361-363行目: `strings.eqlComptime(arg, "--help")`) | ○ |
| C-03 | --yesオプションで自動承認 | E-01 (367-369行目: `strings.eqlComptime(arg, "-y") or strings.eqlComptime(arg, "--yes")`) | ○ |
| C-04 | --minimalオプションで最小構成 | E-01 (364-366行目: `strings.eqlComptime(arg, "-m") or strings.eqlComptime(arg, "--minimal")`) | ○ |
| C-05 | --reactオプションでReactテンプレート | E-01 (373-376行目: `strings.eqlComptime(arg, "--react") or strings.eqlComptime(arg, "-r")`) | ○ |
| C-06 | --react=tailwindでTailwind付きReact | E-01 (377-380行目: `strings.eqlComptime(arg, "--react=tailwind")`) | ○ |
| C-07 | --react=shadcnでshadcn付きReact | E-01 (381-384行目: `strings.eqlComptime(arg, "--react=shadcn")`) | ○ |
| C-08 | テンプレート選択はBlank/React/Libraryの3種類 | E-01 (546-560行目: enum定義 blank, react, library) | ○ |
| C-09 | 上下矢印/j/kキーで選択移動 | E-01 (136-149行目, 158-171行目: キー入力処理) | ○ |
| C-10 | Enterキーで選択確定 | E-01 (126-128行目: `'\n', '\r' => return selected`) | ○ |
| C-11 | Ctrl+C/Ctrl+Dでキャンセル | E-01 (129行目: `3, 4 => return error.EndOfStream`) | ○ |
| C-12 | package.jsonを生成/更新 | E-01 (755-783行目: write_package_json処理) | ○ |
| C-13 | tsconfig.jsonを生成 | E-01 (816-825行目: steps.write_tsconfig処理) | ○ |
| C-14 | .gitignoreを生成 | E-01 (786-790行目: Assets.create(".gitignore")) | ○ |
| C-15 | README.mdを生成 | E-01 (828-836行目: Assets.create("README.md")) | ○ |
| C-16 | エントリーポイントファイルを生成 | E-01 (811-814行目: Assets.createNew(fields.entry_point)) | ○ |
| C-17 | CLAUDE.md/Cursorルールファイルを生成 | E-01 (1017-1061行目: createAgentRule関数) | ○ |
| C-18 | bun installを自動実行 | E-01 (850-863行目: process.spawnAndWait for "install") | ○ |
| C-19 | 既存package.jsonがある場合は設定メッセージ表示 | E-01 (610行目: `Output.note("package.json already exists...")`) | ○ |
| C-20 | --react使用時は--yesが自動有効 | E-01 (376行目: `auto_yes = true`) | ○ |
| C-21 | Claude Code/Cursorインストール検出 | E-01 (1000-1015行目, 1064-1096行目: isClaudeCodeInstalled, isCursorInstalled) | ○ |
| C-22 | Reactテンプレート選択後に詳細選択 | E-01 (584-602行目: react_selected radio) | ○ |
| C-23 | キャンセル時は「x Cancelled」表示 | E-01 (213-214行目: `Output.prettyln("\n<r><red>x<r> Cancelled")`) | ○ |
| C-24 | ディレクトリ作成失敗時エラー終了 | E-01 (398-401行目: `Output.prettyErrorln("Failed to create directory")`) | ○ |
| C-25 | 既存tsconfig/jsconfigがある場合はスキップ | E-01 (640-650行目: existsZ("tsconfig.json"), existsZ("jsconfig.json")) | ○ |
| C-26 | Libraryテンプレートではprivate: false | E-01 (581行目: `fields.private = false`) | ○ |
| C-27 | 機能No.17 bun initが主機能 | E-04 (73行目: 画面21, 機能17, bun init, 主機能) | ○ |
| C-28 | 機能No.8 bunfig.toml設定が補助機能 | E-04 (74行目) | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: 画面機能マッピングにはbunfig.toml設定が補助機能として記載されているが、init_command.zigの実装ではbunfig.tomlの直接生成は確認できない（Reactテンプレート時のみbunfig.tomlが含まれる）
  - 候補：Reactテンプレートのembedファイル / 別のコードパス / マッピング定義の見直し

## 5) リスクフラグ（レビュー観点）
- **0**: 低リスク - 主要機能の実装は明確に確認可能
- **1**: 中リスク - bunfig.toml関連の機能マッピングと実装の整合性要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-28: bunfig.toml設定の補助機能としての関連性を確認（Reactテンプレート以外でも関連があるか）
- [ ] コマンドライン引数の網羅性を確認（--helpのコンテキストと実際の引数が一致しているか）
- [ ] 生成ファイルの一覧が最新の実装と一致しているか確認
