---
generated_at: 2026-01-27 17:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-create.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Example.Tag列挙型の詳細定義箇所**：コード内で参照されているがファイル読み込み制限のため完全な定義は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/create_command.zig` - createコマンドのメイン実装ファイル
- E-02: `src/cli.zig` - CLIコマンドルーター、ヘルプテキスト定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドはbun createまたはbun cで実行 | E-02 (600行目: `RootCommandMatcher.case("c"), RootCommandMatcher.case("create")`) | ○ |
| C-02 | --helpオプションでヘルプ表示 | E-01 (153行目: `clap.parseParam("-h, --help")`) | ○ |
| C-03 | --forceオプションで上書き | E-01 (154行目, 186行目: `--force`, `opts.overwrite = args.flag("--force")`) | ○ |
| C-04 | --no-installオプションでインストールスキップ | E-01 (155行目, 184行目: `--no-install`, `opts.skip_install`) | ○ |
| C-05 | --no-gitオプションでGit作成スキップ | E-01 (156行目, 185行目: `--no-git`, `opts.skip_git`) | ○ |
| C-06 | --verboseオプションで詳細ログ | E-01 (157行目, 182行目: `--verbose`, `opts.verbose`) | ○ |
| C-07 | --no-package-jsonオプションでpackage.json変換無効 | E-01 (158行目, 180行目: `--no-package-json`, `opts.skip_package_json`) | ○ |
| C-08 | --openオプションで完了後ブラウザ起動 | E-01 (159行目, 183行目: `--open`, `opts.open`) | ○ |
| C-09 | GitHubリポジトリからtarballをダウンロード | E-01 (284行目: `Example.fetchFromGitHub`) | ○ |
| C-10 | gzip解凍にZlib使用 | E-01 (329行目: `Zlib.ZlibReaderArrayList`) | ○ |
| C-11 | tar展開にArchiver使用 | E-01 (389行目: `Archiver.extractToDisk`) | ○ |
| C-12 | ローカルフォルダのコピーにWalker使用 | E-01 (453行目: `Walker.walk`) | ○ |
| C-13 | node_modules, .gitをスキップ | E-01 (12-15行目: `skip_dirs`) | ○ |
| C-14 | package-lock.json等をスキップ | E-01 (16-20行目: `skip_files`) | ○ |
| C-15 | README.md等は競合対象外 | E-01 (22-27行目: `never_conflict`) | ○ |
| C-16 | GitHubレート制限時はGITHUB_ACCESS_TOKEN案内 | E-01 (286-291行目: エラーハンドリング) | ○ |
| C-17 | package.jsonのnameフィールドを出力先名に更新 | E-01 (678-682行目: `name_expr.expr.data.e_string.data = basename`) | ○ |
| C-18 | gitignoreを.gitignoreにリネーム | E-01 (632-635行目: `linkat/copyFile "gitignore" -> ".gitignore"`) | ○ |
| C-19 | .npmignoreを削除 | E-01 (642-646行目: `unlinkat ".npmignore"`) | ○ |
| C-20 | reactテンプレートは非推奨 | E-02 (1650-1666行目: 非推奨メッセージ) | ○ |
| C-21 | nextテンプレートはnext-appにリダイレクト | E-02 (1672-1680行目: 非推奨メッセージ) | ○ |
| C-22 | 機能No.18 bun createが主機能 | E-04 (75行目) | ○ |
| C-23 | 機能No.41 npmレジストリが補助機能 | E-04 (76行目) | ○ |
| C-24 | 機能No.39 依存関係解決が補助機能 | E-04 (77行目) | ○ |
| C-25 | Example.Tag列挙型の詳細 | E-01 (ファイル内に存在するが読み込み制限で詳細未確認) | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: Example.Tag列挙型の詳細定義（github_repository, official, local_folder, jslike_file）は参照されているが、create_command.zigのファイルサイズ制限により完全な定義箇所の直接確認ができていない
  - 候補：create_command.zigの後半部分 / 別のインポートファイル

## 5) リスクフラグ（レビュー観点）
- **0**: 低リスク - 主要機能の実装は明確に確認可能
- **1**: 中リスク - Example.Tag列挙型の完全な定義確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] C-25: Example.Tag列挙型の完全な定義を確認し、記載内容が正確か検証
- [ ] NPMテンプレートへの委譲ロジック（bunxへの委譲）の詳細確認
- [ ] JSXファイル直接指定時の処理フロー（runOnEntryPoint関数）の確認
