---
generated_at: 2026-01-27 17:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-upgrade.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/upgrade_command.zig` - upgradeコマンドのメイン実装ファイル
- E-02: `src/cli.zig` - CLIコマンドルーター、ヘルプテキスト定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドはbun upgradeで実行 | E-02 (580行目: `RootCommandMatcher.case("upgrade")`) | ○ |
| C-02 | --canaryオプションで開発版インストール | E-01 (369-370行目: `strings.containsAny(bun.argv, "--canary")`) | ○ |
| C-03 | --stableオプションでcanaryからダウングレード | E-01 (366-367行目: `strings.containsAny(bun.argv, "--stable")`) | ○ |
| C-04 | --profileオプションでプロファイルビルド | E-01 (373行目: `strings.containsAny(bun.argv, "--profile")`) | ○ |
| C-05 | GitHub APIからリリース情報取得 | E-01 (121-129行目: `api.github.com/repos/.../releases/latest`) | ○ |
| C-06 | GITHUB_TOKENでレート制限緩和 | E-01 (131-148行目: `GITHUB_TOKEN` or `GITHUB_ACCESS_TOKEN`) | ○ |
| C-07 | GITHUB_API_DOMAINでカスタムドメイン | E-01 (114-119行目: `env_loader.map.get("GITHUB_API_DOMAIN")`) | ○ |
| C-08 | Version構造体でバージョン情報管理 | E-01 (9-78行目: `pub const Version = struct`) | ○ |
| C-09 | platform_label/arch_labelでプラットフォーム識別 | E-01 (38-46行目: `platform_label`, `arch_label`) | ○ |
| C-10 | 最新版の場合は「Congrats」メッセージ | E-01 (385-393行目: `Congrats! You're already on the latest`) | ○ |
| C-11 | canary最新版確認はハッシュ比較 | E-01 (723-749行目: `target_hash == source_hash`) | ○ |
| C-12 | POSIXでunzipコマンド使用 | E-01 (527-560行目: `unzip -q -o`) | ○ |
| C-13 | WindowsでPowerShell Expand-Archive使用 | E-01 (561-614行目: `Expand-Archive`) | ○ |
| C-14 | バイナリ検証で--version実行 | E-01 (617-620行目: `exe, "--version"`) | ○ |
| C-15 | Windowsで旧バイナリを.outdatedにリネーム | E-01 (761-770行目: `outdated_filename`) | ○ |
| C-16 | moveFileZでバイナリ置換 | E-01 (773行目: `bun.sys.moveFileZ`) | ○ |
| C-17 | シェル補完自動更新 | E-01 (817-833行目: `completions` subprocess) | ○ |
| C-18 | IS_BUN_AUTO_UPDATE環境変数 | E-01 (824行目: `IS_BUN_AUTO_UPDATE`) | ○ |
| C-19 | パッケージ名指定時のエラーメッセージ | E-01 (322-333行目: `This command updates Bun itself`) | ○ |
| C-20 | canary未対応時のエラーメッセージ | E-01 (450-461行目: `Canary builds are not available`) | ○ |
| C-21 | NixOS等でのエラーメッセージ | E-01 (639-647行目: `unsupported on systems without ld`) | ○ |
| C-22 | 手動インストールコマンド案内 | E-01 (312-316行目: `manual_upgrade_command`) | ○ |
| C-23 | BUN_DRY_RUNでドライラン | E-01 (755行目: `BUN_DRY_RUN`) | ○ |
| C-24 | 機能No.16 bun upgradeが主機能 | E-04 (78行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できました）

## 5) リスクフラグ（レビュー観点）
- **0**: 低リスク - 全ての主要機能の実装が明確に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] プラットフォーム別の動作差異（POSIX vs Windows）が正確に記載されているか確認
- [ ] エラーハンドリングのフローが実装と一致しているか確認
- [ ] canaryとstableの切り替えロジックが正確か確認
