---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-help.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認できました

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli.zig` - HelpCommand実装、CLIコマンドルーター
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドはbun helpで実行 | E-01 (619行目: `RootCommandMatcher.case("help") => .HelpCommand`) | ○ |
| C-02 | bun（引数なし）でもヘルプ表示 | E-01 (545行目: `return .HelpCommand` when no argv) | ○ |
| C-03 | HelpCommand構造体で実装 | E-01 (104行目: `pub const HelpCommand = struct`) | ○ |
| C-04 | Reason列挙型でexplicit/invalid_command | E-01 (110-113行目: `pub const Reason = enum`) | ○ |
| C-05 | packages_to_*_filler配列でサンプル定義 | E-01 (116-159行目: 4つのfiller配列) | ○ |
| C-06 | cli_helptext_fmtでヘルプテキスト定義 | E-01 (162-196行目: `pub const cli_helptext_fmt`) | ○ |
| C-07 | cli_helptext_footerでフッター定義 | E-01 (197-202行目: `const cli_helptext_footer`) | ○ |
| C-08 | printWithReason()で表示処理 | E-01 (204-263行目: `pub fn printWithReason`) | ○ |
| C-09 | ランダムにサンプルパッケージ選択 | E-01 (205-211行目: `std.Random.DefaultPrng`, `rand.uintAtMost`) | ○ |
| C-10 | 明示的ヘルプ時はバージョン情報表示 | E-01 (240-246行目: `Output.pretty(...Global.package_json_version...)`) | ○ |
| C-11 | 無効コマンド時は「Uh-oh」メッセージ | E-01 (256-259行目: `Uh-oh not sure what to do with that command`) | ○ |
| C-12 | 明示的ヘルプは終了コード0 | E-01 (272行目: `Global.exit(0)`) | ○ |
| C-13 | 無効コマンドは終了コード1 | E-01 (269-270行目: `if (reason == .invalid_command) { Global.exit(1) }`) | ○ |
| C-14 | フラグ一覧表示 | E-01 (250-251行目: `clap.simpleHelpBunTopLevel(comptime &flags)`) | ○ |
| C-15 | ドキュメントURLの表示 | E-01 (199行目: `https://bun.com/docs`) | ○ |
| C-16 | DiscordリンクのURL表示 | E-01 (200行目: `https://bun.com/discord`) | ○ |
| C-17 | Usageフォーマット | E-01 (163行目: `Usage: bun <command> [...flags] [...args]`) | ○ |
| C-18 | コマンドカテゴリ別表示 | E-01 (165-195行目: Commands分類) | ○ |
| C-19 | AIエージェント検出時の特別処理 | E-01 (225-237行目: `bun.Output.isAIAgent()`) | ○ |
| C-20 | UnknownCommandからHelpCommand呼び出し | E-01 (100行目: `HelpCommand.execWithReason(allocator, .invalid_command)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠が確認できました）

## 5) リスクフラグ（レビュー観点）
- **0**: 低リスク - 全ての主要機能の実装が明確に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ヘルプテキストの内容が最新のコマンド一覧と一致しているか確認
- [ ] カラー出力のエスケープシーケンスが正しく記載されているか確認
- [ ] フッターのURL（ドキュメント、Discord）が有効か確認
