---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 23
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：6-install.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：23 / 26、根拠なし：3
- 優先レビュー（高）
  1. **ワークスペース処理の詳細**：根拠不足
  2. **パッケージキャッシュ管理の詳細**：根拠不足
  3. **ネットワークエラーリトライの詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/install_command.zig` - InstallCommand構造体とexec関数
- E-02: `src/cli/install_command.zig:2-13` - exec関数とエラーハンドリング
- E-03: `src/cli/install_command.zig:16-56` - install関数
- E-04: `src/cli/install_command.zig:58-85` - installWithCLI関数
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-07: `src/cli/install_command.zig:63` - PackageManager.init呼び出し
- E-08: `src/cli/install_command.zig:66-73` - addサブコマンド処理
- E-09: `src/cli/install_command.zig:75-84` - installサブコマンド処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | installコマンドはpackage.jsonに基づき依存関係をインストールする | E-01, E-06 | ○ |
| C-02 | exec関数でinstallを呼び出しエラーハンドリングする | E-02 | ○ |
| C-03 | CommandLineArguments.parseでCLI引数を解析する | E-03 (行17) | ○ |
| C-04 | --analyzeオプション時にバンドラー依存関係をスキャンする | E-03 (行24-53) | ○ |
| C-05 | PackageManager.initでパッケージマネージャーを初期化する | E-07 | ○ |
| C-06 | addサブコマンド時はupdatePackageJSONAndInstallWithManagerを呼び出す | E-08 | ○ |
| C-07 | installサブコマンド時はinstallWithManagerを呼び出す | E-09 | ○ |
| C-08 | 関連機能No.15,39-44が正しくマッピングされている | E-06 | ○ |
| C-09 | bun.lockbとpackage-lock.json/yarn.lockの両方をサポートする | E-06 | ○ |
| C-10 | --production/-pでdevDependenciesを除外できる | E-03 | ○ |
| C-11 | --frozen-lockfileでlockfile更新なしインストールが可能 | E-06 | ○ |
| C-12 | package.json不在時はエラーを表示しbun initを提案する | E-02 | ○ |
| C-13 | InstallFailed/InvalidPackageJSONエラーをハンドリングする | E-02 (行3-10) | ○ |
| C-14 | バージョン表示（bun install v{version}）を行う | E-04 (行69, 76) | ○ |
| C-15 | サマリー表示（パッケージ数と所要時間）を行う | E-09 | ○ |
| C-16 | lockfile.loadFromCwdでlockfileを読み込む | E-09 (行80) | ○ |
| C-17 | installWithManagerでインストール処理を実行する | E-09 | ○ |
| C-18 | any_failed_to_install時にexit(1)する | E-09 (行82-84) | ○ |
| C-19 | positionals.len > 1でaddサブコマンドに切り替わる | E-04 (行59) | ○ |
| C-20 | shouldPrintCommandName時にバージョンを表示する | E-04 (行68-71, 75-78) | ○ |
| C-21 | original_cwdを保持する | E-04 (行63) | ○ |
| C-22 | manager.subcommandを.addに切り替える | E-08 (行67) | ○ |
| C-23 | flush()で出力をフラッシュする | E-04 (行70, 77) | ○ |
| C-24 | ワークスペース処理の詳細 | **根拠不足** | △ |
| C-25 | パッケージキャッシュ管理の詳細 | **根拠不足** | △ |
| C-26 | ネットワークエラーリトライの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: ワークスペース処理の詳細
  - install_command.zigからは直接確認できず、PackageManager側の実装
  - 候補：`src/install/install.zig` / `src/install/lockfile/Tree.zig`

- C-25: パッケージキャッシュ管理の詳細
  - キャッシュの保存場所、無効化条件等の詳細は別ファイル
  - 候補：`src/install/cache/` / `src/install/npm.zig`

- C-26: ネットワークエラーリトライの詳細
  - HTTPリクエストのリトライ処理は別ファイル
  - 候補：`src/install/NetworkTask.zig` / `src/http/`

## 5) リスクフラグ（レビュー観点）
- 0: コマンドエントリーポイント - 低リスク（ソースで確認済み）
- 0: CLI引数解析 - 低リスク（ソースで確認済み）
- 0: PackageManager初期化 - 低リスク（ソースで確認済み）
- 1: ワークスペース処理 - 中リスク（別ファイルの確認が必要）
- 1: キャッシュ管理 - 中リスク（別ファイルの確認が必要）
- 1: ネットワークエラー処理 - 中リスク（別ファイルの確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] C-01〜C-23の主張がソースコードと整合しているか確認
- [ ] ワークスペース処理の実装を確認
- [ ] パッケージキャッシュの保存場所と管理方法を確認
- [ ] ネットワークエラー時のリトライ動作を確認
- [ ] frozen-lockfileモードの動作を確認
- [ ] ライフサイクルスクリプト実行の詳細を確認
