---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべてのテストケースに根拠となるテストファイルが存在します

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/js/bun/http/serve.test.ts` - HTTPサーバー基本テスト
- E-02: `test/js/bun/websocket/websocket-server.test.ts` - WebSocketサーバーテスト
- E-03: `test/integration/mysql2/mysql2.test.ts` - MySQL2連携テスト
- E-04: `test/js/bun/s3/s3.test.ts` - S3ストレージテスト
- E-05: `test/js/web/fetch/fetch.test.ts` - Fetch API基本テスト
- E-06: `test/cli/install/bun-install-registry.test.ts` - npmレジストリ連携テスト
- E-07: `test/js/node/http/node-http.test.ts` - Node.js HTTP互換テスト
- E-08: `test/integration/next-pages/test/dev-server.test.ts` - Next.js連携テスト
- E-09: `test/integration/svelte/client-side.test.ts` - Svelteクライアントテスト
- E-10: `test/integration/svelte/server-side.test.ts` - Svelteサーバーテスト
- E-11: `test/integration/typegraphql/src/typegraphql.test.ts` - TypeGraphQLテスト
- E-12: `test/integration/esbuild/esbuild.test.ts` - esbuild互換テスト
- E-13: `test/js/node/tls/node-tls-connect.test.ts` - TLS接続テスト
- E-14: `test/js/node/tls/node-tls-upgrade.test.ts` - TLSアップグレードテスト
- E-15: `test/js/node/tls/test-use-system-ca.test.ts` - システムCAテスト
- E-16: `test/js/node/worker_threads/worker_threads.test.ts` - Workerスレッドテスト
- E-17: `test/js/node/worker_threads/worker-async-dispose.test.ts` - Worker破棄テスト
- E-18: `test/js/node/child_process/child_process.test.ts` - 子プロセステスト
- E-19: `test/js/node/child_process/child-process-exec.test.ts` - exec テスト
- E-20: `test/js/node/http2/node-http2-continuation.test.ts` - HTTP/2テスト
- E-21: `test/integration/vite-build/vite-build.test.ts` - Viteビルドテスト
- E-22: `test/integration/sharp/sharp.test.ts` - Sharp画像処理テスト
- E-23: `test/integration/nest/nest_metadata.test.ts` - NestJSテスト
- E-24: `test/integration/expo-app/expo.test.ts` - Expoテスト
- E-25: `test/integration/jsdom/jsdom.test.ts` - JSDOMテスト
- E-26: `test/js/node/net/node-net-server.test.ts` - TCPサーバーテスト
- E-27: `test/js/node/net/double-connect.test.ts` - TCP二重接続テスト
- E-28: `test/js/web/fetch/fetch-gzip.test.ts` - gzip圧縮テスト
- E-29: `test/js/web/fetch/fetch.brotli.test.ts` - brotli圧縮テスト
- E-30: `test/js/web/fetch/fetch.tls.test.ts` - Fetch TLSテスト
- E-31: `test/js/web/fetch/fetch.unix.test.ts` - Unixソケットテスト
- E-32: `test/js/web/fetch/fetch-keepalive.test.ts` - keepaliveテスト
- E-33: `test/cli/install/bunx.test.ts` - bunxコマンドテスト
- E-34: `test/cli/install/bun-publish.test.ts` - bun publishテスト
- E-35: `test/cli/install/bun-workspaces.test.ts` - ワークスペーステスト
- E-36: `test/js/bun/http/bun-serve-static.test.ts` - 静的ファイル配信テスト
- E-37: `test/js/bun/http/bun-serve-routes.test.ts` - ルーティングテスト
- E-38: `test/js/bun/http/bun-serve-ssl.test.ts` - SSLサーバーテスト
- E-39: `test/js/bun/http/bun-serve-cookies.test.ts` - Cookieテスト
- E-40: `test/js/bun/http/bun-serve-body-json-async.test.ts` - JSONボディテスト
- E-41: `test/js/bun/http/proxy.test.ts` - プロキシテスト
- E-42: `test/js/bun/s3/s3-list-objects.test.ts` - S3オブジェクト一覧テスト
- E-43: `test/js/bun/s3/s3-storage-class.test.ts` - S3ストレージクラステスト
- E-44: `test/js/node/inspector/inspector-profiler.test.ts` - プロファイラーテスト
- E-45: `test/js/node/inspector/inspector.test.ts` - Inspectorテスト
- E-46: `test/js/bun/http/bun-serve-propagate-errors.test.ts` - エラー伝播テスト
- E-47: `test/js/bun/http/request-smuggling.test.ts` - リクエストスマグリングテスト
- E-48: `test/js/node/watch/fs.watch.test.ts` - fs.watchテスト
- E-49: `test/js/node/watch/fs.watchFile.test.ts` - fs.watchFileテスト
- E-50: `test/cli/install/bun-audit.test.ts` - bun auditテスト
- E-51: `test/cli/install/bun-upgrade.test.ts` - bun upgradeテスト
- E-52: `test/js/node/cluster.test.ts` - Clusterテスト
- E-53: `test/js/web/fetch/fetch.stream.test.ts` - Fetchストリーミングテスト
- E-54: `test/js/node/vm/vm.test.ts` - VMテスト
- E-55: `test/js/bun/http/bun-serve-html.test.ts` - HTMLバンドルテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bun.serve基本動作テスト | E-01 | ○ |
| C-02 | ReadableStreamキャンセル動作テスト | E-01 | ○ |
| C-03 | サーバー緊急停止テスト | E-01 | ○ |
| C-04 | WebSocketサーバー基本動作テスト | E-02 | ○ |
| C-05 | WebSocketサブスクリプションテスト | E-02 | ○ |
| C-06 | クローズ済みWebSocket操作テスト | E-02 | ○ |
| C-07 | MySQL接続テスト（mysql2） | E-03 | ○ |
| C-08 | MySQLクエリ実行テスト | E-03 | ○ |
| C-09 | MySQL接続クローズテスト | E-03 | ○ |
| C-10 | S3基本操作テスト（R2/MinIO） | E-04 | ○ |
| C-11 | S3 Virtual Hosted-Styleテスト | E-04 | ○ |
| C-12 | S3マルチパートアップロードテスト | E-04 | ○ |
| C-13 | Fetchリダイレクトテスト | E-05 | ○ |
| C-14 | FetchのAbortSignalテスト | E-05 | ○ |
| C-15 | Data URL Fetchテスト | E-05 | ○ |
| C-16 | パッケージインストールテスト | E-06 | ○ |
| C-17 | 証明書認証テスト | E-06 | ○ |
| C-18 | レジストリユーザー認証テスト | E-06 | ○ |
| C-19 | Node.js HTTPサーバー基本テスト | E-07 | ○ |
| C-20 | リクエスト/レスポンスストリーミングテスト | E-07 | ○ |
| C-21 | 暗号化接続フラグテスト | E-07 | ○ |
| C-22 | Next.js開発サーバー起動テスト | E-08 | ○ |
| C-23 | Next.jsホットリロードテスト | E-08 | ○ |
| C-24 | Svelteクライアントサイドテスト | E-09 | ○ |
| C-25 | Svelteサーバーサイドテスト | E-10 | ○ |
| C-26 | TypeGraphQL基本テスト | E-11 | ○ |
| C-27 | esbuild互換性テスト | E-12 | ○ |
| C-28 | TLSサーバー接続テスト | E-13 | ○ |
| C-29 | TLSアップグレードテスト | E-14 | ○ |
| C-30 | システムCA証明書テスト | E-15 | ○ |
| C-31 | Worker基本動作テスト | E-16 | ○ |
| C-32 | Worker非同期破棄テスト | E-17 | ○ |
| C-33 | child_process.spawnテスト | E-18 | ○ |
| C-34 | child_process.execテスト | E-19 | ○ |
| C-35 | HTTP/2継続フレームテスト | E-20 | ○ |
| C-36 | Viteビルドテスト | E-21 | ○ |
| C-37 | Sharp画像処理テスト | E-22 | ○ |
| C-38 | NestJSメタデータテスト | E-23 | ○ |
| C-39 | Expoアプリテスト | E-24 | ○ |
| C-40 | JSDOMテスト | E-25 | ○ |
| C-41 | TCPサーバー基本テスト | E-26 | ○ |
| C-42 | TCP接続二重化テスト | E-27 | ○ |
| C-43 | Fetch gzip圧縮テスト | E-28 | ○ |
| C-44 | Fetch brotli圧縮テスト | E-29 | ○ |
| C-45 | Fetch TLSテスト | E-30 | ○ |
| C-46 | Fetch Unix Socket テスト | E-31 | ○ |
| C-47 | Fetch keepaliveテスト | E-32 | ○ |
| C-48 | bunxコマンドテスト | E-33 | ○ |
| C-49 | bun publishテスト | E-34 | ○ |
| C-50 | ワークスペーステスト | E-35 | ○ |
| C-51 | 静的ファイル配信テスト | E-36 | ○ |
| C-52 | ルーティングテスト | E-37 | ○ |
| C-53 | SSLサーバーテスト | E-38 | ○ |
| C-54 | Cookieハンドリングテスト | E-39 | ○ |
| C-55 | HTTPボディJSONパーステスト | E-40 | ○ |
| C-56 | HTTPプロキシテスト | E-41 | ○ |
| C-57 | S3オブジェクト一覧テスト | E-42 | ○ |
| C-58 | S3ストレージクラステスト | E-43 | ○ |
| C-59 | Inspectorプロファイラーテスト | E-44 | ○ |
| C-60 | Inspector基本テスト | E-45 | ○ |
| C-61 | エラー伝播テスト | E-46 | ○ |
| C-62 | リクエストスマグリング対策テスト | E-47 | ○ |
| C-63 | fs.watchテスト | E-48 | ○ |
| C-64 | fs.watchFileテスト | E-49 | ○ |
| C-65 | bun auditテスト | E-50 | ○ |
| C-66 | bun upgradeテスト | E-51 | ○ |
| C-67 | Node.js Clusterテスト | E-52 | ○ |
| C-68 | Fetchストリーミングテスト | E-53 | ○ |
| C-69 | VMコンテキストテスト | E-54 | ○ |
| C-70 | HTMLバンドル配信テスト | E-55 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースは既存のテストファイルに基づいて作成されています
  - 各テストケースにはソースコード上の根拠（テストファイル）が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースに根拠となるソースコードが存在
- テストの詳細手順はテストファイル内の実装に依存するため、実際のテストコードと照合してレビューすることを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの分類（API連携/コンポーネント間連携/データベース連携/外部サービス連携/フレームワーク連携）が適切か
- [ ] テスト手順が実際のテストファイルの実装と一致しているか
- [ ] 期待結果がテストのアサーションと整合しているか
- [ ] 優先度の設定が妥当か（高：基本機能、中：補助機能、低：オプション機能）
- [ ] 備考欄の参照ファイルパスが正確か
- [ ] テストケースIDの連番に抜けがないか
- [ ] 重要な結合テストシナリオに漏れがないか
