---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/DevServer/HmrSocket.zig` - HMRソケット通信の実装
- E-02: `src/bake/client/websocket.ts` - WebSocketクライアント実装
- E-03: `src/bake/DevServer.zig` - DevServer本体の実装
- E-04: `src/bake/client/overlay.ts` - エラーオーバーレイUI実装
- E-05: `src/bake/hmr-runtime-client.ts` - HMRランタイムクライアント
- E-06: `src/bun.js/ipc.zig` - IPC（プロセス間通信）実装
- E-07: `src/bun.js/bindings/webcore/MessagePort.cpp` - MessagePort実装
- E-08: `src/bun.js/bindings/BunDebugger.cpp` - デバッガ実装
- E-09: `src/bake/client/css-reloader.ts` - CSSリローダー実装
- E-10: `src/js/node/worker_threads.ts` - WebWorker実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocket接続通知 | E-02 (websocket.ts L123: console.info "[Bun] Hot-module-reloading socket connected...") | ○ |
| C-02 | WebSocket切断通知 | E-02 (websocket.ts L155: console.warn "[Bun] Hot-module-reloading socket disconnected...") | ○ |
| C-03 | WebSocket再接続通知 | E-02 (websocket.ts L172: console.info "[Bun] Reconnected") | ○ |
| C-04 | サーバーサイドコード変更通知 | E-05 (hmr-runtime-client.ts L38: console.info "[Bun] Server-side code changed, reloading!") | ○ |
| C-05 | バージョン不一致通知 | E-05 (hmr-runtime-client.ts L93: console.error "Version mismatch, hard-reloading") | ○ |
| C-06 | ビルドエラー通知 | E-04 (overlay.ts L28: buildErrors Map) | ○ |
| C-07 | ランタイムエラー通知 | E-04 (overlay.ts L29-30: runtimeErrors配列、RuntimeError型定義) | ○ |
| C-08 | 致命的エラー通知 | E-04 (overlay.ts L16: hasFatalError変数) | ○ |
| C-09 | クライアント接続通知 | E-01 (HmrSocket.zig L38: agent.notifyClientConnected) | ○ |
| C-10 | クライアント切断通知 | E-01 (HmrSocket.zig L247: agent.notifyClientDisconnected) | ○ |
| C-11 | クライアントナビゲーション通知 | E-01 (HmrSocket.zig L114-119, L264-276: notifyClientNavigated) | ○ |
| C-12 | コンソールログ通知 | E-01 (HmrSocket.zig L195-205: broadcast_console_log_from_browser_to_server) | ○ |
| C-13 | ホットアップデート通知 | E-03 (DevServer.zig L127-139: testing_batch_events) | ○ |
| C-14 | テスト同期通知 | E-01 (HmrSocket.zig L140-143: testing_watch_synchronization) | ○ |
| C-15 | IPCメッセージ通知 | E-06 (ipc.zig L34-49: Mode enum、advanced/json) | ○ |
| C-16 | IPC ACK通知 | E-06 (ipc.zig L135-137: getAckPacket) | ○ |
| C-17 | IPC NACK通知 | E-06 (ipc.zig L138-140: getNackPacket) | ○ |
| C-18 | postMessage通知 | E-10 (worker_threads.ts L151-154: postMessage実装) | ○ |
| C-19 | MessagePort通知 | E-07 (MessagePort.cpp L86-100: notifyMessageAvailable) | ○ |
| C-20 | Inspectorメッセージ通知 | E-08 (BunDebugger.cpp L200-205: sendMessageToFrontend) | ○ |
| C-21 | Bunリロード可能通知 | E-08 (BunDebugger.cpp L539: Bun.canReload) | ○ |
| C-22 | インクリメンタルビジュアライザ通知 | E-01 (HmrSocket.zig L79-81: incremental_visualizer) | ○ |
| C-23 | メモリビジュアライザ通知 | E-01 (HmrSocket.zig L83-93: memory_visualizer) | ○ |
| C-24 | CSSリロード通知 | E-05 (hmr-runtime-client.ts L3, L144: editCssArray) | ○ |
| C-25 | ソースマップ参照解除通知 | E-01 (HmrSocket.zig L207-218: unref_source_map) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての通知機能についてソースコード上の根拠を確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての項目がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 通知カテゴリの分類が適切か確認
- [ ] 各通知の説明が正確か確認
- [ ] 備考欄の情報が十分か確認
- [ ] 未検出の通知機能がないか確認（特にサードパーティ統合やプラグイン経由の通知）
