# 通知設計書 14-テスト同期通知

## 概要

本ドキュメントは、Bun DevServerにおけるテスト同期通知の設計を記載する。テストモード時にファイル監視の同期イベントを通知する機能である。

### 本通知の処理概要

テスト同期通知は、DevServerのエンドツーエンドテストにおいて、ファイル変更とビルド完了のタイミングを同期するための内部機能である。テストハーネスがファイル変更後にビルド完了を確実に待機できるようにする。

**業務上の目的・背景**：DevServerのテストでは、ファイル変更 → ビルド → WebSocket通知 → クライアント更新という非同期フローのタイミングが不安定になりやすい。この通知により、テストハーネスはビルドが完了しクライアントに通知が届いたことを確実に検知でき、フレーキーなテストを防止できる。

**通知の送信タイミング**：3つのタイミングで送信される。(1) バッチモード開始時（値=0）、(2) ビルド完了時（値=1または2）、(3) バッチ終了時（変更ファイルがない場合、値=2）。

**通知の受信者**：`testing_watch_synchronization`トピックを購読しているテストクライアント（通常はbake-harness.ts）。

**通知内容の概要**：`testing_watch_synchronization`メッセージID + 1バイトの状態コード。状態コードは 0=バッチモード開始、1=ビルド成功、2=変更なし/スキップ。

**期待されるアクション**：テストハーネスは状態コードを受け取り、適切なタイミングでアサーションを実行する。バッチモードでは複数のファイル変更をまとめて処理し、すべての変更が反映されるのを待ってからテストを継続する。

## 通知種別

アプリ内通知（WebSocket経由でのテスト同期用通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Pub/Sub） |
| 優先度 | 中（テスト専用） |
| リトライ | なし |

### 送信先決定ロジック

`testing_watch_synchronization`トピックを購読している全クライアントに配信される。

## 通知テンプレート

### WebSocket通知の場合

| 項目 | 内容 |
|-----|------|
| プロトコル | WebSocket (Binary) |
| メッセージID | `testing_watch_synchronization` |
| トピック | `testing_watch_synchronization` |

### メッセージ構造

```
[1バイト: MessageId.testing_watch_synchronization]
[1バイト: 状態コード]
  - 0: バッチモード開始
  - 1: ビルド成功（WebSocket通知あり）
  - 2: 変更なし/スキップ
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| status_code | 同期状態コード | テスト処理状態 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| テストメッセージ | `testing_batch_events`受信 | バッチモードが無効→有効 | バッチモード開始（値=0） |
| バンドル完了 | finalizeBundle完了 | testing_batch_eventsが有効 | ビルド成功通知（値=1または2） |
| バッチ終了 | バッチ解放 | entry_pointsが空 | 変更なし通知（値=2） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| テストモード無効 | `testing_batch_events`が`.disabled`の場合 |
| 通常運用時 | テストハーネス以外の通常開発時 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[testing_batch_eventsメッセージ受信] --> B{現在の状態}
    B -->|disabled| C{current_bundle != null?}
    C -->|Yes| D[enable_after_bundleに設定]
    C -->|No| E[enabledに設定]
    E --> F[状態コード0を送信]
    D --> G[バンドル完了を待機]
    G --> H[enabledに遷移]
    H --> F
    B -->|enable_after_bundle| I[デバッグアサート失敗]
    I --> J[WebSocketを閉じる]
    B -->|enabled| K[バッチを解放]
    K --> L{entry_pointsが空?}
    L -->|Yes| M[状態コード2を送信]
    L -->|No| N[startAsyncBundle実行]
    N --> O[バンドル完了後に状態コード送信]
    O --> P[disabledに戻す]
    M --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| DevServer.testing_batch_events | バッチモード状態 | union型（disabled/enable_after_bundle/enabled） |
| TestingBatch.entry_points | 変更ファイル一覧 | バッチ中に検知されたファイル |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不正な状態遷移 | enable_after_bundle中に再度testing_batch_eventsを受信 | WebSocketを閉じる（デバッグビルドでassert） |
| メモリ不足 | entry_pointsの割り当て失敗 | bun.handleOom/outOfMemory |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

テスト実行中のみ

## セキュリティ考慮事項

- テスト専用機能であり、本番環境では使用しない
- デバッグビルドでのみ完全な動作保証
- リリースビルドではpanicを起こさないように設計されている

## 備考

- この機能はBun DevServerのエンドツーエンドテスト専用
- bake-harness.tsと連携して動作する
- フレーキーテスト防止のための同期メカニズム

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DevServer.zig | `src/bake/DevServer.zig` | testing_batch_eventsのunion型定義（127-139行目） |
| 1-2 | DevServer.zig | `src/bake/DevServer.zig` | TestingBatch構造体 |

**読解のコツ**: testing_batch_eventsは3状態のunion型。disabled/enable_after_bundle/enabledの遷移を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HmrSocket.zig | `src/bake/DevServer/HmrSocket.zig` | onMessageのtesting_batch_eventsケース（134-171行目） |

**主要処理フロー**:
1. **134行目**: `testing_batch_events`メッセージの受信
2. **135-144行目**: `.disabled`状態からの遷移
3. **146-150行目**: `.enable_after_bundle`状態のエラーハンドリング
4. **151-170行目**: `.enabled`状態からのバッチ解放

#### Step 3: 通知送信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DevServer.zig | `src/bake/DevServer.zig` | publishメソッド |
| 3-2 | HmrSocket.zig | `src/bake/DevServer/HmrSocket.zig` | 140-143行目、156-159行目の通知送信 |

**主要処理フロー**:
- **140-143行目**: バッチモード開始時の通知（状態コード0）
- **156-159行目**: 変更なし時の通知（状態コード2）

### プログラム呼び出し階層図

```
HmrSocket.onMessage()
    │
    ├─ IncomingMessageId.testing_batch_events ケース
    │      │
    │      ├─ testing_batch_events == .disabled
    │      │      │
    │      │      ├─ current_bundle != null
    │      │      │      └─ .enable_after_bundle に設定
    │      │      │
    │      │      └─ current_bundle == null
    │      │             ├─ .enabled に設定
    │      │             └─ publish(.testing_watch_synchronization, [ID, 0])
    │      │
    │      ├─ testing_batch_events == .enable_after_bundle
    │      │      └─ debugAssert(false) → ws.close()
    │      │
    │      └─ testing_batch_events == .enabled
    │             │
    │             ├─ entry_points.count() == 0
    │             │      └─ publish(.testing_watch_synchronization, [ID, 2])
    │             │
    │             └─ entry_points.count() > 0
    │                    └─ startAsyncBundle()
    │                           └─ finalizeBundle()
    │                                  └─ publish(.testing_watch_synchronization, [ID, 1])
    │
    └─ .disabled に戻す
```

### データフロー図

```
[入力]                    [処理]                           [出力]

テストハーネス           HmrSocket                    テストハーネス
testing_batch_events ──▶ onMessage() ──▶ publish() ──▶ 状態コード受信
    │                        │               │            │
    │                        │               │            │
    └─ バッチモード要求      └─ 状態管理     └─ トピック   └─ アサーション
                                  │              配信          実行
                                  │
                                  └─ testing_batch_events状態
                                        ├─ disabled
                                        ├─ enable_after_bundle
                                        └─ enabled
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HmrSocket.zig | `src/bake/DevServer/HmrSocket.zig` | ソース | testing_batch_eventsメッセージ処理 |
| DevServer.zig | `src/bake/DevServer.zig` | ソース | testing_batch_events状態管理、TestingBatch構造体 |
| HotReloadEvent.zig | `src/bake/DevServer/HotReloadEvent.zig` | ソース | ホットリロードイベント（バッチとの連携） |
| bake-harness.ts | テストファイル | テスト | テストハーネス側の同期ロジック |
