# 通知設計書 16-IPC ACK通知

## 概要

本ドキュメントは、BunにおけるIPC ACK（肯定応答）通知の設計を記載する。IPCハンドル確認応答を送信する機能である。

### 本通知の処理概要

IPC ACK通知は、ファイルディスクリプタ（ハンドル）を含むIPCメッセージを正常に受信したことを送信元に通知するための確認応答機能である。Node.jsのNODE_HANDLE_ACKプロトコルと互換性がある。

**業務上の目的・背景**：ファイルディスクリプタの送信は通常のメッセージ送信よりも複雑で、受信側が正しくディスクリプタを受け取ったことを確認する必要がある。ACKにより、送信側は次のハンドル付きメッセージの送信を安全に行える。この仕組みにより、ハンドル送信の信頼性が保証される。

**通知の送信タイミング**：受信側が`NODE_HANDLE`コマンドを含むメッセージを受信し、かつファイルディスクリプタ（incoming_fd）が正常に受信できた場合に送信される。

**通知の受信者**：ハンドル付きメッセージを送信した送信元プロセス。送信元のSendQueueのwaiting_for_ackがクリアされ、次のメッセージ送信が可能になる。

**通知内容の概要**：`NODE_HANDLE_ACK`コマンドを含むJSONオブジェクト（jsonモード）またはシリアライズされたメッセージ（advancedモード）。

**期待されるアクション**：送信側はACKを受信すると、waiting_for_ack状態をクリアし、キューに残っている次のメッセージの送信を継続する。

## 通知種別

プロセス間通信（IPC ACK応答）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（ハンドル送信のブロッキングを解除） |
| リトライ | なし |

### 送信先決定ロジック

ハンドル付きメッセージの送信元プロセスに対して直接送信。

## 通知テンプレート

### JSONモードの場合

```json
{"cmd":"NODE_HANDLE_ACK"}
```

改行文字（`\n`）で終端。

### Advancedモードの場合

```
\x02\x24\x00\x00\x00\r\x00\x00\x00\x02\x03\x00\x00\x80cmd\x10\x0f\x00\x00\x80NODE_HANDLE_ACK\xff\xff\xff\xff
```

事前にシリアライズされた固定バイト列。

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cmd | コマンド種別 | 固定値 "NODE_HANDLE_ACK" | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| メッセージ受信 | NODE_HANDLEコマンド受信 | incoming_fdが存在する | FDが正常に受信できた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| FD未受信 | incoming_fdがnullの場合はNACKを送信 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[NODE_HANDLEメッセージ受信] --> B{incoming_fd != null?}
    B -->|Yes| C[ACKパケット作成]
    B -->|No| D[NACKパケット作成]
    C --> E[SendQueueにinsertMessage]
    D --> E
    E --> F[continueSend呼び出し]
    F --> G{ACK?}
    G -->|Yes| H[ipcParse呼び出し]
    G -->|No| I[処理終了]
    H --> J[messageイベント発火]
    J --> I
```

### 受信側（送信元）のフロー

```mermaid
flowchart TD
    A[ACKメッセージ受信] --> B[onAckNack呼び出し]
    B --> C{waiting_for_ack != null?}
    C -->|No| D[警告ログ出力]
    C -->|Yes| E[waiting_for_ackをクリア]
    E --> F[コールバック呼び出し]
    F --> G[continueSend呼び出し]
    G --> H[次のメッセージ送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| SendQueue.waiting_for_ack | 送信側のACK待ち状態 | SendHandle型 |
| SendQueue.incoming_fd | 受信したFD | bun.FileDescriptor型 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ACK不一致 | waiting_for_ackがnullなのにACK受信 | 警告ログのみ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（ACK自体はリトライしない） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

IPCチャネル開通中は常時送信可能

## セキュリティ考慮事項

- ACKはIPC内部プロトコルの一部であり、外部からのアクセスは不可
- ファイルディスクリプタの受け渡しは信頼できるプロセス間でのみ使用

## 備考

- Node.jsのNODE_HANDLE_ACKプロトコルとの完全互換
- 送信側のwaiting_for_ack状態管理がACKプロトコルの中核

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ipc.zig | `src/bun.js/ipc.zig` | advanced.getAckPacket()（135-137行目） |
| 1-2 | ipc.zig | `src/bun.js/ipc.zig` | json.getAckPacket()（176-178行目） |
| 1-3 | ipc.zig | `src/bun.js/ipc.zig` | SendQueue.waiting_for_ack（445行目） |

**読解のコツ**: getAckPacket()は固定バイト列を返す。jsonモードは人間可読、advancedモードはSerializedScriptValue形式。

#### Step 2: ACK送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ipc.zig | `src/bun.js/ipc.zig` | handleIPCMessage関数内のNODE_HANDLEケース（1101-1142行目） |

**主要処理フロー**:
1. **1103-1105行目**: incoming_fdの有無でACK/NACK判定
2. **1107-1109行目**: ACK/NACKパケット取得
3. **1112行目**: SendQueueにinsertMessage

#### Step 3: ACK受信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ipc.zig | `src/bun.js/ipc.zig` | onAckNack関数（644-681行目） |

**主要処理フロー**:
- **646-649行目**: waiting_for_ackのnullチェック
- **677-678行目**: ACK成功時のクリーンアップ

### プログラム呼び出し階層図

```
受信側: NODE_HANDLEメッセージ受信
    │
    └─ handleIPCMessage()
           │
           ├─ icmd == .handle
           │      │
           │      ├─ ack = (incoming_fd != null)
           │      │
           │      ├─ getAckPacket() or getNackPacket()
           │      │      ├─ json.getAckPacket(): '{"cmd":"NODE_HANDLE_ACK"}\n'
           │      │      └─ advanced.getAckPacket(): バイナリ列
           │      │
           │      ├─ SendHandle作成 (callbacks = .ack_nack)
           │      │
           │      ├─ insertMessage() → キュー先頭に挿入
           │      │
           │      └─ continueSend() → ACK送信
           │
           └─ ipcParse() → messageイベント発火

送信側: ACKメッセージ受信
    │
    └─ handleIPCMessage()
           │
           └─ icmd == .ack
                  │
                  └─ onAckNack(globalThis, .ack)
                         │
                         ├─ waiting_for_ackをクリア
                         │
                         ├─ コールバック呼び出し
                         │
                         └─ continueSend() → 次のメッセージ送信
```

### データフロー図

```
[送信プロセス]                           [受信プロセス]

ハンドル付き                              NODE_HANDLE
メッセージ送信 ────────────────────────▶ 受信
    │                                        │
    │                                        │
    ▼                                        ▼
waiting_for_ack                         incoming_fd確認
に保存                                       │
    │                                        │
    │                                        ▼
    │                                   ACKパケット生成
    │                                        │
    │                    ACK                 │
    ◀──────────────────────────────────────
    │
    ▼
onAckNack(.ack)
    │
    ▼
waiting_for_ack
クリア
    │
    ▼
次のメッセージ送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ipc.zig | `src/bun.js/ipc.zig` | ソース | ACK/NACK処理の主実装 |
| IPC.cpp | `src/bun.js/bindings/IPC.cpp` | ソース | ipcParse/ipcSerializeのC++実装 |
