# 通知設計書 20-Inspectorメッセージ通知

## 概要

本ドキュメントは、BunにおけるInspectorメッセージ通知の設計を記載する。デバッガフロントエンドにメッセージを送信する機能である。

### 本通知の処理概要

Inspectorメッセージ通知は、Bunランタイムからデバッガフロントエンド（Chrome DevToolsなど）に対して、デバッグ情報やランタイム状態をリアルタイムで送信する機能である。Chrome DevTools Protocol（CDP）を使用してWebSocket経由で通信する。

**業務上の目的・背景**：開発者がBunアプリケーションをデバッグする際、ブレークポイントの設定、変数の検査、コールスタックの確認などを行う必要がある。Inspectorメッセージ通知により、JavaScriptCoreのデバッガ機能をChrome DevToolsなどの外部ツールから利用できるようになる。

**通知の送信タイミング**：デバッガがアタッチされ、ランタイムイベント（ブレークポイントヒット、コンソール出力、例外発生など）が発生した際に、`sendMessageToFrontend()`を通じてフロントエンドに通知される。

**通知の受信者**：WebSocket経由で接続されたデバッガフロントエンド（Chrome DevTools、VS Code、etc.）。`/bun:inspect`エンドポイントに接続する。

**通知内容の概要**：Chrome DevTools Protocol準拠のJSONメッセージ。デバッガイベント、ランタイム通知、プロファイリング結果などを含む。

**期待されるアクション**：フロントエンドはメッセージを受け取り、UIを更新してデバッグ情報を表示する。開発者はこれらの情報を元にコードの問題を特定・修正する。

## 通知種別

デバッガプロトコル通信（WebSocket経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket） |
| 優先度 | 高 |
| リトライ | なし（WebSocketバッファリング） |

### 送信先決定ロジック

`/bun:inspect`エンドポイントにWebSocket接続しているデバッガフロントエンドに対して送信。

## 通知テンプレート

### WebSocket通知の場合

| 項目 | 内容 |
|-----|------|
| プロトコル | WebSocket (TEXT) |
| エンドポイント | `/bun:inspect` |
| メッセージ形式 | JSON（Chrome DevTools Protocol） |

### メッセージ構造

```json
{
  "method": "Debugger.paused",
  "params": {
    "callFrames": [...],
    "reason": "breakpoint"
  }
}
```

または

```json
{
  "id": 1,
  "result": {
    ...
  }
}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| method | CDPメソッド名 | JavaScriptCore Inspector | Yes（イベント時） |
| params | メソッドパラメータ | JavaScriptCore Inspector | No |
| id | リクエストID | フロントエンドからのリクエスト | Yes（応答時） |
| result | 応答結果 | JavaScriptCore Inspector | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| デバッガイベント | ブレークポイントヒット | Inspector接続中 | Debugger.paused |
| コンソール出力 | console.log等 | Inspector接続中 | Runtime.consoleAPICalled |
| 例外発生 | 未処理例外 | Inspector接続中 | Runtime.exceptionThrown |
| スクリプト読み込み | JSファイル解析完了 | Inspector接続中 | Debugger.scriptParsed |
| フロントエンドリクエスト | CDPコマンド受信 | Inspector接続中 | 対応する応答 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Inspector未接続 | デバッガが接続されていない場合 |
| バッファ満杯 | WebSocketバッファが上限に達した場合は保留 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[JavaScriptCore Inspectorイベント] --> B[sendMessageToFrontend呼び出し]
    B --> C{WebSocket接続中?}
    C -->|No| D[メッセージ破棄]
    C -->|Yes| E{バッファ空?}
    E -->|Yes| F[WebSocket.send直接送信]
    E -->|No| G[pendingMessagesに追加]
    G --> H[drain時にまとめて送信]
    F --> I[処理完了]
    H --> I
```

### 接続フロー

```mermaid
flowchart TD
    A[WebSocket接続オープン] --> B[setInspectable(true)]
    B --> C[BunInspectorConnection作成]
    C --> D[inspectorDebuggable.connect]
    D --> E[runWhilePausedCallback設定]
    E --> F[デバッグセッション開始]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| BunInspectorConnection | 接続管理 | WebSocketとGlobalObjectへの参照 |
| pendingMessages | メッセージバッファ | Vector<WTF::String> |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 接続切断 | WebSocket切断 | inspectorDebuggable.disconnect呼び出し |
| バッファ満杯 | getBufferedAmount() > 0 | pendingMessagesに追加してdrain待ち |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（WebSocketバッファリングで代替） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

デバッガ接続中は常時送信可能

## セキュリティ考慮事項

- デバッガ接続はローカルホストからのみを推奨
- `--inspect`フラグで明示的に有効化する必要がある
- 機密情報（変数値、ソースコード）がフロントエンドに送信される可能性がある
- 本番環境ではInspectorを無効化すること

## 備考

- Chrome DevTools Protocol（CDP）に準拠
- JavaScriptCoreのInspector機能を利用
- `Bun.canReload`メッセージでBunのリロード機能との連携も可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | BunInspectorConnection構造体 |
| 1-2 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | FrontendChannelインターフェース |

**読解のコツ**: BunInspectorConnectionはWebKitのInspector::FrontendChannelを継承しており、sendMessageToFrontendがオーバーライドされている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | addInspector関数（104-179行目） |
| 2-2 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | onOpen/onMessage/onCloseハンドラ |

**主要処理フロー**:
1. **119-123行目**: WebSocket openハンドラ - setInspectable, connect呼び出し
2. **124-126行目**: messageハンドラ - onMessage呼び出し
3. **135-138行目**: closeハンドラ - onClose, disconnect呼び出し

#### Step 3: メッセージ送信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | sendMessageToFrontend関数（53-56行目） |
| 3-2 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | send関数（58-66行目） |
| 3-3 | BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | drain関数（80-94行目） |

**主要処理フロー**:
- **53-56行目**: sendMessageToFrontendがsendを呼び出し
- **58-66行目**: バッファ空ならws->send、そうでなければpendingMessagesに追加
- **80-94行目**: drainでpendingMessagesをまとめて送信

### プログラム呼び出し階層図

```
JavaScriptCore Inspector
    │
    └─ InspectorDebuggable
           │
           └─ FrontendChannel::sendMessageToFrontend()
                  │
                  └─ BunInspectorConnection::sendMessageToFrontend()
                         │
                         └─ send(message)
                                │
                                ├─ getBufferedAmount() == 0
                                │      └─ ws->send(message, TEXT)
                                │
                                └─ getBufferedAmount() > 0
                                       └─ pendingMessages.append(message)
                                              │
                                              └─ [drain時]
                                                     └─ ws->cork()
                                                            └─ 各メッセージを送信
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JavaScriptCore           BunInspectorConnection         DevToolsフロントエンド
Inspectorイベント ───▶ sendMessageToFrontend() ───▶ WebSocket ───▶ UI更新
    │                        │                        │              │
    │                        │                        │              │
    └─ CDPメッセージ          └─ バッファリング          └─ /bun:inspect └─ デバッグ
       (JSON)                   pendingMessages          エンドポイント    情報表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BunInspector.cpp | `src/bun.js/bindings/BunInspector.cpp` | ソース | Inspector実装、WebSocketハンドラ |
| BunDebugger.cpp | `src/bun.js/bindings/BunDebugger.cpp` | ソース | デバッガ統合 |
| InspectorBunFrontendDevServerAgent.cpp | `src/bun.js/bindings/InspectorBunFrontendDevServerAgent.cpp` | ソース | DevServer向けInspectorエージェント |
| InspectorBunFrontendDevServerAgent.zig | `src/bun.js/api/server/InspectorBunFrontendDevServerAgent.zig` | ソース | Zig側のInspectorバインディング |
