# 通知設計書 21-Bunリロード可能通知

## 概要

本ドキュメントは、Bun開発サーバーにおけるデバッガ向けリロード可能通知機能の設計を定義する。この通知は、ホットリロードが発生する前にデバッガフロントエンドへ「Bun.canReload」メッセージを送信し、デバッグセッションの継続性を確保するために使用される。

### 本通知の処理概要

この通知は、Bunランタイムがホットリロード（HMR: Hot Module Reloading）を実行する直前に、接続されているすべてのデバッガフロントエンドに対してリロード可能であることを事前通知する機能である。

**業務上の目的・背景**：開発者がデバッガを使用してコードをデバッグしている際、ファイル変更によるホットリロードが発生すると、デバッグセッションが予期せず中断される可能性がある。この通知により、デバッガフロントエンドはリロードが発生することを事前に認識し、ブレークポイントの再設定やセッション状態の保存など、適切な準備を行うことができる。これにより、開発者のデバッグ体験が向上し、ホットリロード後もスムーズにデバッグを継続できる。

**通知の送信タイミング**：`BunDebugger__willHotReload`関数が呼び出されたとき、すなわちBunランタイムがホットリロードを実行しようとする直前に送信される。この関数は、ファイル監視機能がソースコードの変更を検知し、再バンドルを完了した後、新しいコードをロードする前に呼び出される。

**通知の受信者**：現在アクティブなすべてのInspector接続（`BunInspectorConnection`）。これらは通常、Chrome DevToolsやVS Codeのデバッガなど、WebKit Inspectorプロトコルをサポートするデバッガフロントエンドである。

**通知内容の概要**：JSON形式のメッセージ `{"method":"Bun.canReload"}` が送信される。このメッセージはWebKit Inspectorプロトコルの拡張として実装されており、Bun固有のリロードイベントを通知する。

**期待されるアクション**：デバッガフロントエンドは、このメッセージを受信した際に、現在のデバッグ状態（ブレークポイント、ウォッチ式、コールスタックなど）を保存し、リロード後にこれらの状態を復元する準備を行う。また、ユーザーに対してリロードが発生することを視覚的に通知することも可能である。

## 通知種別

デバッガプロトコル通知（WebKit Inspector Protocol拡張）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（postTaskConcurrently） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

すべてのアクティブなInspector接続に対してブロードキャストされる。`inspectorConnections`マップに登録されているすべての`BunInspectorConnection`インスタンスがメッセージの送信先となる。接続は`ScriptExecutionContextIdentifier`をキーとしてグループ化されており、各グループ内のすべての接続に対してメッセージが送信される。

## 通知テンプレート

### メッセージフォーマット

| 項目 | 内容 |
|-----|------|
| プロトコル | WebSocket（Inspector Protocol） |
| 形式 | JSON |
| エンコーディング | UTF-8 |

### 本文テンプレート

```json
{"method":"Bun.canReload"}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知は固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部イベント | BunDebugger__willHotReload呼び出し | debuggerScriptExecutionContextがnullでない | ホットリロード実行直前に呼び出される |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| debuggerScriptExecutionContext == nullptr | デバッガスクリプト実行コンテキストが未初期化の場合、通知は送信されない |
| 接続なし | inspectorConnectionsに登録された接続がない場合、実質的にメッセージは送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイル変更検知] --> B[再バンドル完了]
    B --> C[BunDebugger__willHotReload呼び出し]
    C --> D{debuggerScriptExecutionContext存在チェック}
    D -->|null| E[処理終了]
    D -->|存在| F[postTaskConcurrently実行]
    F --> G[inspectorConnectionsロック取得]
    G --> H[全接続をイテレート]
    H --> I[sendMessageToFrontend呼び出し]
    I --> J[Bun.canReloadメッセージ送信]
    J --> K[次の接続へ]
    K --> H
    H -->|全接続処理完了| L[ロック解放]
    L --> M[ホットリロード実行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。すべてのデータはメモリ上のデータ構造（inspectorConnectionsマップ）から取得される。

### 更新テーブル一覧

なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンテキスト未初期化 | debuggerScriptExecutionContextがnullの場合 | 早期リターンで処理をスキップ |
| 接続切断 | メッセージ送信中に接続が切断された場合 | 個別の接続エラーは無視し、他の接続への送信を継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（開発環境でのみ使用）

## セキュリティ考慮事項

- この通知は開発環境専用であり、本番環境では使用されない
- Inspector接続は通常ローカルホストからのみ許可される
- メッセージ内容に機密情報は含まれない
- 接続の認証はWebKit Inspectorプロトコルの標準機能に依存

## 備考

- この機能はBun固有の拡張であり、標準のWebKit Inspectorプロトコルには含まれない
- Chrome DevToolsやVS Codeなどのデバッガがこのメッセージをどのように処理するかは、各ツールの実装に依存する
- ホットリロードの成功/失敗に関わらず、この通知はリロード試行前に送信される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Inspector接続の管理に使用されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BunDebugger.cpp | `src/bun.js/bindings/BunDebugger.cpp` | BunInspectorConnectionクラスの構造、inspectorConnectionsマップの定義（行29-30）、ConnectionStatusの定義（行65-70） |

**読解のコツ**: C++のWTF（Web Template Framework）ライブラリの型に注意。`WTF::UncheckedKeyHashMap`はWebKitのハッシュマップ実装である。

#### Step 2: エントリーポイントを理解する

通知の起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BunDebugger.cpp | `src/bun.js/bindings/BunDebugger.cpp` | BunDebugger__willHotReload関数の実装（行529-543） |

**主要処理フロー**:
1. **行531**: debuggerScriptExecutionContextのnullチェック
2. **行535**: postTaskConcurrentlyで非同期タスクをスケジュール
3. **行536-537**: inspectorConnectionsLockを取得してスレッドセーフに処理
4. **行538-541**: 全接続をイテレートしてメッセージを送信

#### Step 3: メッセージ送信処理を理解する

実際のメッセージ送信がどのように行われるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BunDebugger.cpp | `src/bun.js/bindings/BunDebugger.cpp` | sendMessageToFrontendメソッドの実装（行200-206）、sendMessageToDebuggerThreadメソッドの実装（行327-339） |

**主要処理フロー**:
- **行200-206**: sendMessageToFrontendはメッセージを受け取り、sendMessageToDebuggerThreadを呼び出す
- **行329-332**: メッセージをdebuggerThreadMessagesキューに追加
- **行334-338**: スケジュールカウントが0の場合、postTaskConcurrentlyで受信処理をスケジュール

### プログラム呼び出し階層図

```
BunDebugger__willHotReload() [BunDebugger.cpp:529]
    │
    ├─ debuggerScriptExecutionContext nullチェック
    │
    └─ postTaskConcurrently() [非同期タスク]
           │
           ├─ inspectorConnectionsLock.lock()
           │
           ├─ for each connection in inspectorConnections
           │      │
           │      └─ connection->sendMessageToFrontend()
           │             │
           │             └─ sendMessageToDebuggerThread()
           │                    │
           │                    ├─ debuggerThreadMessagesLock.lock()
           │                    ├─ debuggerThreadMessages.append(message)
           │                    └─ postTaskConcurrently() [受信処理]
           │                           │
           │                           └─ receiveMessagesOnDebuggerThread()
           │
           └─ inspectorConnectionsLock.unlock()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ホットリロード         BunDebugger__              各Inspector接続
トリガー         ───▶  willHotReload()      ───▶  (Chrome DevTools,
                              │                    VS Code等)
                              │
                              ▼
                       postTaskConcurrently
                              │
                              ▼
                       inspectorConnections
                       マップをイテレート
                              │
                              ▼
                       sendMessageToFrontend
                       {"method":"Bun.canReload"}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BunDebugger.cpp | `src/bun.js/bindings/BunDebugger.cpp` | ソース | Inspector接続管理とデバッガ通知の中核実装 |
| ZigGlobalObject.h | `src/bun.js/bindings/ZigGlobalObject.h` | ヘッダー | GlobalObjectの定義、bunVMへのアクセス |
| ScriptExecutionContext.h | `src/bun.js/bindings/ScriptExecutionContext.h` | ヘッダー | スクリプト実行コンテキストの管理 |
| InspectorFrontendChannel.h | JavaScriptCore | ヘッダー | Inspectorフロントエンドチャネルの基底クラス |
