# 通知設計書 5-バージョン不一致通知

## 概要

本ドキュメントは、Bun の Hot Module Reloading (HMR) 機能において、クライアントとサーバーのバージョン（設定ハッシュ）が一致しない場合にブラウザのコンソールに表示されるエラー通知と、強制リロードの設計を記載する。

### 本通知の処理概要

この通知は、WebSocket 接続確立時にサーバーから送信されるバージョン情報（設定ハッシュ）がクライアント側で保持しているバージョンと異なる場合に、整合性を保つためにページの強制リロード（ハードリロード）を実行する前に表示される警告メッセージである。

**業務上の目的・背景**：開発サーバーの設定変更やサーバー再起動後、クライアント側のキャッシュされたバンドルと新しいサーバー設定の間で不整合が発生する可能性がある。この通知により、バージョン不一致を検出し、自動的にページをリロードして最新の状態に同期することで、開発者が古いコードで作業し続けることを防ぐ。

**通知の送信タイミング**：WebSocket 経由で `MessageId.version` メッセージを受信した際に、メッセージに含まれるサーバーのバージョンハッシュとクライアント側の `config.version` を比較し、不一致の場合に送信される。

**通知の受信者**：ブラウザのコンソールを通じて開発者に通知される。`console.error()` メソッドでエラーレベルとして出力される。

**通知内容の概要**：`Version mismatch, hard-reloading` という固定メッセージがコンソールに出力される。このメッセージは、バージョン不一致が検出され、ページの強制リロードが実行されることを示す。

**期待されるアクション**：開発者はこのメッセージを確認した後、ページが自動的にリロードされることを待つ。リロード後は最新のサーバー設定とクライアントコードで動作する。特別なアクションは不要。

## 通知種別

コンソール通知（ブラウザ開発者ツール）- エラーレベル

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（version メッセージ処理中に即座に実行、その後 fullReload） |
| 優先度 | 高（整合性に関わる重要な通知） |
| リトライ | 無（コンソール出力は失敗しない。fullReload で解決） |

### 送信先決定ロジック

ブラウザの `console.error()` メソッドを使用してコンソールに直接出力するため、特別な送信先決定ロジックは存在しない。

## 通知テンプレート

### コンソール出力

| 項目 | 内容 |
|-----|------|
| 出力レベル | error |
| プレフィックス | なし |

### 本文テンプレート

```
Version mismatch, hard-reloading
```

### 添付ファイル

該当なし（コンソール出力のため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| WebSocket メッセージ | `MessageId.version` | サーバーバージョン !== クライアントバージョン | バージョン不一致検出時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| バージョン一致 | サーバーとクライアントのバージョンが一致している場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[version メッセージ受信] --> B[サーバーバージョン抽出]
    B --> C{サーバーバージョン === config.version?}
    C -->|Yes| D{isFirstRun?}
    D -->|Yes| E[isFirstRun = false]
    E --> F[WebSocket サブスクリプション送信]
    D -->|No| G[fullReload 実行]
    C -->|No| H[console.error でメッセージ出力]
    H --> I[fullReload 実行]
    F --> J[終了]
    G --> J
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（クライアントサイドのコンソール出力のため、データベースアクセスは発生しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バージョン不一致 | サーバー設定変更後のクライアント接続 | fullReload で最新状態に同期 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（fullReload で解決） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（バージョン不一致検出時のみ発生） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（開発時に随時発生）

## セキュリティ考慮事項

- この通知は開発環境でのみ使用されることを想定している
- 機密情報は含まれない（固定メッセージのみ）
- バージョン情報（設定ハッシュ）は通知メッセージには含まれない

## 備考

- `config.version` はビルド時に生成される設定ハッシュで、DevServer の `configuration_hash_key` と比較される
- バージョン一致でも `isFirstRun === false`（再接続時）の場合は fullReload が実行される
- これは、再接続時にクライアントファイルが古くなっている可能性があるため
- `fullReload()` は `location.reload()` を呼び出してページ全体を再読み込みする

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バージョン管理に関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hmr-runtime-client.ts | `src/bake/hmr-runtime-client.ts` | 89行目の `isFirstRun` 変数で初回接続判定を理解する |
| 1-2 | generated.ts | `src/bake/generated.ts` | `MessageId.version` の定義を確認する |

**読解のコツ**: `config.version` はグローバルな設定オブジェクトに含まれており、ビルド時に DevServer によって設定される。

#### Step 2: version メッセージハンドラを理解する

バージョンチェックの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hmr-runtime-client.ts | `src/bake/hmr-runtime-client.ts` | 91-117行目の `handlers[MessageId.version]` でバージョンチェック処理を理解する |

**主要処理フロー**:
1. **92行目**: `td.decode(view.buffer.slice(1))` でサーバーバージョンをデコード
2. **92行目**: `!== config.version` でバージョン比較
3. **93-96行目**: 不一致時のエラー出力と fullReload
4. **98-106行目**: 初回接続/再接続時の処理分岐

#### Step 3: サーバーサイドのバージョン送信を理解する

サーバーがどのようにバージョン情報を送信するかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HmrSocket.zig | `src/bake/DevServer/HmrSocket.zig` | 31行目の `onOpen` でバージョンメッセージ送信を理解する |

**主要処理フロー**:
- **31行目**: `ws.send(&(.{MessageId.version.char()} ++ s.dev.configuration_hash_key), .binary, false, true)` でバージョン送信

### プログラム呼び出し階層図

```
HmrSocket.onOpen (サーバーサイド)
    │
    └─ ws.send(MessageId.version + configuration_hash_key)
           │
           ▼
handlers[MessageId.version] (クライアントサイド)
    │
    ├─ td.decode() でサーバーバージョン取得
    │
    ├─ config.version と比較
    │      │
    │      ├─ [不一致]
    │      │      │
    │      │      ├─ console.error() ← 通知出力
    │      │      │
    │      │      └─ fullReload()
    │      │
    │      └─ [一致]
    │             │
    │             ├─ isFirstRun === true
    │             │      │
    │             │      ├─ isFirstRun = false
    │             │      │
    │             │      └─ ws.sendBuffered() でサブスクリプション
    │             │
    │             └─ isFirstRun === false
    │                    │
    │                    └─ fullReload() (再接続時)
    │
    └─ fullReload() → location.reload()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サーバー              WebSocket onOpen
    │                     │
    ├─ configuration_hash_key
    │                     │
    ▼                     ▼
version メッセージ ──▶ handlers[MessageId.version]
                              │
                              ▼
                       td.decode()
                              │
                              ▼
                    config.version と比較
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
              [不一致]              [一致]
                    │                   │
                    ▼                   ▼
            console.error() ──▶  isFirstRun 判定
            "Version mismatch..."       │
                    │             ┌─────┴─────┐
                    ▼             ▼           ▼
              fullReload()    [初回]      [再接続]
                                 │           │
                                 ▼           ▼
                          サブスクリプション  fullReload()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hmr-runtime-client.ts | `src/bake/hmr-runtime-client.ts` | ソース | HMR クライアント、version ハンドラ |
| HmrSocket.zig | `src/bake/DevServer/HmrSocket.zig` | ソース | サーバーサイドの WebSocket 接続処理、バージョン送信 |
| DevServer.zig | `src/bake/DevServer.zig` | ソース | `configuration_hash_key` の生成と管理 |
| hmr-module.ts | `src/bake/hmr-module.ts` | ソース | `fullReload` 関数の定義 |
| shared.ts | `src/bake/shared.ts` | ソース | `td` (TextDecoder) の定義 |
