# 通知設計書 6-ビルドエラー通知

## 概要

本ドキュメントは、Bun の Hot Module Reloading (HMR) 機能において、バンドラーエラーが発生した際にブラウザ上のオーバーレイ UI で表示される通知の設計を記載する。

### 本通知の処理概要

この通知は、JavaScript/TypeScript/CSS などのバンドル処理中に発生したエラー（構文エラー、モジュール解決エラー、型エラーなど）を、開発者が即座に認識できるようにブラウザ上にオーバーレイとして表示する。エラーの詳細情報（ファイル名、行番号、列番号、エラーメッセージ、コードプレビュー）を視覚的に提示することで、迅速なデバッグを可能にする。

**業務上の目的・背景**：開発中にビルドエラーが発生した場合、コンソールに出力されるだけでは見落とされる可能性がある。オーバーレイ UI によりエラーを画面全体に表示することで、開発者がエラーを即座に認識し、修正作業に取り掛かれるようにする。これにより、壊れた状態でのアプリケーション操作を防ぎ、デバッグ効率を向上させる。

**通知の送信タイミング**：DevServer がバンドル処理を実行し、エラーが発生した場合に、WebSocket 経由で `MessageId.errors` メッセージとして `SerializedFailure` 形式でクライアントに送信される。クライアントはこれを受信してオーバーレイに表示する。

**通知の受信者**：ブラウザ上のオーバーレイ UI を通じて開発者に通知される。オーバーレイは画面全体を覆うモーダルダイアログとして表示される。

**通知内容の概要**：エラーメッセージ、エラー発生ファイル、行番号・列番号、エラーが発生したコード行のプレビュー、および関連する注釈（notes）が表示される。複数のエラーがある場合は、ビルドエラーとして一覧表示される。

**期待されるアクション**：開発者はオーバーレイに表示されたエラー情報を確認し、該当するファイルを修正する。修正後、DevServer が再ビルドを行い、エラーが解消されるとオーバーレイは自動的に閉じる（または更新される）。

## 通知種別

オーバーレイ UI（ブラウザ内モーダル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（WebSocket バイナリメッセージ） |
| 優先度 | 高（ビルドエラーは開発継続を妨げる重要な問題） |
| リトライ | 無（WebSocket 経由でリアルタイム配信） |

### 送信先決定ロジック

DevServer に接続しているすべての HMR クライアント（ブラウザタブ）に対して、errors トピックにサブスクライブしているクライアントにブロードキャストされる。

## 通知テンプレート

### オーバーレイ表示

| 項目 | 内容 |
|-----|------|
| モーダルタイトル | `<count> Build Error` / `<count> Build Errors` |
| 背景色 | 半透明ダーク（`#8883`） |
| Z-index | `2147483647`（最前面） |

### エラー表示構造

```
[ファイル名]
─────────────────────────────
error: [エラーメッセージ]

 123 | [コード行]
     |     ^^^^^ (エラー位置をハイライト)

note: [追加情報]
```

### 添付ファイル

該当なし（オーバーレイ UI での表示）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| `file` | エラー発生ファイルのパス | `SerializedFailure.Owner` からのパス解決 | No |
| `level` | エラーレベル（error/warn/note） | `BundlerMessageLevel` | Yes |
| `message` | エラーメッセージ本文 | `BundlerMessage.message` | Yes |
| `line` | エラー発生行番号（1始まり） | `BundlerMessageLocation.line` | No |
| `column` | エラー発生列番号（1始まり） | `BundlerMessageLocation.column` | No |
| `length` | エラー範囲のバイト長 | `BundlerMessageLocation.length` | No |
| `lineText` | エラー発生行のソースコード | `BundlerMessageLocation.lineText` | No |
| `notes` | 追加情報配列 | `BundlerNote[]` | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ビルド完了 | バンドル処理完了時 | エラーが存在する場合 | ファイル変更後のインクリメンタルビルド、または初回ビルド |
| エラー解消 | バンドル処理完了時 | 既存エラーが解消された場合 | 解消されたエラーの削除通知も含まれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| エラーなし | ビルドが成功した場合は errors メッセージは送信されない（または空の削除リストのみ） |
| errors トピック未購読 | クライアントが errors トピックにサブスクライブしていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイル変更検出] --> B[インクリメンタルビルド実行]
    B --> C{ビルドエラー?}
    C -->|Yes| D[SerializedFailure 生成]
    D --> E[WebSocket errors メッセージ送信]
    E --> F[クライアント受信]
    F --> G[onServerErrorPayload 処理]
    G --> H[buildErrors Map 更新]
    H --> I[updateErrorOverlay 呼び出し]
    I --> J[オーバーレイ表示/更新]
    C -->|No| K{既存エラーあり?}
    K -->|Yes| L[エラー削除通知送信]
    L --> M[オーバーレイ閉じる/更新]
    K -->|No| N[通常の HMR 処理継続]
    J --> O[終了]
    M --> O
    N --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（メモリ上のデータ構造を使用）

### クライアントサイドデータ構造

| 変数名 | 型 | 用途 |
|--------|------|------|
| `buildErrors` | `Map<FailureOwner, DeserializedFailure>` | ビルドエラーの管理 |
| `errorDoms` | `Map<FailureOwner, ErrorDomNodes>` | エラー表示用 DOM 要素のキャッシュ |
| `updatedErrorOwners` | `Set<FailureOwner>` | 更新されたエラーの追跡 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| デシリアライズエラー | 不正なバイナリデータ受信 | エラーをスロー、処理中断 |
| DOM 生成エラー | メモリ不足など | 通常の例外処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（リアルタイム配信） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（開発時に随時発生）

## セキュリティ考慮事項

- この通知は開発環境でのみ使用されることを想定している
- エラーメッセージにはソースコードの一部が含まれる可能性がある
- オーバーレイは Shadow DOM 内にレンダリングされ、ユーザーコードとの衝突を防ぐ
- 本番環境では HMR 機能自体が無効化されるべきである

## 備考

- ビルドエラーは `FailureOwner`（32ビット整数）で一意に識別される
- `FailureOwner` は `SerializedFailure.Owner.Packed` の bitcast 値
- オーバーレイ CSS は `overlay.css` で定義され、Shadow DOM 内でスコープされる
- ビルドエラーはユーザーが dismiss できない（修正するまで表示され続ける）
- ランタイムエラーと共存する場合、ナビゲーションバーで切り替え可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビルドエラーのシリアライズ形式とデシリアライズ後の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error-serialization.ts | `src/bake/client/error-serialization.ts` | `DeserializedFailure`, `BundlerMessage`, `BundlerMessageLocation` インターフェースを理解する |
| 1-2 | overlay.ts | `src/bake/client/overlay.ts` | 22-32行目の状態変数（`buildErrors`, `errorDoms`, `updatedErrorOwners`）を理解する |

**読解のコツ**: `FailureOwner` は `SerializedFailure.Owner.Packed` の32ビット整数表現であり、クライアントサイドではデコードされない。

#### Step 2: メッセージ受信処理を理解する

WebSocket メッセージ受信からエラーデータ解析までの流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hmr-runtime-client.ts | `src/bake/hmr-runtime-client.ts` | 201行目で `MessageId.errors` ハンドラとして `onServerErrorPayload` を登録 |
| 2-2 | overlay.ts | `src/bake/client/overlay.ts` | 199-214行目の `onServerErrorPayload` でメッセージ処理 |
| 2-3 | overlay.ts | `src/bake/client/overlay.ts` | 368-381行目の `decodeAndAppendServerError` でエラーデコード |

**主要処理フロー**:
1. **201行目**: `handlers[MessageId.errors]: onServerErrorPayload` でハンドラ登録
2. **201-207行目**: 削除されたエラーの処理
3. **209-211行目**: 新規/更新エラーの処理
4. **213行目**: `updateErrorOverlay()` でUI更新

#### Step 3: オーバーレイ表示処理を理解する

エラーデータからオーバーレイUIを生成する処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | overlay.ts | `src/bake/client/overlay.ts` | 133-189行目の `mountModal` でモーダル初期化 |
| 3-2 | overlay.ts | `src/bake/client/overlay.ts` | 386-458行目の `updateErrorOverlay` でUI更新ロジック |
| 3-3 | overlay.ts | `src/bake/client/overlay.ts` | 526-568行目の `updateBuildErrorOverlay` でビルドエラー表示 |
| 3-4 | overlay.ts | `src/bake/client/overlay.ts` | 578-588行目の `renderBundlerMessage` でエラーメッセージ描画 |

**主要処理フロー**:
- **133-189行目**: Shadow DOM 生成、CSS 適用、DOM 構造構築
- **420行目**: ビルドエラー数に応じたタイトル設定
- **526-568行目**: 各エラーの DOM 要素生成と更新
- **620-633行目**: コードプレビューとハイライト表示

### プログラム呼び出し階層図

```
DevServer.zig (サーバーサイド)
    │
    └─ SerializedFailure 生成
           │
           └─ WebSocket publish (errors トピック)
                  │
                  ▼
handlers[MessageId.errors] (クライアントサイド)
    │
    └─ onServerErrorPayload()
           │
           ├─ removedCount 処理（削除されたエラー）
           │      └─ buildErrors.delete()
           │
           └─ decodeAndAppendServerError()
                  │
                  ├─ decodeSerializedError()
                  │      └─ readLogMsg()
                  │
                  └─ buildErrors.set()
                         │
                         └─ updateErrorOverlay()
                                │
                                ├─ mountModal() (初回のみ)
                                │
                                ├─ updateBuildErrorOverlay()
                                │      │
                                │      └─ renderBundlerMessage()
                                │             │
                                │             ├─ renderErrorMessageLine()
                                │             │
                                │             ├─ renderCodeLine()
                                │             │
                                │             └─ renderNote()
                                │
                                └─ setModalVisible(true)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

DevServer            SerializedFailure
ビルドエラー ─────▶     │
                       ▼
                WebSocket publish
                       │
                       ▼
              onServerErrorPayload ──────────────────▶ buildErrors Map 更新
                       │
                       ▼
              decodeAndAppendServerError
                       │
                       ▼
              updateErrorOverlay
                       │
                       ▼
              mountModal (Shadow DOM)
                       │
                       ▼
              updateBuildErrorOverlay ────────────────▶ オーバーレイ表示
                       │
                       ▼
              renderBundlerMessage
                       │
                       ▼
              [エラー情報表示]
               - ファイル名
               - エラーメッセージ
               - コードプレビュー
               - ハイライト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| overlay.ts | `src/bake/client/overlay.ts` | ソース | オーバーレイ UI の実装、エラー表示ロジック |
| error-serialization.ts | `src/bake/client/error-serialization.ts` | ソース | エラーデータのデシリアライズ |
| hmr-runtime-client.ts | `src/bake/hmr-runtime-client.ts` | ソース | errors ハンドラの登録 |
| data-view.ts | `src/bake/client/data-view.ts` | ソース | バイナリデータ読み取り |
| JavaScriptSyntaxHighlighter.ts | `src/bake/client/JavaScriptSyntaxHighlighter.ts` | ソース | コードプレビューのシンタックスハイライト |
| SerializedFailure.zig | `src/bake/DevServer/SerializedFailure.zig` | ソース | サーバーサイドのエラーシリアライズ |
| enums.ts | `src/bake/enums.ts` | ソース | `BundlerMessageLevel` 列挙型 |
