---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：1-WebSocket接続通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **本番環境での HMR 無効化**：ドキュメント化された明示的な記述がコード内に見当たらない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/websocket.ts` 123行目 - console.info メッセージ
- E-02: `src/bake/client/websocket.ts` 74-77行目 - initWebSocket 関数定義
- E-03: `src/bake/client/websocket.ts` 122-133行目 - onFirstOpen 関数
- E-04: `src/bake/client/websocket.ts` 41-54行目 - WebSocketWrapper インターフェース
- E-05: `src/bake/client/websocket.ts` 76行目 - デフォルト URL `/_bun/hmr`
- E-06: `src/bake/client/websocket.ts` 190-195行目 - WebSocket 初期化とイベントハンドラ設定
- E-07: `src/bake/client/websocket.ts` 124行目 - onStatusChange コールバック
- E-08: `src/bake/hmr-runtime-client.ts` 203-207行目 - initWebSocket 呼び出し
- E-09: `src/bake/client/websocket.ts` 153-188行目 - onClose 再接続処理
- E-10: `src/bake/client/websocket.ts` 172行目 - 再接続成功時のメッセージ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは `[Bun] Hot-module-reloading socket connected, waiting for changes...` | E-01 | ○ |
| C-02 | WebSocket 接続は `/_bun/hmr` エンドポイントに対して行われる | E-05 | ○ |
| C-03 | 初回接続時に `onFirstOpen` 関数が実行される | E-03, E-06 | ○ |
| C-04 | `console.info()` メソッドで出力される | E-01 | ○ |
| C-05 | `onStatusChange` コールバックが `true` で呼び出される | E-07 | ○ |
| C-06 | 再接続時は別の通知が使用される | E-09, E-10 | ○ |
| C-07 | `WebSocketWrapper` インターフェースでラップされる | E-04 | ○ |
| C-08 | `initWebSocket` 関数で初期化される | E-02, E-08 | ○ |
| C-09 | 送信キューのドレイン処理が行われる | E-03 (127-132行目) | ○ |
| C-10 | 接続失敗時は onClose で再接続処理が開始される | E-09 | ○ |
| C-11 | URL プロトコルは http->ws, https->wss に変換される | E-02 (62-72行目) | ○ |
| C-12 | `bun:ws:connect` イベントが発行される | E-08 (204-206行目) | ○ |
| C-13 | 固定メッセージでテンプレート変数は存在しない | E-01 | ○ |
| C-14 | HMR クライアントのエントリーポイントは hmr-runtime-client.ts | E-08 | ○ |
| C-15 | 本番環境では HMR 機能が無効化されるべき | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 本番環境での HMR 無効化に関する明示的なドキュメントまたはコード内コメントが見当たらない
  - 候補：`src/bake/DevServer.zig` / ビルド設定ファイル / Bun 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けの情報通知であり、機能的な影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] メッセージ文字列がコード内の実装と一致しているか確認
- [ ] 再接続時との挙動の違いが正しく記述されているか確認
- [ ] 本番環境での HMR 無効化に関する追加情報が必要か検討
