---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-クライアント切断通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/DevServer/HmrSocket.zig` 237-262行目 - onClose 関数
- E-02: `src/bake/DevServer/HmrSocket.zig` 242行目 - onUnsubscribe 呼び出し
- E-03: `src/bake/DevServer/HmrSocket.zig` 244行目 - inspector_connection_id チェック
- E-04: `src/bake/DevServer/HmrSocket.zig` 246行目 - dev.inspector() チェック
- E-05: `src/bake/DevServer/HmrSocket.zig` 247行目 - notifyClientDisconnected 呼び出し
- E-06: `src/bake/DevServer/HmrSocket.zig` 251-253行目 - active_route クリーンアップ
- E-07: `src/bake/DevServer/HmrSocket.zig` 255-259行目 - referenced_source_maps クリーンアップ
- E-08: `src/bake/DevServer/HmrSocket.zig` 260行目 - active_websocket_connections 削除
- E-09: `src/bake/DevServer/HmrSocket.zig` 261行目 - HmrSocket 破棄
- E-10: `src/bun.js/api/server/InspectorBunFrontendDevServerAgent.zig` 44-48行目 - notifyClientDisconnected 関数
- E-11: `src/bun.js/api/server/InspectorBunFrontendDevServerAgent.zig` 4行目 - C++ extern 宣言

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `HmrSocket.onClose` で切断処理が行われる | E-01 | ○ |
| C-02 | `onUnsubscribe` でサブスクリプション解除が行われる | E-02 | ○ |
| C-03 | `inspector_connection_id > -1` でチェックされる | E-03 | ○ |
| C-04 | `dev.inspector()` で Inspector を取得する | E-04 | ○ |
| C-05 | `agent.notifyClientDisconnected()` で通知する | E-05 | ○ |
| C-06 | `active_route` の視聴者カウントがデクリメントされる | E-06 | ○ |
| C-07 | `referenced_source_maps` の参照解除と破棄が行われる | E-07 | ○ |
| C-08 | `active_websocket_connections` から削除される | E-08 | ○ |
| C-09 | `HmrSocket` インスタンスが破棄される | E-09 | ○ |
| C-10 | `notifyClientDisconnected` は Inspector ハンドルチェックを行う | E-10 | ○ |
| C-11 | C++ バインディング経由で通知される | E-11 | ○ |
| C-12 | Inspector が null の場合は通知がスキップされる | E-04, E-10 | ○ |
| C-13 | `inspector_connection_id == -1` の場合は通知がスキップされる | E-03 | ○ |
| C-14 | `devServerId` と `connectionId` が通知される | E-05, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けの Inspector 連携機能であり、適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 切断時の通知条件が正しく記述されているか確認
- [ ] クリーンアップ処理の順序と内容が正しく記述されているか確認
- [ ] C++ バインディングとの連携が正しく記述されているか確認
