---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：11-クライアントナビゲーション通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**：Inspectorフロントエンド側の具体的なUI更新処理

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bake/DevServer/HmrSocket.zig` 107-131行目（set_url処理）
- E-02: `src/bake/DevServer/HmrSocket.zig` 264-276行目（notifyInspectorClientNavigation）
- E-03: `src/bun.js/api/server/InspectorBunFrontendDevServerAgent.zig` 68-83行目（notifyClientNavigated）
- E-04: `src/bun.js/api/server/InspectorBunFrontendDevServerAgent.zig` 1-22行目（C++外部関数宣言）
- E-05: `src/bake/DevServer/HmrSocket.zig` 12行目（inspector_connection_id定義）
- E-06: `src/bake/DevServer.zig` 49行目（inspector_server_id定義）
- E-07: `src/bake/DevServer/HmrSocket.zig` 30-40行目（onOpen処理、connection_id初期化）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 11行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クライアントがルートを移動した際にInspectorへ通知する | E-01, E-02 | ○ |
| C-02 | set_urlメッセージ受信時に発火する | E-01 | ○ |
| C-03 | BunFrontendDevServerAgentを通じてInspectorに通知される | E-03, E-04 | ○ |
| C-04 | DevServer ID、コネクションID、URL、ルートバンドルインデックスを含む | E-03 | ○ |
| C-05 | inspector_connection_idが-1より大きい場合のみ通知 | E-01, E-02 | ○ |
| C-06 | Inspectorエージェントが有効な場合のみ送信 | E-03 | ○ |
| C-07 | routeToBundleIndexSlowでルートバンドルインデックスを取得 | E-01 | ○ |
| C-08 | onOpen時にconnection_idが初期化される | E-07 | ○ |
| C-09 | C++外部関数を通じてフロントエンドに送信 | E-04 | ○ |
| C-10 | リトライは行わない | E-01, E-02 | ○ |
| C-11 | ルート未発見時はrouteBundleIdを-1として通知 | E-03 | ○ |
| C-12 | 通知種別はアプリ内通知（WebSocket経由） | E-08 | ○ |
| C-13 | notifyClientNavigated()で実装されている | E-08, E-03 | ○ |
| C-14 | 送信方式は同期 | E-01, E-03 | ○ |
| C-15 | InspectorフロントエンドがUIを更新する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-15について**: Inspectorフロントエンド側（JavaScript/DevTools）の実装コードが確認できていない
  - 候補：`src/bun.js/bindings/InspectorBunFrontendDevServerAgent.cpp` / DevTools Protocol仕様 / フロントエンドUI実装

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: ソースコードに明確な実装が存在し、動作が確認可能
- C-15のみフロントエンド実装の確認が必要だが、サーバー側の通知機能自体は正しく実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] HmrSocket.zigのset_url処理（107-131行目）が設計書の記載と一致するか確認
- [ ] notifyClientNavigatedの引数（devServerId, connectionId, url, routeBundleId）が正しく渡されているか確認
- [ ] Inspectorフロントエンド側でナビゲーション情報がどのように表示されるか確認（必要に応じて）
