---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-ホットアップデート通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**：hot_updateメッセージの詳細なペイロード形式

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bake/DevServer.zig` 全体（DevServerメイン実装）
- E-02: `src/bake/DevServer/HmrSocket.zig` 61-99行目（subscribe処理）
- E-03: `src/bake/DevServer/HmrSocket.zig` 9-10行目（active_route定義）
- E-04: `src/bake/DevServer.zig` 52-53行目（configuration_hash_key）
- E-05: `src/bake/DevServer/HotReloadEvent.zig`（ホットリロードイベント定義）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 13行目（通知定義）
- E-07: `src/bake/DevServer.zig` 68-69行目（client_graph, server_graph）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル変更時にWebSocket経由でホットアップデートを配信する | E-01, E-06 | ○ |
| C-02 | hot_updateメッセージタイプで送信される | E-06 | ○ |
| C-03 | bun_watcherでファイル変更を検知する | E-01 | ○ |
| C-04 | インクリメンタルバンドルが完了後に発火する | E-01 | ○ |
| C-05 | active_routeを設定しているクライアントに配信される | E-02, E-03 | ○ |
| C-06 | uWS Pub/Sub機能を使用して配信する | E-02 | ○ |
| C-07 | React Fast Refreshと連携して動作する | E-01, E-04 | ○ |
| C-08 | IncrementalGraphで依存関係を管理する | E-07 | ○ |
| C-09 | バンドルエラー時はエラー通知を送信する | E-01 | ○ |
| C-10 | configuration_hash_keyでバージョン管理を行う | E-04 | ○ |
| C-11 | client_graphとserver_graphの2つのグラフを持つ | E-07 | ○ |
| C-12 | route_bundlesでルートバンドル情報を管理する | E-01 | ○ |
| C-13 | IncrementalResultにバンドル結果が格納される | E-01 | ○ |
| C-14 | CSS変更は専用関数で処理される | E-06 | ○ |
| C-15 | 非同期Pub/Sub方式のためリトライなし | E-02 | ○ |
| C-16 | メッセージ構造（1バイト+4バイト+可変長）で送信される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-16について**: hot_updateメッセージの具体的なバイナリ形式が未確認
  - 候補：DevServer.zigのpublishメソッド実装 / MessageId列挙型の詳細

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: HMR機能全体の実装は明確で、DevServer.zigに包括的な処理が存在
- メッセージペイロードの詳細形式は、hmr-runtime-client.ts側の実装と照合が必要

## 6) レビュアーチェックリスト（最小）

- [ ] DevServer.zigのpublishメソッドでhot_updateメッセージがどのように構築されるか確認
- [ ] HmrSocket.zigのsubscribe処理が正しくトピック購読を行っているか確認
- [ ] hmr-runtime-client.tsでhot_updateメッセージがどのようにパースされるか確認
- [ ] IncrementalGraphの変更追跡ロジックが正しく動作するか確認
