---
generated_at: 2026-01-27 10:38:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-テスト同期通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bake/DevServer/HmrSocket.zig` 134-171行目（testing_batch_events処理）
- E-02: `src/bake/DevServer.zig` 127-139行目（testing_batch_eventsのunion型定義）
- E-03: `src/bake/DevServer.zig` 126行目（testing_watch_synchronizationトピック）
- E-04: `src/bake/DevServer/HmrSocket.zig` 140-143行目（状態コード0送信）
- E-05: `src/bake/DevServer/HmrSocket.zig` 156-159行目（状態コード2送信）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 14行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストモード時にファイル監視の同期イベントを通知する | E-01, E-06 | ○ |
| C-02 | testing_watch_synchronizationトピックで送信する | E-03, E-04, E-05 | ○ |
| C-03 | testing_batch_eventsは3状態のunion型 | E-02 | ○ |
| C-04 | disabled/enable_after_bundle/enabledの3状態がある | E-02 | ○ |
| C-05 | バッチモード開始時に状態コード0を送信 | E-04 | ○ |
| C-06 | 変更なし時に状態コード2を送信 | E-05 | ○ |
| C-07 | current_bundleがある場合はenable_after_bundleに遷移 | E-01 | ○ |
| C-08 | enable_after_bundle中にメッセージを受けるとデバッグアサート | E-01 | ○ |
| C-09 | entry_pointsが空の場合は状態コード2を送信 | E-01, E-05 | ○ |
| C-10 | entry_pointsがある場合はstartAsyncBundleを実行 | E-01 | ○ |
| C-11 | メッセージ構造は1バイトID + 1バイト状態コード | E-04, E-05 | ○ |
| C-12 | テスト専用機能でありbake-harness.tsと連携 | E-06 | ○ |
| C-13 | リリースビルドではpanicを起こさない設計 | E-01 | ○ |
| C-14 | フレーキーテスト防止のための同期メカニズム | E-02, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: 全主張に対してソースコードからの明確な根拠が存在
- テスト専用機能のため、本番環境への影響はなし

## 6) レビュアーチェックリスト（最小）

- [ ] HmrSocket.zigのtesting_batch_events処理（134-171行目）が設計書の記載と一致するか確認
- [ ] testing_batch_eventsの状態遷移が正しく実装されているか確認
- [ ] 状態コード（0/1/2）の意味が一貫しているか確認
