---
generated_at: 2026-01-27 10:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-IPCメッセージ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：Windowsでのファイルディスクリプタ送信の実装状況

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/ipc.zig` 全体（IPC実装）
- E-02: `src/bun.js/ipc.zig` 34-49行目（Mode列挙型定義）
- E-03: `src/bun.js/ipc.zig` 74-84行目（advanced.IPCMessageType）
- E-04: `src/bun.js/ipc.zig` 142-165行目（advanced.serialize）
- E-05: `src/bun.js/ipc.zig` 257-284行目（json.serialize）
- E-06: `src/bun.js/ipc.zig` 443-511行目（SendQueue構造体）
- E-07: `src/bun.js/ipc.zig` 968-1043行目（doSend関数）
- E-08: `src/bun.js/ipc.zig` 947行目（MAX_HANDLE_RETRANSMISSIONS = 3）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 15行目（通知定義）
- E-10: `src/bun.js/bindings/IPC.cpp`（C++バインディング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロセス間でシリアライズされたメッセージを送受信する | E-01, E-09 | ○ |
| C-02 | jsonモードとadvancedモードをサポート | E-02 | ○ |
| C-03 | advancedモードはBun専用で効率的 | E-02, E-04 | ○ |
| C-04 | jsonモードはNode.js互換 | E-02, E-05 | ○ |
| C-05 | advancedモードのヘッダーは5バイト（1+4） | E-03 | ○ |
| C-06 | メッセージタイプは Version/SerializedMessage/SerializedInternalMessage | E-03 | ○ |
| C-07 | JSONモードは改行区切り | E-05 | ○ |
| C-08 | SendQueueでメッセージキューを管理 | E-06 | ○ |
| C-09 | process.send()/subprocess.send()で送信 | E-07 | ○ |
| C-10 | IPCチャネル閉鎖時はERR_IPC_CHANNEL_CLOSEDエラー | E-07 | ○ |
| C-11 | ハンドル送信時は最大3回リトライ | E-08 | ○ |
| C-12 | SerializedScriptValueでシリアライズ（advancedモード） | E-04 | ○ |
| C-13 | forCrossProcessTransferオプションを使用 | E-04 | ○ |
| C-14 | ACK/NACKプロトコルをサポート | E-01 | ○ |
| C-15 | Node.jsのchild_process.fork()と互換 | E-09 | ○ |
| C-16 | clusterモジュールと互換 | E-09 | ○ |
| C-17 | 双方向通信（親→子、子→親）が可能 | E-07 | ○ |
| C-18 | Windowsではファイルディスクリプタ送信は未実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-18について**: Windows環境でのFD送信の実装状況が未確認
  - 候補：`src/bun.js/ipc.zig` 838-839行目のTODOコメント

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: IPC実装の主要部分は明確で、ipc.zigに完全なコードが存在
- WindowsのFD送信はTODOコメントで未実装が示唆されている

## 6) レビュアーチェックリスト（最小）

- [ ] ipc.zigのdoSend関数（968-1043行目）が設計書の記載と一致するか確認
- [ ] jsonモードとadvancedモードのシリアライズ形式が正しいか確認
- [ ] MAX_HANDLE_RETRANSMISSIONS（3回）の値が正しいか確認
- [ ] Windows環境でのFD送信の制限事項を確認
