---
generated_at: 2026-01-27 10:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-IPC NACK通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/ipc.zig` 138-140行目（advanced.getNackPacket）
- E-02: `src/bun.js/ipc.zig` 179-181行目（json.getNackPacket）
- E-03: `src/bun.js/ipc.zig` 947行目（MAX_HANDLE_RETRANSMISSIONS = 3）
- E-04: `src/bun.js/ipc.zig` 447行目（retry_count定義）
- E-05: `src/bun.js/ipc.zig` 1101-1118行目（NODE_HANDLEケースのNACK送信）
- E-06: `src/bun.js/ipc.zig` 655-676行目（onAckNackのnackケース）
- E-07: `src/bun.js/ipc.zig` 667-673行目（警告発行処理）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 17行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPCハンドル否定応答を送信する | E-05, E-08 | ○ |
| C-02 | NODE_HANDLE_NACKメッセージで応答する | E-01, E-02, E-08 | ○ |
| C-03 | incoming_fdがnullの場合にNACKを送信 | E-05 | ○ |
| C-04 | jsonモードは '{"cmd":"NODE_HANDLE_NACK"}\n' | E-02 | ○ |
| C-05 | advancedモードは固定バイト列 | E-01 | ○ |
| C-06 | 送信側はNACK受信でリトライを試みる | E-06 | ○ |
| C-07 | 最大リトライ回数は3回 | E-03 | ○ |
| C-08 | retry_countでリトライ回数を管理 | E-04, E-06 | ○ |
| C-09 | リトライ時はメッセージをキュー先頭に再挿入 | E-06 | ○ |
| C-10 | 3回失敗で警告を発行 | E-07 | ○ |
| C-11 | 警告名はSentHandleNotReceivedWarning | E-07 | ○ |
| C-12 | NACKの場合はmessageイベントが発火しない | E-05 | ○ |
| C-13 | NACK自体はリトライしない | E-05 | ○ |
| C-14 | Node.jsのNODE_HANDLE_NACKと互換 | E-02, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: NACK処理とリトライロジックは明確に実装されており、ipc.zigに完全なコードが存在

## 6) レビュアーチェックリスト（最小）

- [ ] handleIPCMessage内のNODE_HANDLEケース（1101-1118行目）でNACK送信が正しく行われているか確認
- [ ] onAckNackのnackケース（655-676行目）でリトライロジックが正しいか確認
- [ ] MAX_HANDLE_RETRANSMISSIONS（947行目）の値が3であることを確認
- [ ] 警告メッセージ「SentHandleNotReceivedWarning」が正しく発行されるか確認
