---
generated_at: 2026-01-27 10:52:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-postMessage通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**：Worker → メインスレッドのpostMessage実装詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/bindings/webcore/Worker.cpp` 234-259行目（postMessage実装）
- E-02: `src/bun.js/bindings/webcore/Worker.cpp` 236-237行目（TerminatedFlagチェック）
- E-03: `src/bun.js/bindings/webcore/SerializedScriptValue.cpp`（シリアライズ処理）
- E-04: `src/bun.js/bindings/webcore/MessagePort.cpp` 157-188行目（postMessage）
- E-05: `src/bun.js/bindings/webcore/Worker.cpp` 251-258行目（タスク送信）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 18行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebWorker間でメッセージを送信する | E-01, E-06 | ○ |
| C-02 | postMessage APIで実装される | E-01, E-06 | ○ |
| C-03 | SerializedScriptValueでシリアライズする | E-01, E-03 | ○ |
| C-04 | StructuredCloneアルゴリズムを使用 | E-03 | ○ |
| C-05 | Worker終了済みの場合はInvalidStateError | E-02 | ○ |
| C-06 | MessagePort.disentanglePortsでポートを切り離す | E-01 | ○ |
| C-07 | postTaskToWorkerGlobalScopeでタスク送信 | E-05 | ○ |
| C-08 | MessageEventでハンドラに渡される | E-05 | ○ |
| C-09 | 転送可能オブジェクトをサポート | E-01 | ○ |
| C-10 | DataCloneErrorでシリアライズエラーを報告 | E-01 | ○ |
| C-11 | MessagePort.entanglePortsで受信側ポート作成 | E-05 | ○ |
| C-12 | dispatchEventでmessageイベント発火 | E-05 | ○ |
| C-13 | Node.js worker_threadsとの互換性 | E-06 | ○ |
| C-14 | 非同期でタスクキュー経由で送信 | E-05 | ○ |
| C-15 | Worker → メインスレッドはself.postMessage()で送信 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-15について**: Worker側からメインスレッドへのpostMessage実装の詳細が未確認
  - 候補：`src/bun.js/bindings/webcore/BunWorkerGlobalScope.cpp` / Worker側のpostMessage実装

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: メインスレッド → Worker方向の実装は明確
- Worker → メインスレッド方向の実装詳細は追加調査が必要

## 6) レビュアーチェックリスト（最小）

- [ ] Worker.cppのpostMessage（234-259行目）が設計書の記載と一致するか確認
- [ ] SerializedScriptValue.createでシリアライズが正しく行われるか確認
- [ ] MessagePort.disentanglePorts/entanglePortsの動作を確認
- [ ] Worker側からメインスレッドへのpostMessage実装を確認
