---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-MessagePort通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**：MessagePortChannelRegistryの詳細な実装

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/bindings/webcore/MessagePort.cpp` 157-188行目（postMessage）
- E-02: `src/bun.js/bindings/webcore/MessagePort.cpp` 86-102行目（notifyMessageAvailable）
- E-03: `src/bun.js/bindings/webcore/MessagePort.cpp` 246-295行目（dispatchMessages）
- E-04: `src/bun.js/bindings/webcore/MessagePort.cpp` 111-129行目（コンストラクタ）
- E-05: `src/bun.js/bindings/webcore/MessagePort.cpp` 221-233行目（start関数）
- E-06: `src/bun.js/bindings/webcore/MessagePort.h`（MessagePort定義）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 19行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MessagePort経由でメッセージを送受信する | E-01, E-07 | ○ |
| C-02 | notifyMessageAvailable()で実装される | E-02, E-07 | ○ |
| C-03 | m_identifier/m_remoteIdentifierでポートを識別 | E-04, E-06 | ○ |
| C-04 | SerializedScriptValueでシリアライズ | E-01 | ○ |
| C-05 | isEntangled()でペアリング状態を確認 | E-01 | ○ |
| C-06 | MessagePortChannelProvider.postMessageToRemoteで送信 | E-01 | ○ |
| C-07 | notifyMessageAvailableはスレッド安全 | E-02 | ○ |
| C-08 | ScriptExecutionContext.ensureOnContextThreadで配信 | E-02 | ○ |
| C-09 | dispatchMessagesでメッセージ配信 | E-03 | ○ |
| C-10 | start()を呼ばないとメッセージが配信されない | E-05 | ○ |
| C-11 | MessageEventでイベント発火 | E-03 | ○ |
| C-12 | disentanglePorts/entanglePortsでポート転送 | E-01 | ○ |
| C-13 | 自身のポートを転送するとDataCloneError | E-01 | ○ |
| C-14 | allMessagePortsで全ポートを管理 | E-04 | ○ |
| C-15 | portToContextIdentifierでスレッド安全な配信 | E-02 | ○ |
| C-16 | MessagePortChannelRegistryがグローバルレジストリ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-16について**: MessagePortChannelRegistryの詳細な実装が未確認
  - 候補：`src/bun.js/bindings/webcore/MessagePortChannelRegistry.cpp` の詳細調査

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク**: MessagePort実装の主要部分は明確で、WebKit由来のコードが正しく移植されている
- レジストリの詳細は追加調査が必要だが、機能には影響しない

## 6) レビュアーチェックリスト（最小）

- [ ] MessagePort.cppのpostMessage（157-188行目）が設計書の記載と一致するか確認
- [ ] notifyMessageAvailable（86-102行目）のスレッド安全性を確認
- [ ] dispatchMessages（246-295行目）でMessageEventが正しく作成されるか確認
- [ ] start()未呼び出し時のメッセージ保留動作を確認
