---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-WebSocket切断通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が存在するため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/client/websocket.ts` 155行目 - console.warn メッセージ
- E-02: `src/bake/client/websocket.ts` 153-188行目 - onClose 関数
- E-03: `src/bake/client/websocket.ts` 154行目 - onStatusChange(false) 呼び出し
- E-04: `src/bake/client/websocket.ts` 157行目 - 1秒待機処理
- E-05: `src/bake/client/websocket.ts` 160行目 - 送信キュークリア
- E-06: `src/bake/client/websocket.ts` 162-188行目 - 再接続ループ
- E-07: `src/bake/client/websocket.ts` 163行目 - closed フラグ確認
- E-08: `src/bake/client/websocket.ts` 169行目 - 新規 WebSocket 作成
- E-09: `src/bake/client/websocket.ts` 172行目 - Reconnected メッセージ
- E-10: `src/bake/client/websocket.ts` 186行目 - wait() 関数呼び出し
- E-11: `src/bake/client/websocket.ts` 3-37行目 - wait 関数定義
- E-12: `src/bake/client/websocket.ts` 80行目 - closed フラグ定義
- E-13: `src/bake/client/websocket.ts` 194行目 - onclose ハンドラ設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは `[Bun] Hot-module-reloading socket disconnected, reconnecting...` | E-01 | ○ |
| C-02 | `console.warn()` メソッドで出力される | E-01 | ○ |
| C-03 | `onclose` イベントで発火する | E-02, E-13 | ○ |
| C-04 | `onStatusChange(false)` が呼び出される | E-03 | ○ |
| C-05 | 切断後1秒待機してから再接続を開始する | E-04 | ○ |
| C-06 | 送信キューがクリアされる | E-05 | ○ |
| C-07 | 再接続は無限ループで継続的に試行される | E-06 | ○ |
| C-08 | `closed` フラグが true の場合は再接続を中止する | E-07, E-12 | ○ |
| C-09 | 再接続時に新しい WebSocket インスタンスが作成される | E-08 | ○ |
| C-10 | 再接続成功時は `[Bun] Reconnected` が表示される | E-09 | ○ |
| C-11 | 再接続失敗時は `wait()` で待機後にリトライ | E-10 | ○ |
| C-12 | `wait()` 関数はフォーカス状態で待機時間を調整する | E-11 | ○ |
| C-13 | 再接続リトライ間隔は最大2.5秒 | E-11 (31行目: 2_500) | ○ |
| C-14 | `bun:ws:disconnect` イベントが発行される | E-03, hmr-runtime-client.ts 204-206行目 | ○ |
| C-15 | 固定メッセージでテンプレート変数は存在しない | E-01 | ○ |
| C-16 | 再接続は同一の `/_bun/hmr` エンドポイントに対して行われる | E-08 (url変数使用) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は開発環境向けの警告通知であり、機能的な影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] メッセージ文字列がコード内の実装と一致しているか確認
- [ ] 再接続ロジックの wait() 関数の動作が正しく記述されているか確認
- [ ] closed フラグによる再接続中止の挙動が正しく記述されているか確認
