---
generated_at: 2026-01-27 18:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-Bunリロード可能通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**：デバッガフロントエンドの期待されるアクション - 外部ツールの動作は推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/bindings/BunDebugger.cpp` 行529-543（BunDebugger__willHotReload関数）
- E-02: `src/bun.js/bindings/BunDebugger.cpp` 行539（メッセージ文字列）
- E-03: `src/bun.js/bindings/BunDebugger.cpp` 行29-30（inspectorConnectionsの定義）
- E-04: `src/bun.js/bindings/BunDebugger.cpp` 行200-206（sendMessageToFrontend実装）
- E-05: `src/bun.js/bindings/BunDebugger.cpp` 行327-339（sendMessageToDebuggerThread実装）
- E-06: `src/bun.js/bindings/BunDebugger.cpp` 行65-70（ConnectionStatus定義）
- E-07: `src/bun.js/bindings/BunDebugger.cpp` 行535（postTaskConcurrently使用）
- E-08: `src/bun.js/bindings/BunDebugger.cpp` 行531-533（nullチェック）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 行22（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デバッガへBun.canReloadメッセージを送信する | E-02 | ○ |
| C-02 | ホットリロード実行直前に通知される | E-01 | ○ |
| C-03 | 全てのアクティブなInspector接続に送信 | E-01, E-03 | ○ |
| C-04 | JSON形式のメッセージ | E-02 | ○ |
| C-05 | 非同期送信（postTaskConcurrently） | E-07 | ○ |
| C-06 | debuggerScriptExecutionContextのnullチェック | E-08 | ○ |
| C-07 | sendMessageToFrontendでメッセージ送信 | E-04 | ○ |
| C-08 | sendMessageToDebuggerThreadでキューイング | E-05 | ○ |
| C-09 | ConnectionStatusの定義 | E-06 | ○ |
| C-10 | inspectorConnectionsはUncheckedKeyHashMap | E-03 | ○ |
| C-11 | リトライなし | E-01 | ○ |
| C-12 | 接続ごとにメッセージを送信 | E-01 | ○ |
| C-13 | ロック取得してスレッドセーフに処理 | E-01 | ○ |
| C-14 | メッセージ内容は固定文字列 | E-02 | ○ |
| C-15 | WebKit Inspectorプロトコルの拡張 | E-02, E-09 | ○ |
| C-16 | 開発環境専用機能 | E-09 | ○ |
| C-17 | Chrome DevTools, VS Code等がサポート | E-09 | ○ |
| C-18 | デバッガフロントエンドはブレークポイント等を保存する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：デバッガフロントエンド（Chrome DevTools, VS Code等）がBun.canReloadメッセージをどのように処理するかは、外部ツールの実装に依存するため、ソースコードからは確認できない
  - 候補：Chrome DevTools公式ドキュメント / VS Code Debugger Extension API / Bunの公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全体的に高い信頼度
- 外部ツールの動作に関する記述（C-18）は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] BunDebugger.cppの行番号が現在のソースと一致しているか確認
- [ ] メッセージ文字列 `{"method":"Bun.canReload"}` が正しいか確認
- [ ] デバッガフロントエンドの期待される動作について、Bun公式ドキュメントと照合
